/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.automata.DFA;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.automata.dfa.ConvertedRangeDFA;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.RegexParseException;
import net.morilib.automata.nfa.RegexpParser;
import net.morilib.nina.DFABuilder;
import net.morilib.nina.LRObject;
import net.morilib.nina.NFABuilder;
import net.morilib.nina.Nina;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaConsole;
import net.morilib.nina.NinaException;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaSubautomata;
import net.morilib.nina.Quadro;
import net.morilib.nina.lib.NinaLibrary;
import net.morilib.range.CharSetException;
import net.morilib.range.CharSets;
import net.morilib.regex.dfa.CharSet;
import net.morilib.regex.dfa.RegexParser;

public class NinaParser {
    private static final Pattern ANYS = Pattern.compile("\\.([0-9]+)");
    private static final Pattern CHSS = Pattern.compile("\\[(.*)\\]([0-9]+)");
    private static final Pattern REPS = Pattern.compile("([^\\+]*)\\+(.*)");
    private static final Pattern LB_Q = Pattern.compile("'(.*)'");
    private static final Pattern LB_D = Pattern.compile("\"(.*)\"");
    private static final Pattern LB_DI = Pattern.compile("\"(.*)\"i");
    private static final Pattern LB_S = Pattern.compile("\\[(.*)\\]");
    private static final Pattern LB_R = Pattern.compile("`(.*)`");
    private static final Pattern LB_RE = Pattern.compile("/(.*)/");
    private static final Pattern LB_L = Pattern.compile("\\$\\{(.*)\\}");
    private static final Pattern LD_H = Pattern.compile("0x([0-9A-Fa-f]{1,4})");
    private static final Pattern LD_O = Pattern.compile("01?[0-7]{1,5}");
    private static final Pattern LD_D = Pattern.compile("[0-9]+");
    private static final Pattern DIGI = Pattern.compile(":(signed-)?digits-([1-8*])");
    private static final Pattern DIGH = Pattern.compile(":hex-(8|16|32|\\*)");
    private static final Pattern DIGO = Pattern.compile(":oct-(8|16|32|\\*)");
    private static final Pattern INDT = Pattern.compile(":indent(<=?|>=?|==|!=)([\\+\\-][0-9]+)?");
    private static final Pattern FORM = Pattern.compile("%([D]?)([0-9]*)([efgsdixXo]|\\[((\\\\\\]|[^\\]])+)\\])");
    private static final String FLOT = ":float";
    private static final String IJAV = ":identifier-Java";
    private static final String ID_C = ":identifier-C";
    private static final String ATOMIC = "?>";
    private static final String NO_CAPTURE = "?:";
    private static final String LOOKAHEAD = "?=";
    private static final String LOOKAHEAD_NEGATIVE = "?!";
    private static final String DISABLE_SET_OPERATION = "disableSetOperation";
    private static final String DISABLE_TURN_BY_SLASH = "disableTurnBySlash";
    private static final String ENABLE_REGEX_BY_BACKQUOTE = "enableRegexByBackquote";
    private static final String NL = System.getProperty("line.separator");
    private static final int ITERATION;
    static final String STARTSYM = "S";
    static final String DEADSYM = "D";
    static final int _PAUSE = 1;
    static final int _PRINT = 2;
    static final Object _FRAME1;
    static final Object _FRAME2;
    private Map<String, String> pragmas = new HashMap<String, String>();
    private Quadro q;
    private S etat = S.INIT;
    Map<String, String> params = new HashMap<String, String>();
    NinaSubautomata subfas;
    private List<String> libs = Collections.emptyList();
    private StringBuffer buf = new StringBuffer();
    private StringBuffer bf2 = new StringBuffer();
    private StringWriter defs;
    private PrintWriter def;
    private Class<?> type = Character.TYPE;
    private NinaAction action;
    private NinaConsole console;
    private NinaConsole infoput;
    private List<String> lst;
    private boolean enddead = false;
    private int nestlv;
    private int pause;
    private int quote;
    private int chr;
    private int counter;
    private int allCounter;
    private int regX;
    private int regY;
    private int quoteFlag;
    private int seqFlag;
    private Quadro.Direction todir;

    static {
        String its = System.getProperty("net.morilib.nina.maxiteration");
        ITERATION = its != null ? Integer.parseInt(its) : ((its = System.getenv("NINA_ITERATION")) != null ? Integer.parseInt(its) : 5000000);
        _FRAME1 = Character.valueOf('x');
        _FRAME2 = Character.valueOf('X');
    }

    NinaParser(Quadro q, NinaAction action, Map<String, String> prms, NinaSubautomata subs, NinaConsole cons, NinaConsole info) {
        this.q = q;
        this.action = action;
        this.params = new HashMap<String, String>(prms);
        this.subfas = subs;
        this.console = cons;
        this.infoput = info;
    }

    public NinaAction compileSubautomaton(String n, NinaAction action, Map<String, String> prms, NinaSubautomata subs, String qtype) {
        InputStream in = null;
        try {
            this.console.print("process", n);
            String s = Nina.getFAName(this.subfas, n);
            Quadro q = this.q.getSubQuadro(n);
            if (q != null) {
                q = q.prototype(this.q);
            } else {
                in = Nina.findLib(n, this.libs);
                if (in != null) {
                    q = Quadro.read(s, new InputStreamReader(in), this.libs);
                } else {
                    in = NinaLibrary.loadLibrary(n);
                    if (in != null) {
                        q = Quadro.read(s, new InputStreamReader(in), this.libs);
                    } else {
                        throw new NinaException("subautomatonnotfound", n);
                    }
                }
            }
            if (qtype != null) {
                q.type = qtype;
            }
            NinaAction r = NinaParser.compile(q, action, this.libs, prms, subs, this.console, this.infoput, this.pause);
            this.console.print("processed", n);
            NinaAction ninaAction = r;
            return ninaAction;
        }
        catch (IOException e) {
            throw new NinaException(e, "ioerror", new Object[0]);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new NinaException(e, "ioerror", new Object[0]);
                }
            }
        }
    }

    static NinaAction compile(Quadro q, NinaAction action, List<String> libs, Map<String, String> prms, NinaSubautomata subs, NinaConsole cons, NinaConsole info, int p) {
        NinaAction o;
        NinaParser c = new NinaParser(q, action, prms, subs, cons, info);
        try {
            if (libs != null) {
                c.libs = libs;
            }
            c.allCounter = 0;
            while ((o = c.step()) == null) {
                if ((p & 2) == 0) continue;
                if ((p & 1) != 0 && System.in.read() == 13) {
                    System.in.read();
                }
                c.printTrace(System.out);
            }
            if (action == null && c.action instanceof DFABuilder) {
                NinaAction a;
                for (Map.Entry<String, LRObject> t : q.getLRObjects().entrySet()) {
                    LRObject l = t.getValue();
                    int z = l.howManyShiftReduceConflicts();
                    if (z > 0) {
                        info.pwarn("lrshiftreduceconflict", z, t.getKey());
                    }
                    if ((z = l.howManyReduceReduceConflicts()) > 0) {
                        info.pwarn("lrreducereduceconflict", z, t.getKey());
                    }
                    for (String s : l.getSubautomata().keySet()) {
                        a = c.compileSubautomaton(s, new DFABuilder(), c.params, c.subfas, null);
                        c.subfas.put(s, a);
                    }
                    String x = l.getDefinition().getLexerName();
                    if (x == null || x.length() <= 0) continue;
                    a = c.compileSubautomaton(x, new NFABuilder(), c.params, c.subfas, null);
                    c.subfas.put(x, a);
                }
                if (q.lexer != null && !c.subfas.containsKey(q.lexer)) {
                    a = c.compileSubautomaton(q.lexer, new NFABuilder(), c.params, c.subfas, q.ltype);
                    c.subfas.put(q.lexer, a);
                }
                q.checkRequire();
            }
        }
        catch (IOException e) {
            throw new NinaException(e, "ioerror", new Object[0]);
        }
        return o;
    }

    public static NinaAction complie(Quadro q, List<String> libs, Map<String, String> prms, NinaSubautomata subs, NinaConsole cons, NinaConsole info) {
        return NinaParser.compile(q, null, libs != null ? new ArrayList<String>(libs) : null, prms, subs, cons, info, 0);
    }

    public static NinaAction complie(Quadro q, Map<String, String> prms, NinaSubautomata subs, NinaConsole cons, NinaConsole info) {
        return NinaParser.compile(q, null, null, prms, subs, cons, info, 0);
    }

    private String getstr(char c) {
        char[] a = new char[]{c};
        return new String(a);
    }

    private void metBord(char c) {
        if (this.type.equals(Character.TYPE)) {
            int x = Nina.prendCharcode(this.q.getCharset(), c);
            this.action.setEdge(this.q, x);
        } else {
            String s = this.getstr(c);
            String t = this.q.getAlias(s);
            if (t != null) {
                this.metBord(t, 39, -1);
            } else if (this.type.equals(String.class)) {
                this.action.setEdge(this.q, s);
            } else if (this.type.equals(Class.class)) {
                this.action.setEdge(this.q, Character.valueOf(c));
            } else {
                throw new ClassCastException();
            }
        }
    }

    private void metBord(String s, int qc, int qf) {
        if (this.type.equals(Character.TYPE)) {
            if (s.length() == 0) {
                throw new NinaException("emptystring", new Object[0]);
            }
            if (s.length() == 1 && qc == 39) {
                Integer c = Nina.prendCharcode(this.q.getCharset(), s.charAt(0));
                this.action.setEdge(this.q, c);
            } else {
                if (qc == 34) {
                    this.q.options.put("enableLookahead", "true");
                }
                this.action.setEdgeCharSequence(this.q, s, qc, qf);
            }
        } else {
            String t = this.q.getAlias(s);
            if (t != null) {
                this.metBord(t, qc, qf);
            } else if (this.type.equals(String.class)) {
                this.action.setEdge(this.q, s);
            } else if (this.type.equals(Class.class)) {
                this.action.setEdge(this.q, s);
            } else if (this.type.isInstance(Integer.class) || this.type.equals(Integer.TYPE)) {
                this.action.setEdge(this.q, Integer.valueOf(s));
            } else if (this.type.isInstance(Long.class) || this.type.equals(Long.TYPE)) {
                this.action.setEdge(this.q, Long.valueOf(s));
            } else if (this.type.isInstance(Float.class) || this.type.equals(Float.TYPE)) {
                this.action.setEdge(this.q, Double.valueOf(s));
            } else if (this.type.isInstance(Double.class) || this.type.equals(Double.TYPE)) {
                this.action.setEdge(this.q, Double.valueOf(s));
            } else if (this.type.isInstance(BigInteger.class)) {
                this.action.setEdge(this.q, new BigInteger(s));
            } else if (this.type.isInstance(BigDecimal.class)) {
                this.action.setEdge(this.q, new BigDecimal(s));
            } else {
                throw new ClassCastException();
            }
        }
    }

    private boolean setEdgeFormat(String s) {
        int l;
        Matcher m = FORM.matcher(s);
        if (!m.matches()) {
            return false;
        }
        int n = l = m.group(2).equals("") ? -1 : Integer.parseInt(m.group(2));
        if (m.group(4) != null) {
            this.action.setEdgeStringSequence(this.q, l, m.group(4));
            return true;
        }
        if (m.group(3).equals("f") || m.group(3).equals("e") || m.group(3).equals("g")) {
            this.action.setEdgeFloat(this.q);
            return true;
        }
        if (m.group(3).equals("s")) {
            this.action.setEdgeStringSequence(this.q, l, "\\S");
            return true;
        }
        if (m.group(3).equals("d") || m.group(3).equals("i")) {
            this.action.setEdgeFormatInteger(this.q, l, m.group(1));
            return true;
        }
        if (m.group(3).equals("x") || m.group(3).equals("X")) {
            this.action.setEdgeFormatHex(this.q, l, m.group(1));
            return true;
        }
        if (m.group(3).equals("o")) {
            this.action.setEdgeFormatOct(this.q, l, m.group(1));
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void metBordRes(String s, Map<String, String> mp) {
        if (s.startsWith("ex:")) {
            this.action.setUserEdge(this.q, s.substring(3));
            return;
        } else if (s.startsWith("dy:")) {
            this.action.setEdgeDynamic(this.q, s.substring(3));
            return;
        } else if (s.startsWith("g:")) {
            this.action.setEdgeGrammar(this.q, s.substring(2));
            return;
        } else {
            Matcher m = DIGI.matcher(s);
            if (m.matches()) {
                if (!this.type.equals(Character.TYPE)) throw new NinaException(this, "invalidalphabettype", new Object[0]);
                if (m.group(2).equals("*")) {
                    this.action.setEdgeDigits(this.q, -1, m.group(1) != null);
                    return;
                } else {
                    this.action.setEdgeDigits(this.q, Integer.parseInt(m.group(2)), m.group(1) != null);
                }
                return;
            } else {
                m = DIGH.matcher(s);
                if (m.matches()) {
                    if (!this.type.equals(Character.TYPE)) throw new NinaException(this, "invalidalphabettype", new Object[0]);
                    if (m.group(1).equals("*")) {
                        this.action.setEdgeHexadecimal(this.q, -1);
                        return;
                    } else {
                        this.action.setEdgeHexadecimal(this.q, Integer.parseInt(m.group(1)));
                    }
                    return;
                } else {
                    m = DIGO.matcher(s);
                    if (m.matches()) {
                        if (!this.type.equals(Character.TYPE)) throw new NinaException(this, "invalidalphabettype", new Object[0]);
                        if (m.group(1).equals("*")) {
                            this.action.setEdgeOctal(this.q, -1);
                            return;
                        } else {
                            this.action.setEdgeOctal(this.q, Integer.parseInt(m.group(1)));
                        }
                        return;
                    } else {
                        m = INDT.matcher(s);
                        if (m.matches()) {
                            String t = m.group(2);
                            if (t == null) {
                                this.action.setEdgeIndent(this.q, m.group(1), 0);
                                return;
                            } else {
                                t = t.replaceFirst("^\\+", "");
                                this.action.setEdgeIndent(this.q, m.group(1), Integer.parseInt(t));
                            }
                            return;
                        } else if (s.equals(FLOT)) {
                            this.action.setEdgeFloat(this.q);
                            return;
                        } else if (s.equals(IJAV)) {
                            this.action.setEdgeIdentifier(this.q, "Java");
                            return;
                        } else if (s.equals(ID_C)) {
                            this.action.setEdgeIdentifier(this.q, "C");
                            return;
                        } else if (s.indexOf("$c") >= 0 || s.indexOf("__c__") >= 0) {
                            this.action.setUserEdge(this.q, s);
                            return;
                        } else {
                            if (s.indexOf(37) >= 0 && this.setEdgeFormat(s)) return;
                            m = ANYS.matcher(s);
                            if (m.matches()) {
                                this.action.setEdgeSequence(this.q, null, Integer.valueOf(m.group(1)));
                                return;
                            } else {
                                m = CHSS.matcher(s);
                                if (m.matches()) {
                                    if (this.q.isOptionDefined(DISABLE_SET_OPERATION)) {
                                        this.action.setEdgeSequence(this.q, CharSets.parse(m.group(1)), Integer.valueOf(m.group(2)));
                                        return;
                                    } else {
                                        this.action.setEdgeSequence(this.q, CharSet.parseRange(m.group(1)), Integer.valueOf(m.group(2)));
                                    }
                                    return;
                                } else {
                                    m = REPS.matcher(s);
                                    if (m.matches()) {
                                        String t;
                                        String v = m.group(1);
                                        if (!this.subfas.containsKey(v)) {
                                            this.subfas.put(v, null);
                                            this.compileSubautomaton(v, this.action, mp, this.subfas, null);
                                        }
                                        if ((t = m.group(2)) == null) {
                                            this.action.setEdgeRepeatedResource(this.q, v, null);
                                            return;
                                        } else if (!this.type.equals(Character.TYPE)) {
                                            this.action.setEdgeRepeatedResource(this.q, v, t);
                                            return;
                                        } else if (t.length() < 2) {
                                            this.action.setEdgeRepeatedResource(this.q, v, t.toCharArray());
                                            return;
                                        } else if (t.charAt(0) == '\"' && t.charAt(t.length() - 1) == '\"') {
                                            this.action.setEdgeRepeatedResource(this.q, v, t.substring(1, t.length() - 1).toCharArray());
                                            return;
                                        } else if (t.charAt(0) == '/' && t.charAt(t.length() - 1) == '/') {
                                            try {
                                                t = t.substring(1, t.length() - 1);
                                                NFAObject<Object, NFAState, Integer> n = RegexParser.parse(t);
                                                DFA<Object, NFAState, Integer> d = ConvertedRangeDFA.convertDFA(n);
                                                this.action.setEdgeRepeatedResource(this.q, v, d);
                                                return;
                                            }
                                            catch (RegexParseException e) {
                                                throw new NinaException("invalidregex", new Object[0]);
                                            }
                                        } else if (t.charAt(0) == '`' && t.charAt(t.length() - 1) == '`' && this.q.isOptionDefined(ENABLE_REGEX_BY_BACKQUOTE)) {
                                            try {
                                                t = t.substring(1, t.length() - 1);
                                                NFAState x = new NFAState(){};
                                                NFAObject n = RegexpParser.parse(t, x);
                                                DFA d = ConvertedRangeDFA.convertDFA(n);
                                                this.action.setEdgeRepeatedResource(this.q, v, d);
                                                return;
                                            }
                                            catch (RegexParseException e) {
                                                throw new NinaException("invalidregex", new Object[0]);
                                            }
                                        } else {
                                            this.action.setEdgeRepeatedResource(this.q, v, t.toCharArray());
                                        }
                                        return;
                                    } else {
                                        String t = Nina.getFAName(this.subfas, s);
                                        if (this.action instanceof DFABuilder && !this.subfas.containsKey(t)) {
                                            this.subfas.put(t, null);
                                            this.compileSubautomaton(t, this.action, mp, this.subfas, null);
                                        }
                                        this.action.setEdgeResource(this.q, this, t, mp, this.subfas);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void metBordCharset(String s) {
        try {
            if (!this.type.equals(Character.TYPE)) {
                throw new ClassCastException();
            }
            if (this.q.isOptionDefined(DISABLE_SET_OPERATION)) {
                this.action.setEdge(this.q, CharSets.parse(s, this.q.getCharset()));
            } else {
                this.action.setEdge(this.q, CharSet.parseRange(s));
            }
        }
        catch (CharSetException e) {
            throw new NinaException(this, "invalidchrst", new Object[0]);
        }
    }

    private void metBordNFA(NFA<Object, NFAState, Integer> s, int flag) {
        this.action.setEdgeNFA(this.q, s, flag);
    }

    private void setRegex(String t) {
        int f = 0;
        try {
            NFAObject<Object, NFAState, Integer> n;
            if (t.startsWith(ATOMIC)) {
                this.q.options.put("enableLookahead", "true");
                f = 2;
                n = RegexParser.parse(t.substring(ATOMIC.length()));
            } else if (t.startsWith(NO_CAPTURE)) {
                f = 1;
                n = RegexParser.parse(t.substring(NO_CAPTURE.length()));
            } else if (t.startsWith(LOOKAHEAD)) {
                this.q.options.put("enableLookahead", "true");
                f = 3;
                n = RegexParser.parse(t.substring(LOOKAHEAD.length()));
            } else if (t.startsWith(LOOKAHEAD_NEGATIVE)) {
                this.q.options.put("enableLookahead", "true");
                f = 4;
                n = RegexParser.parse(t.substring(LOOKAHEAD_NEGATIVE.length()));
            } else {
                n = RegexParser.parse(t);
            }
            this.metBordNFA(n, f);
        }
        catch (RegexParseException e) {
            throw new NinaException(this, "invalidregex", new Object[0]);
        }
    }

    private void metBordLabel(String l) {
        String s;
        if (this.q.defines.containsKey(l)) {
            this.metBordDefine(l);
            return;
        }
        HashSet<String> d = new HashSet<String>();
        String x = l;
        while (true) {
            if (d.contains(x)) {
                throw new NinaException("labelcirculate", new Object[0]);
            }
            d.add(x);
            s = this.q.labelalias.get(x);
            if (s == null) {
                throw new NinaException("labelundefined", new Object[0]);
            }
            Matcher m = LB_Q.matcher(s);
            if (m.matches()) {
                this.metBord(m.group(1), 39, -1);
                return;
            }
            m = LB_DI.matcher(s);
            if (m.matches()) {
                this.metBord(m.group(1), 34, 105);
                return;
            }
            m = LB_D.matcher(s);
            if (m.matches()) {
                this.metBord(m.group(1), 34, -1);
                return;
            }
            m = LB_S.matcher(s);
            if (m.matches()) {
                this.metBordCharset(m.group(1));
                return;
            }
            m = LB_R.matcher(s);
            if (m.matches() && this.q.isOptionDefined(ENABLE_REGEX_BY_BACKQUOTE)) {
                try {
                    NFAState z = new NFAState(){};
                    NFAObject<Object, NFAState, Integer> nz = RegexpParser.parse(m.group(1), z);
                    this.metBordNFA(nz, 0);
                    return;
                }
                catch (RegexParseException e) {
                    throw new NinaException(this, "invalidregex", new Object[0]);
                }
            }
            m = LB_RE.matcher(s);
            if (m.matches()) {
                this.setRegex(m.group(1));
                return;
            }
            m = LB_L.matcher(s);
            if (!m.matches()) break;
            x = m.group(1);
        }
        this.metBord(s, 39, -1);
    }

    private void metBordDefine(String l) {
        HashSet<String> d = new HashSet<String>();
        String x = l;
        while (true) {
            if (d.contains(x)) {
                throw new NinaException("labelcirculate", new Object[0]);
            }
            d.add(x);
            String s = this.q.defines.get(x);
            Matcher m = LD_H.matcher(s);
            if (m.matches()) {
                int a = Integer.valueOf(m.group(1), 16);
                this.metBord((char)a);
                this.q.consts.put(l, a);
                return;
            }
            m = LD_O.matcher(s);
            if (m.matches()) {
                int a = Integer.valueOf(s, 8);
                this.metBord((char)a);
                this.q.consts.put(l, a);
                return;
            }
            m = LD_D.matcher(s);
            if (m.matches()) {
                int a = Integer.valueOf(s);
                this.metBord((char)a);
                this.q.consts.put(l, a);
                return;
            }
            x = s;
        }
    }

    private void metmealy() {
        this.action.setMealyEdgeType(this.chr);
        this.action.setMealyEdge(this.buf.reverse().toString());
        this.chr = -1;
    }

    String getParameter(String s) {
        return this.params.containsKey(s) ? this.params.get(s) : "";
    }

    private NinaAction getAutomatonClass(String s) {
        String t = Nina.getAutomatonName(s);
        this.pragmas.put("machine", t);
        this.q.options.put("machine", t);
        if (t.indexOf(46) < 0) {
            t = String.valueOf(this.getClass().getPackage().getName()) + "." + t;
        }
        return (NinaAction)Nina.prendClasse(t);
    }

    private void settype(String s) {
        if (this.q.type != null) {
            return;
        }
        this.type = s.equals("char") ? Character.TYPE : (s.equals("int") ? Integer.TYPE : (s.equals("long") ? Long.TYPE : (s.equals("float") ? Float.TYPE : (s.equals("double") ? Double.TYPE : (s.equals("string") ? String.class : (s.equals("class") ? Class.class : (Class)Nina.prendClasse(s)))))));
        this.q.type = s;
        this.pragmas.put("type", this.q.type);
    }

    /*
     * Opcode count of 14263 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    NinaAction step() {
        S z = this.etat;
        switch (z) {
            case INIT: {
                if (this.q.get() == 35) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.PRAG0;
                    break;
                }
                if (this.q.get() == 37) {
                    this.q.east();
                    this.etat = S.DEF1;
                    break;
                }
                if (this.q.isBlankY()) {
                    this.infoput.pwarn("emptylanguage", new Object[0]);
                    DFABuilder n = new DFABuilder();
                    String t = this.q.getName();
                    if (this.subfas.containsKey(t)) {
                        this.subfas.put(t, n);
                    }
                    return n.empty(this.q, t);
                }
                if (this.q.isBlankX()) break;
                this.etat = S.LINIT;
                break;
            }
            case PRAG0: {
                if (this.q.get() == 32) {
                    this.q.east();
                    this.etat = S.LICN1;
                    break;
                }
                if (this.q.isBlankX()) {
                    this.q.license.append(NL);
                    this.q.cr();
                    this.etat = S.INIT;
                    break;
                }
                this.etat = S.PRAG;
                break;
            }
            case LICN1: {
                if (this.q.isBlankX()) {
                    this.q.license.append(NL);
                    this.q.cr();
                    this.etat = S.INIT;
                    break;
                }
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "unexpectedeof", new Object[0]);
                }
                if (this.q.get() >= 0) {
                    this.q.license.append((char)this.q.get());
                    this.q.east();
                    break;
                }
                this.q.east();
                break;
            }
            case PRAG: {
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.isLetter()) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (!Character.isWhitespace(this.q.get())) {
                    this.q.set(32);
                    this.q.east();
                    this.etat = S.COMNT;
                    break;
                }
                if (this.buf.toString().equals("package")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.PACK;
                    break;
                }
                if (this.buf.toString().equals("machine")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.MACHN;
                    break;
                }
                if (this.buf.toString().equals("type")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.TYPE;
                    break;
                }
                if (this.buf.toString().equals("option")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.OPTN;
                    break;
                }
                if (this.buf.toString().equals("label")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.PLB_1;
                    break;
                }
                if (this.buf.toString().equals("define")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.PDF_1;
                    break;
                }
                if (this.buf.toString().equals("alias")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.ALIAS;
                    break;
                }
                if (this.buf.toString().equals("require")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.REQ1;
                    break;
                }
                if (this.buf.toString().equals("valtype")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.VTYP1;
                    break;
                }
                if (this.buf.toString().equals("comment")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.SETCM;
                    break;
                }
                if (this.buf.toString().equals("commentHeader")) {
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.SETCH;
                    break;
                }
                this.etat = S.COMNT;
                break;
            }
            case PACK: {
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit() || this.q.get() == 46) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                String s = this.buf.toString().trim();
                this.q.setRootPackage(s);
                this.q.setRootResource("/" + s.replace('.', '/'));
                this.pragmas.put("package", s);
                this.etat = S.COMNT;
                break;
            }
            case MACHN: {
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.isLetter() || this.q.get() == 46) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                String s = this.buf.toString().trim();
                NinaAction n = this.getAutomatonClass(s);
                String t = Nina.getFAName(this.subfas, this.q.getName());
                if (this.subfas.containsKey(t)) {
                    this.subfas.put(t, n);
                }
                if (this.action == null) {
                    this.action = n;
                } else if (this.action.getClass().equals(DFABuilder.class) && n.getClass().equals(DFABuilder.class)) {
                    this.action = n;
                } else if (!(this.action.getClass().equals(NFABuilder.class) && n.getClass().equals(DFABuilder.class) || this.action.getClass().equals(NFABuilder.class) && n.getClass().equals(NFABuilder.class) || this.action.getClass().equals(n.getClass()))) {
                    throw new NinaException(this, "unknownmachine", s);
                }
                this.etat = S.COMNT;
                break;
            }
            case TYPE: {
                if (this.q.type != null) {
                    this.etat = S.COMNT;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 62) {
                    this.q.set(32);
                    this.q.east();
                    this.bf2 = new StringBuffer();
                    this.etat = S.TYP2;
                    break;
                }
                if (this.q.isLetter() || this.q.get() == 46) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                this.settype(this.buf.toString().trim());
                this.etat = S.COMNT;
                break;
            }
            case TYP2: {
                if (this.q.get() == 62) {
                    this.q.lexer = this.bf2.toString().trim();
                    this.bf2 = new StringBuffer();
                    this.q.set(32);
                    this.q.east();
                    this.etat = S.TYP3;
                    break;
                }
                if (this.q.isLetter() || this.q.get() == 46) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                this.settype(this.buf.toString().trim());
                this.etat = S.COMNT;
                break;
            }
            case TYP3: {
                if (this.q.isLetter() || this.q.get() == 46) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                this.q.ltype = this.buf.toString().trim();
                this.settype(this.bf2.toString().trim());
                this.etat = S.COMNT;
                break;
            }
            case OPTN: {
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 61) {
                    this.bf2 = new StringBuffer();
                    this.q.set(32);
                    this.q.east();
                    this.etat = S.OPTV;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                this.q.options.put(this.buf.toString(), "");
                this.etat = S.COMNT;
                break;
            }
            case OPTV: {
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.set(32);
                    this.q.east();
                    this.etat = S.OPTQ;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                String s = this.buf.toString();
                this.q.options.put(s, this.bf2.toString());
                this.etat = S.COMNT;
                break;
            }
            case OPTQ: {
                if (this.q.get() == 39) {
                    this.q.set(32);
                    this.q.east();
                    this.etat = S.OPTV;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidoption", new Object[0]);
            }
            case ALIAS: {
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 61) {
                    this.bf2 = new StringBuffer();
                    this.q.set(32);
                    this.q.east();
                    this.etat = S.ALI_V;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                this.q.options.put(this.buf.toString(), "");
                this.etat = S.COMNT;
                break;
            }
            case ALI_V: {
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.set(32);
                    this.q.east();
                    this.etat = S.ALI_Q;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                this.q.options.put(this.buf.toString(), this.bf2.toString());
                this.etat = S.COMNT;
                break;
            }
            case ALI_Q: {
                if (this.q.get() == 39) {
                    this.q.set(32);
                    this.q.east();
                    this.etat = S.ALI_V;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidalias", new Object[0]);
            }
            case PLB_1: {
                if (this.q.get() == -1 || this.q.get() == 13) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 61) {
                    this.bf2 = new StringBuffer();
                    this.q.set(32);
                    this.q.east();
                    this.etat = S.PLB_2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidlabeldef", new Object[0]);
            }
            case PLB_2: {
                if (this.q.get() == -1 || this.q.get() == 13) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.isBlankX()) {
                    this.q.labelalias.put(this.buf.toString(), this.bf2.toString());
                    this.q.cr();
                    this.etat = S.INIT;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidlabeldef", new Object[0]);
            }
            case PDF_1: {
                if (this.q.get() == -1 || this.q.get() == 13) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 32) {
                    this.bf2 = new StringBuffer();
                    this.q.east();
                    this.etat = S.PDF_2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidlabeldef", new Object[0]);
            }
            case PDF_2: {
                if (this.q.get() == -1 || this.q.get() == 13) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 32) {
                    this.q.east();
                    break;
                }
                if (this.q.get() >= 0) {
                    this.etat = S.PDF_3;
                    break;
                }
                throw new NinaException(this, "invalidlabeldef", new Object[0]);
            }
            case PDF_3: {
                if (this.q.get() == -1 || this.q.get() == 13) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.isBlankX()) {
                    this.q.defines.put(this.buf.toString(), this.bf2.toString());
                    this.q.cr();
                    this.etat = S.INIT;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidlabeldef", new Object[0]);
            }
            case REQ1: {
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 32) {
                    this.bf2 = new StringBuffer();
                    this.q.east();
                    this.etat = S.REQ2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                String[] stringArray = new String[2];
                stringArray[0] = this.buf.toString();
                this.q.requires.add(stringArray);
                this.etat = S.COMNT;
                break;
            }
            case REQ2: {
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                this.q.requires.add(new String[]{this.buf.toString(), this.bf2.toString()});
                this.etat = S.COMNT;
                break;
            }
            case VTYP1: {
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                this.q.valtype = this.buf.toString();
                this.q.options.put("valtype", this.q.valtype);
                this.etat = S.COMNT;
                break;
            }
            case SETCM: {
                if (this.q.get() == -1) {
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    break;
                }
                this.q.options.put("comment", this.buf.toString());
                this.etat = S.COMNT;
                break;
            }
            case SETCH: {
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(32);
                    this.q.east();
                    this.q.options.put("commentHeader", this.buf.toString());
                } else {
                    this.q.options.put("commentHeader", "#");
                }
                this.etat = S.COMNT;
                break;
            }
            case COMNT: {
                if (this.q.isBlankX()) {
                    this.q.cr();
                    this.etat = S.INIT;
                    break;
                }
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "unexpectedeof", new Object[0]);
                }
                this.q.set(32);
                this.q.east();
                break;
            }
            case DEF1: {
                if (this.q.get() == 123) {
                    this.buf = new StringBuffer();
                    this.defs = new StringWriter();
                    this.def = new PrintWriter(this.defs);
                    this.q.east();
                    this.etat = S.DEF2;
                    break;
                }
                if (this.q.get() >= 97 && this.q.get() <= 122) {
                    this.buf = new StringBuffer();
                    this.etat = S.DEFI1;
                    break;
                }
                this.q.west();
                this.etat = S.LINIT;
                break;
            }
            case DEF2: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "unexpectedeof", new Object[0]);
                }
                if (this.q.isBlankX()) {
                    this.def.println();
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 37) {
                    this.q.east();
                    this.etat = S.DEF3;
                    break;
                }
                if (this.q.get() < 0) break;
                this.def.print((char)this.q.get());
                this.q.east();
                break;
            }
            case DEF3: {
                if (this.q.get() == 125) {
                    this.def.println();
                    String x = this.buf.toString();
                    StringBuffer b = this.q.buffers.get(x);
                    if (b == null) {
                        b = new StringBuffer();
                        this.q.buffers.put(x, b);
                    }
                    b.append(this.defs.toString());
                    this.buf = new StringBuffer();
                    this.q.east();
                    this.etat = S.DEF4;
                    break;
                }
                this.def.print('%');
                this.etat = S.DEF2;
                break;
            }
            case DEF4: {
                if (this.q.isBlankX()) {
                    this.q.cr();
                    this.etat = S.INIT;
                    break;
                }
                this.q.east();
                break;
            }
            case DEFI1: {
                if (this.q.get() == 123) {
                    this.defs = new StringWriter();
                    this.def = new PrintWriter(this.defs);
                    this.q.east();
                    this.etat = S.DEF2;
                    break;
                }
                if (Character.isWhitespace(this.q.get())) {
                    this.q.east();
                    this.etat = S.DEFI2;
                    break;
                }
                if (this.q.get() >= 97 && this.q.get() <= 122) {
                    this.buf.append((char)this.q.get());
                    this.q.east();
                    break;
                }
                this.buf = new StringBuffer();
                this.q.cr();
                this.etat = S.INIT;
                break;
            }
            case DEFI2: {
                if (this.q.get() == 123) {
                    this.defs = new StringWriter();
                    this.def = new PrintWriter(this.defs);
                    this.q.east();
                    this.etat = S.DEF2;
                    break;
                }
                if (Character.isWhitespace(this.q.get())) {
                    this.q.east();
                    break;
                }
                this.buf = new StringBuffer();
                this.q.cr();
                this.etat = S.INIT;
                break;
            }
            case LINIT: {
                if (this.action == null) {
                    String t = this.q.getName();
                    this.action = new DFABuilder();
                    if (this.subfas.containsKey(t)) {
                        this.subfas.put(t, this.action);
                    }
                }
                if (_FRAME1.equals(this.q.getScratch2())) {
                    this.q.east();
                    break;
                }
                if (_FRAME2.equals(this.q.getScratch2())) {
                    this.q.east();
                    this.etat = S.LINI2;
                    break;
                }
                if (this.q.isFrameBefore()) {
                    if (this.q.get() == 61 || this.q.get() == 38) {
                        this.etat = S.FI_E;
                        break;
                    }
                    this.buf = new StringBuffer();
                    this.bf2 = new StringBuffer();
                    this.q.east();
                    this.etat = S.FI_L0;
                    break;
                }
                if (this.q.get() == 39 || this.q.get() == 34) {
                    this.quote = this.q.get();
                    this.q.east();
                    this.etat = S.LQUOT;
                    break;
                }
                if (this.q.get() == 91) {
                    this.q.east();
                    this.etat = S.LCSET;
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.east();
                    this.etat = S.LGNFA;
                    break;
                }
                if (this.q.get() == 47) {
                    this.q.west();
                    this.etat = S.LGRE;
                    break;
                }
                if (this.q.get() == 123) {
                    this.q.east();
                    this.etat = S.LSNFA;
                    break;
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.isBlankY()) {
                    this.q.north();
                    this.etat = S.LPRI1;
                    break;
                }
                this.q.east();
                break;
            }
            case LINI2: {
                if (_FRAME2.equals(this.q.getScratch2())) {
                    this.etat = S.LINIT;
                }
                this.q.east();
                break;
            }
            case FI_L0: {
                if (this.q.get() == 39) {
                    this.etat = S.FI_L1;
                    break;
                }
                if (this.q.get() == 95 || Character.isUpperCase(this.q.get())) {
                    this.etat = S.FI_L1;
                    break;
                }
                if (this.q.get() == 60) {
                    this.etat = S.FI_L1;
                    break;
                }
                if (this.q.isFrameBefore() || this.q.isArrow()) {
                    this.etat = S.FI_L1;
                    break;
                }
                this.etat = S.LINIT;
                break;
            }
            case FI_L1: {
                if (this.q.get() == 39) {
                    this.q.set(42);
                    this.q.east();
                    this.etat = S.FI_L3;
                    break;
                }
                if (this.q.get() == 95 || Character.isUpperCase(this.q.get())) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(42);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 60) {
                    this.q.set(42);
                    this.q.east();
                    this.nestlv = 1;
                    this.etat = S.FI_L4;
                    break;
                }
                if (this.q.isFrameBefore() || this.q.isArrow()) {
                    this.q.west();
                    this.etat = S.FI_L2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FI_L2: {
                if (this.q.isFrameBefore()) {
                    this.q.west();
                    break;
                }
                if (this.q.get() >= 0) {
                    this.q.east();
                    this.q.setLabel(this.buf.toString());
                    this.q.setLabelType(this.bf2.toString());
                    this.buf = new StringBuffer();
                    this.bf2 = new StringBuffer();
                    this.etat = S.FI_E;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FI_L3: {
                if (this.q.get() == 39) {
                    this.q.set(42);
                    this.q.east();
                    this.etat = S.FI_L1;
                    break;
                }
                if (this.q.get() == 60) {
                    this.bf2 = new StringBuffer();
                    this.q.set(42);
                    this.q.east();
                    this.nestlv = 1;
                    this.etat = S.FI_L4;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(42);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FI_L4: {
                if (this.q.get() == 62 && --this.nestlv <= 0) {
                    this.q.set(42);
                    this.q.west();
                    this.etat = S.FI_L2;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() == 60) {
                        ++this.nestlv;
                    }
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(42);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FI_E: {
                this.q.south();
                if (this.q.isFrameBefore() || this.q.isArrow()) {
                    this.q.north();
                    if (this.q.get() == 61 || this.q.get() == 38) {
                        this.q.setLabel(STARTSYM);
                    }
                    this.etat = S.FI_E2;
                    break;
                }
                this.q.north().east();
                this.etat = S.LINIT;
                break;
            }
            case FI_E2: {
                if (this.q.isFrameBefore() || this.q.isArrow() || this.q.isEntry() || this.q.isDone()) {
                    this.q.transformFrame();
                    this.q.setScratch2(_FRAME1);
                    this.q.east();
                    break;
                }
                this.q.south().west();
                this.etat = S.FI_S;
                break;
            }
            case FI_S: {
                if (this.q.isFrameBefore() || this.q.isFrame() || this.q.isArrow() || this.q.isEntry() || this.q.isDone()) {
                    this.etat = S.FI_S2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FI_S2: {
                if (this.q.isFrameBefore() || this.q.isFrame() || this.q.isArrow() || this.q.isEntry() || this.q.isDone()) {
                    this.q.transformFrame();
                    this.q.setScratch2(_FRAME2);
                    this.q.south();
                    break;
                }
                this.q.north();
                this.etat = S.FI_W;
                break;
            }
            case FI_W: {
                this.q.west();
                if (this.q.isFrameBefore() || this.q.isFrame() || this.q.isArrow() || this.q.isEntry() || this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FI_W2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FI_W2: {
                if (this.q.isFrameBefore() || this.q.isFrame() || this.q.isArrow() || this.q.isEntry() || this.q.isDone()) {
                    this.q.transformFrame();
                    this.q.setScratch2(_FRAME1);
                    this.q.west();
                    break;
                }
                this.q.north().east();
                this.etat = S.FI_N;
                break;
            }
            case FI_N: {
                if (this.q.isFrameBefore() || this.q.isArrow() || this.q.isEntry() || this.q.isDone()) {
                    this.q.transformFrame();
                    this.q.setScratch2(_FRAME2);
                    this.q.north();
                    break;
                }
                if (this.q.isFrame()) {
                    this.q.setScratch2(_FRAME1);
                    this.etat = S.LINIT;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case LQUOT: {
                if (this.q.get() == this.quote) {
                    this.q.east();
                    this.etat = S.LINIT;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.east();
                    this.q.east();
                    break;
                }
                if (this.q.get() >= 0 || this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidquote", new Object[0]);
            }
            case LSNFA: {
                if (this.q.get() == 125) {
                    this.q.east();
                    this.etat = S.LINIT;
                    break;
                }
                if (this.q.get() >= 0 || this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidsubfa", new Object[0]);
            }
            case LCSET: {
                if (this.q.get() == 93) {
                    this.q.east();
                    this.etat = S.LINIT;
                    break;
                }
                if (this.q.get() >= 0 || this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidchrst", new Object[0]);
            }
            case LGNFA: {
                if (this.q.get() == 96) {
                    this.q.east();
                    this.etat = S.LINIT;
                    break;
                }
                if (this.q.get() >= 0 || this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidregex", new Object[0]);
            }
            case LGRE: {
                this.etat = this.q.isWhitespace() && !this.q.isOptionDefined(DISABLE_TURN_BY_SLASH) ? S.LINIT : (this.q.isBlankX() && !this.q.isOptionDefined(DISABLE_TURN_BY_SLASH) ? S.LINIT : S.LGRE1);
                this.q.east().east();
                break;
            }
            case LGRE1: {
                if (this.q.get() == 39) {
                    this.quote = this.q.get();
                    this.q.east();
                    this.etat = S.LQUOT;
                    break;
                }
                if (this.q.isWhitespace() && !this.q.isOptionDefined(DISABLE_TURN_BY_SLASH)) {
                    this.etat = S.LINIT;
                    break;
                }
                if (this.q.isBlankX() && !this.q.isOptionDefined(DISABLE_TURN_BY_SLASH)) {
                    this.etat = S.LINIT;
                    break;
                }
                this.etat = S.LGRE2;
                break;
            }
            case LGRE2: {
                if (this.q.get() == 47) {
                    this.q.east();
                    this.etat = S.LINIT;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.east().east();
                    break;
                }
                if (this.q.get() >= 0 || this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidregex", new Object[0]);
            }
            case LPRI1: {
                if (this.q.isBlankY()) {
                    this.q.south();
                    this.etat = S.LPRI2;
                    break;
                }
                this.q.north();
                break;
            }
            case LPRI2: {
                if (this.q.isBlankY()) {
                    this.infoput.pwarn("emptylanguage", new Object[0]);
                    return this.action.empty(this.q, this.q.getName());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (STARTSYM.equals(this.q.getLabel())) {
                    this.action.setStartState(this.action.createState(this.q));
                    this.etat = S.LBLE;
                    break;
                }
                this.q.east();
                break;
            }
            case LBLE: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry() || this.q.isDone()) {
                    this.q.setScratch2(_FRAME1);
                    this.q.east();
                    break;
                }
                this.q.south().west();
                this.etat = S.FL_S;
                break;
            }
            case FL_S: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry() || this.q.isDone()) {
                    this.q.setScratch2(_FRAME2);
                    this.q.south();
                    break;
                }
                this.q.north().west();
                this.etat = S.FL_W;
                break;
            }
            case FL_W: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry() || this.q.isDone()) {
                    this.q.setScratch2(_FRAME1);
                    this.q.west();
                    break;
                }
                this.q.north().east();
                this.etat = S.FL_N;
                break;
            }
            case FL_N: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry() || this.q.isDone()) {
                    this.q.setScratch2(_FRAME2);
                    this.q.north();
                    break;
                }
                this.q.south();
                this.q.setScratch2(_FRAME1);
                this.etat = S.FL_E;
                break;
            }
            case FL_E: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    int c = this.q.get();
                    this.q.south().east();
                    NinaFrameReader rd = new NinaFrameReader(this.q);
                    this.action.labelAdded(this.q, rd, c == -502);
                    rd.close();
                }
                this.etat = S.PRI01;
                break;
            }
            case PRI01: {
                this.buf = new StringBuffer();
                this.q.north();
                this.etat = S.PRI02;
                break;
            }
            case PRI02: {
                if (this.q.get() >= 48 && this.q.get() <= 57) {
                    this.etat = S.PRI03;
                    break;
                }
                this.q.south();
                this.etat = S.FMNW;
                break;
            }
            case PRI03: {
                if (this.q.get() >= 48 && this.q.get() <= 57) {
                    this.buf.append((char)this.q.get());
                    this.q.east();
                    break;
                }
                if (this.buf.length() > 0) {
                    this.action.setPriority(Integer.valueOf(this.buf.toString()));
                }
                this.etat = S.PRI04;
                break;
            }
            case PRI04: {
                if (this.q.get() >= 48 && this.q.get() <= 57) {
                    this.q.west();
                    break;
                }
                this.q.east().south();
                this.etat = S.FMNW;
                break;
            }
            case FMNW: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame()) {
                    this.q.east();
                    this.etat = S.FMNW2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FMNW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_E;
                } else {
                    throw new NinaException(this, "invalidframe", new Object[0]);
                }
            }
            case FM_E: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.east();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.west();
                    this.etat = S.FRR_W;
                    break;
                }
                this.q.west();
                this.etat = S.FMNE;
                break;
            }
            case FMNE: {
                if (this.q.isFrame()) {
                    this.q.south();
                    this.etat = S.FMNE2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FMNE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_S;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FM_S: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.south();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.north();
                    this.etat = S.FRR_N;
                    break;
                }
                this.q.north();
                this.etat = S.FMSE;
                break;
            }
            case FMSE: {
                if (this.q.isFrame()) {
                    this.q.west();
                    this.etat = S.FMSE2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FMSE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_W;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FM_W: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                this.q.east();
                this.etat = S.FMSW;
                break;
            }
            case FMSW: {
                if (this.q.isFrame()) {
                    this.etat = S.FMSW2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FMSW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FM_N;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FM_N: {
                this.q.setScratch(this.action.getVertex());
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRNW;
                    break;
                }
                this.q.south();
                this.etat = S.FRNW;
                this.action.doneBlockSearching(this.q);
                break;
            }
            case FRNW: {
                if (this.q.isFrame()) {
                    this.q.east();
                    this.etat = S.FRNW2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FRNW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_E;
                } else {
                    throw new NinaException(this, "invalidframe", new Object[0]);
                }
            }
            case FR_E: {
                if (this.q.get() == 94) {
                    this.action.setVertex(this.q.getScratch());
                    this.action.setEdge(this.q, null);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.east();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.west();
                    this.etat = S.FRR_W;
                    break;
                }
                this.q.west();
                this.etat = S.FRNE;
                break;
            }
            case FRNE: {
                if (this.q.isFrame()) {
                    this.q.south();
                    this.etat = S.FRNE2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FRNE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_S;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FR_S: {
                if (this.q.get() == 62) {
                    this.action.setVertex(this.q.getScratch());
                    this.action.setEdge(this.q, null);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.south();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.north();
                    this.etat = S.FRR_N;
                    break;
                }
                this.q.north();
                this.etat = S.FRSE;
                break;
            }
            case FRSE: {
                if (this.q.isFrame()) {
                    this.q.west();
                    this.etat = S.FRSE2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FRSE2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_W;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FR_W: {
                if (this.q.get() == 118) {
                    this.action.setVertex(this.q.getScratch());
                    this.action.setEdge(this.q, null);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                this.q.east();
                this.etat = S.FRSW;
                break;
            }
            case FRSW: {
                if (this.q.isFrame()) {
                    this.etat = S.FRSW2;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FRSW2: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.etat = S.FR_N;
                    break;
                }
                throw new NinaException(this, "invalidframe", new Object[0]);
            }
            case FR_N: {
                if (this.q.get() == 60) {
                    this.action.setVertex(this.q.getScratch());
                    this.action.setEdge(this.q, null);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRR_S;
                    break;
                }
                this.q.south();
                this.etat = S.FRR_S;
                this.action.doneBlockSearching(this.q);
                break;
            }
            case AR_N: {
                if (this.q.get() == 47) {
                    this.q.set(-103);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-103);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 124) {
                    this.q.set(-103);
                    this.q.north();
                    break;
                }
                if (this.q.isBranchN()) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.set(Quadro.putWedgeN(this.q.get()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 46) {
                    this.q.setEdge(CharSets.ALL_CHAR);
                    this.q.set(-103);
                    this.q.north();
                    break;
                }
                if (this.q.get() == 94) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.south();
                        this.etat = S.ARR_S;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F2_W;
                    break;
                }
                if (this.q.get() == 36) {
                    this.action.setEdgeEnd(this.q);
                    this.q.set(-103);
                    this.q.north();
                    break;
                }
                if (this.q.get() == 42 || this.q.get() == 64) {
                    if (this.q.getScratch() != null) {
                        throw new NinaException("notjoin", new Object[0]);
                    }
                    this.action.link(this.q, null);
                    this.action.setAccept(this.q.get() == 64);
                    this.q.setScratch(this.q.get());
                    this.etat = S.ONS_0;
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit()) {
                    this.q.setEdge((char)this.q.get());
                    this.q.set(-103);
                    this.q.north();
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.south();
                    this.etat = S.AR_ZE;
                    break;
                }
                if (this.q.get() == -300) {
                    this.action.link(this.q, this.q.getScratch());
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case AR_ZE: {
                this.q.set(94);
                this.q.east();
                this.etat = S.FR_E;
                break;
            }
            case AR_E: {
                if (this.q.get() == 47) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EE;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EB;
                    break;
                }
                if (this.q.get() == 45) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.isBranchE()) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.set(Quadro.putWedgeN(this.q.get()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 46) {
                    this.q.setEdge(CharSets.ALL_CHAR);
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                if (this.q.get() == 62) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.west();
                        this.etat = S.ARR_W;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F2_N;
                    break;
                }
                if (this.q.get() == 39 || this.q.get() == 34) {
                    this.quote = this.q.get();
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EQ;
                    break;
                }
                if (this.q.get() == 123) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_ER;
                    break;
                }
                if (this.q.get() == 91) {
                    this.nestlv = 0;
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EI;
                    break;
                }
                if (this.q.get() == 40) {
                    this.q.set(-400);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_E1;
                    break;
                }
                if (this.q.get() == 36) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AREE1;
                    break;
                }
                if (this.q.get() == 126) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EW;
                    break;
                }
                if (this.q.get() == 48) {
                    this.buf = new StringBuffer();
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AREN0;
                    break;
                }
                if (this.q.get() >= 49 && this.q.get() <= 57) {
                    this.buf = new StringBuffer();
                    this.chr = 10;
                    this.etat = S.AREN1;
                    break;
                }
                if (this.q.get() == 42 || this.q.get() == 64) {
                    if (this.q.getScratch() != null) {
                        throw new NinaException("notjoin", new Object[0]);
                    }
                    this.action.link(this.q, null);
                    this.action.setAccept(this.q.get() == 64);
                    this.q.setScratch(this.q.get());
                    this.etat = S.ONS_0;
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit()) {
                    this.metBord((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.west();
                    this.etat = S.AR_ZS;
                    break;
                }
                if (this.q.get() == 96 && this.q.isOptionDefined(ENABLE_REGEX_BY_BACKQUOTE)) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EG;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -300) {
                    this.action.link(this.q, this.q.getScratch());
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case AR_EB: {
                if (this.q.get() >= 65 && this.q.get() <= 90 || this.q.get() >= 97 && this.q.get() <= 122) {
                    this.action.setEdgeBackslash(this.q, this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                this.q.west().south();
                this.etat = S.AR_S;
                break;
            }
            case AR_EE: {
                if ((this.q.isWhitespace() || this.q.isBlankX()) && !this.q.isOptionDefined(DISABLE_TURN_BY_SLASH)) {
                    this.q.west().north();
                    this.etat = S.AR_N;
                    break;
                }
                this.buf = new StringBuffer();
                this.etat = S.AR_Ee;
                break;
            }
            case AR_Ee: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidregex", new Object[0]);
                }
                if (this.q.get() == 47) {
                    this.setRegex(this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                if (this.q.get() == 92) {
                    this.buf.append('\\');
                    this.q.set(-101);
                    this.q.east();
                    if (this.q.isBlankX()) {
                        throw new NinaException(this, "invalidregex", new Object[0]);
                    }
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidregex", new Object[0]);
            }
            case AR_ZS: {
                this.q.set(62);
                this.q.south();
                this.etat = S.FR_S;
                break;
            }
            case AREN0: {
                if (this.q.get() == 120 || this.q.get() == 88) {
                    this.chr = 16;
                    this.q.set(-101);
                    this.q.east();
                } else {
                    this.chr = 8;
                }
                this.etat = S.AREN1;
                break;
            }
            case AREN1: {
                if (this.q.get() >= 48 && this.q.get() <= 55 || this.chr > 8 && this.q.get() >= 56 && this.q.get() <= 57 || this.chr > 10 && this.q.get() >= 97 && this.q.get() <= 102 || this.chr > 10 && this.q.get() >= 65 && this.q.get() <= 70) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                this.metBord((char)Integer.parseInt(this.buf.toString(), this.chr));
                this.buf = new StringBuffer();
                this.chr = -1;
                this.etat = S.AR_ES;
                break;
            }
            case AR_EQ: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == this.quote) {
                    this.q.set(-101);
                    this.q.east();
                    this.quoteFlag = -1;
                    this.etat = S.AREQF;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_Eq;
                    break;
                }
                if (this.q.get() == 36) {
                    this.bf2 = new StringBuffer();
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.ARED1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidquote", new Object[0]);
            }
            case AREQF: {
                if (this.q.get() >= 97 && this.q.get() <= 122 || this.q.get() >= 65 && this.q.get() <= 90) {
                    this.quoteFlag = this.q.get();
                    this.q.set(-101);
                    this.q.east();
                }
                this.metBord(this.buf.toString(), this.quote, this.quoteFlag);
                this.etat = S.AR_ES;
                break;
            }
            case AR_Eq: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() == 110) {
                        this.buf.append('\n');
                    } else if (this.q.get() == 114) {
                        this.buf.append('\r');
                    } else if (this.q.get() == 116) {
                        this.buf.append('\t');
                    } else if (this.q.get() == 48) {
                        this.buf.append('\u0000');
                    } else if (this.q.get() != 39 && this.q.get() != 92) {
                        this.buf.append('\\');
                        this.buf.append((char)this.q.get());
                    } else {
                        this.buf.append((char)this.q.get());
                    }
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EQ;
                    break;
                }
                throw new NinaException(this, "invalidquote", new Object[0]);
            }
            case ARED1: {
                if (this.q.get() == 123) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.ARED2;
                    break;
                }
                this.buf.append('$');
                this.etat = S.AR_EQ;
                break;
            }
            case ARED2: {
                if (this.q.get() == 125) {
                    this.buf.append(this.getParameter(this.bf2.toString()));
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EQ;
                    break;
                }
                if (Character.isJavaIdentifierPart(this.q.get())) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                this.buf.append('$');
                this.buf.append('{');
                this.buf.append(this.bf2);
                this.etat = S.AR_EQ;
                break;
            }
            case AR_ER: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidsubfa", new Object[0]);
                }
                if (this.q.get() == 40) {
                    this.bf2 = new StringBuffer();
                    this.lst = new ArrayList<String>();
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.ARER1;
                    break;
                }
                if (this.q.get() == 125) {
                    this.metBordRes(this.buf.toString(), Collections.emptyMap());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidsubfa", new Object[0]);
            }
            case ARER1: {
                if (this.q.get() == 41) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.ARER2;
                    break;
                }
                if (this.q.get() == 44) {
                    this.lst.add(this.bf2.toString());
                    this.bf2 = new StringBuffer();
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.ARER3;
                    break;
                }
                if (this.q.get() == 34) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.ARER4;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidsubfa", new Object[0]);
            }
            case ARER2: {
                if (this.q.get() == 125) {
                    this.lst.add(this.bf2.toString());
                    this.bf2 = null;
                    HashMap<String, String> mp = new HashMap<String, String>();
                    int k = 1;
                    while (k <= this.lst.size()) {
                        mp.put(String.valueOf(k), this.lst.get(k - 1));
                        ++k;
                    }
                    this.metBordRes(this.buf.toString(), mp);
                    this.lst = null;
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                throw new NinaException(this, "invalidsubfa", new Object[0]);
            }
            case ARER3: {
                if (this.q.get() == 39) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.ARER1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidsubfa", new Object[0]);
            }
            case ARER4: {
                if (this.q.get() == 34) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.ARER1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidsubfa", new Object[0]);
            }
            case AR_EI: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidchrst", new Object[0]);
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_Ei;
                    break;
                }
                if (this.q.get() == 93 && this.nestlv-- <= 0) {
                    this.metBordCharset(this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() == 91) {
                        ++this.nestlv;
                    }
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidchrst", new Object[0]);
            }
            case AR_Ei: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidchrst", new Object[0]);
                }
                if (this.q.get() >= 0) {
                    this.buf.append('\\');
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EI;
                    break;
                }
                throw new NinaException(this, "invalidchrst", new Object[0]);
            }
            case AR_EG: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidregex", new Object[0]);
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_Eg;
                    break;
                }
                if (this.q.get() == 96) {
                    try {
                        NFAState dm = new NFAState(){};
                        NFAObject<Object, NFAState, Integer> nz = RegexpParser.parse(this.buf.toString(), dm);
                        this.metBordNFA(nz, 0);
                    }
                    catch (RegexParseException e) {
                        throw new NinaException(this, "invalidregex", new Object[0]);
                    }
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidregex", new Object[0]);
            }
            case AR_Eg: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidchrst", new Object[0]);
                }
                if (this.q.get() >= 0) {
                    this.buf.append('\\');
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EG;
                    break;
                }
                throw new NinaException(this, "invalidchrst", new Object[0]);
            }
            case AR_ES: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.get() == 47 || this.q.get() == 35 || this.q.get() == 37) {
                    this.chr = this.q.get();
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_EM;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                this.etat = S.AR_E;
                break;
            }
            case AR_EM: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.isWhitespace()) {
                    this.q.set(-101);
                    this.q.north().west();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.set(-101);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_EX;
                    break;
                }
                throw new NinaException(this, "invalidmealy", new Object[0]);
            }
            case AR_EX: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.get() == 39) {
                    this.action.setMealyEdgeType(this.chr);
                    this.action.setMealyEdge(this.buf.toString());
                    this.chr = -1;
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidmealy", new Object[0]);
            }
            case AR_EW: {
                if (this.q.get() == 126) {
                    this.action.setEdgeSkipSpaces(this.q, this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidmealy", new Object[0]);
            }
            case WP_E1: {
                if (this.q.get() == 41) {
                    this.q.set(-400);
                    this.etat = S.TOIX1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case AREE1: {
                if (this.q.get() == 123) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AREE2;
                    break;
                }
                this.action.setEdgeEnd(this.q);
                this.etat = S.AR_ES;
                break;
            }
            case AREE2: {
                if (this.q.get() == -1) {
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                if (this.q.get() == 125) {
                    this.metBordLabel(this.buf.toString());
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_ES;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.set(-101);
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidlabel", new Object[0]);
            }
            case AR_S: {
                if (this.q.get() == 47) {
                    this.q.set(-102);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-102);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 124) {
                    this.q.set(-102);
                    this.q.south();
                    break;
                }
                if (this.q.isBranchS()) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.set(Quadro.putWedgeN(this.q.get()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 46) {
                    this.q.setEdge(CharSets.ALL_CHAR);
                    this.q.set(-102);
                    this.q.south();
                    break;
                }
                if (this.q.get() == 118) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.north();
                        this.etat = S.ARR_N;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F3_W;
                    break;
                }
                if (this.q.get() == 36) {
                    this.action.setEdgeEnd(this.q);
                    this.q.set(-102);
                    this.q.south();
                    break;
                }
                if (this.q.get() == 42 || this.q.get() == 64) {
                    if (this.q.getScratch() != null) {
                        throw new NinaException("notjoin", new Object[0]);
                    }
                    this.action.link(this.q, null);
                    this.action.setAccept(this.q.get() == 64);
                    this.q.setScratch(this.q.get());
                    this.etat = S.ONS_0;
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit()) {
                    this.metBord((char)this.q.get());
                    this.q.set(-102);
                    this.q.south();
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.north();
                    this.etat = S.AR_ZW;
                    break;
                }
                if (this.q.get() == -300) {
                    this.action.link(this.q, this.q.getScratch());
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case AR_ZW: {
                this.q.set(118);
                this.q.west();
                this.etat = S.FR_W;
                break;
            }
            case AR_W: {
                this.seqFlag = -1;
                if (this.q.get() == 47) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WE;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-100);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 45) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.isBranchW()) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.set(Quadro.putWedgeN(this.q.get()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.get() == 46) {
                    this.action.setEdge(this.q, CharSets.ALL_CHAR);
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == 60) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.east();
                        this.etat = S.ARR_E;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F3_N;
                    break;
                }
                if (this.q.get() == 39 || this.q.get() == 34) {
                    this.quote = this.q.get();
                    this.quoteFlag = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() == 125) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WR;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 93) {
                    this.nestlv = 0;
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WI;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 41) {
                    this.q.set(-400);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_W1;
                    break;
                }
                if (this.q.get() == 96 && this.q.isOptionDefined(ENABLE_REGEX_BY_BACKQUOTE)) {
                    this.q.set(-100);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_WG;
                    break;
                }
                if (this.q.get() == 36) {
                    this.action.setEdgeEnd(this.q);
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() == 126) {
                    this.q.set(-100);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_WW;
                    break;
                }
                if (this.q.get() >= 48 && this.q.get() <= 57) {
                    this.buf = new StringBuffer().append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWN1;
                    break;
                }
                if (this.q.get() >= 97 && this.q.get() <= 102 || this.q.get() >= 65 && this.q.get() <= 70) {
                    this.buf = new StringBuffer().append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWN0;
                    break;
                }
                if (this.q.get() == 42 || this.q.get() == 64) {
                    if (this.q.getScratch() != null) {
                        throw new NinaException("notjoin", new Object[0]);
                    }
                    this.action.link(this.q, null);
                    this.action.setAccept(this.q.get() == 64);
                    this.q.setScratch(this.q.get());
                    this.etat = S.ONS_0;
                    break;
                }
                if (this.q.get() == 73 || this.q.get() == 105) {
                    this.quoteFlag = this.q.get();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWQF;
                    break;
                }
                if (this.q.get() >= 65 && this.q.get() <= 90 || this.q.get() >= 97 && this.q.get() <= 122) {
                    this.seqFlag = this.q.get();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WB;
                    break;
                }
                if (this.q.isLetter() || this.q.isDigit()) {
                    this.chr = this.q.get();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.isArrow2() || this.q.isArrow3()) {
                    this.q.east();
                    this.etat = S.AR_ZN;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -300) {
                    this.action.link(this.q, this.q.getScratch());
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case AR_WE: {
                if ((this.q.isWhitespace() || this.q.isBlankX()) && !this.q.isOptionDefined(DISABLE_TURN_BY_SLASH)) {
                    this.q.east().south();
                    this.etat = S.AR_S;
                    break;
                }
                this.buf = new StringBuffer();
                this.etat = S.AR_We;
                break;
            }
            case AR_We: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidregex", new Object[0]);
                }
                if (this.q.get() == 47) {
                    this.q.set(-100);
                    this.q.west();
                    if (this.q.get() == 92) {
                        this.buf.append('/').append('\\');
                        this.q.set(-100);
                        this.q.west();
                        break;
                    }
                    this.setRegex(this.buf.reverse().toString());
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidregex", new Object[0]);
            }
            case AR_WB: {
                if (this.q.get() == 92) {
                    this.action.setEdgeBackslash(this.q, this.seqFlag);
                    this.q.set(-100);
                    this.q.west();
                }
                this.etat = S.AR_W;
                break;
            }
            case ARWQF: {
                if (this.q.get() == 34) {
                    this.quote = this.q.get();
                    this.q.set(-100);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_WQ;
                    break;
                }
                this.chr = this.q.get();
                this.etat = S.AR_WS;
                break;
            }
            case ARWN0: {
                if (this.q.get() >= 48 && this.q.get() <= 57 || this.q.get() >= 97 && this.q.get() <= 102 || this.q.get() >= 65 && this.q.get() <= 70) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWN1;
                    break;
                }
                if (this.q.get() == 92) {
                    this.action.setEdgeBackslash(this.q, this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                this.chr = this.buf.charAt(0);
                this.buf = new StringBuffer();
                this.etat = S.AR_WS;
                break;
            }
            case ARWN1: {
                if (this.q.get() >= 48 && this.q.get() <= 57 || this.q.get() >= 97 && this.q.get() <= 102 || this.q.get() >= 65 && this.q.get() <= 70) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == 120 || this.q.get() == 88) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWN2;
                    break;
                }
                if (this.buf.reverse().charAt(0) != '0') {
                    try {
                        this.chr = Integer.parseInt(this.buf.toString(), 10);
                    }
                    catch (NumberFormatException e) {
                        throw new NinaException(this, "invalidnumber", new Object[0]);
                    }
                    this.buf = new StringBuffer();
                    this.etat = S.AR_WS;
                    break;
                }
                try {
                    this.chr = Integer.parseInt(this.buf.toString(), 8);
                }
                catch (NumberFormatException e) {
                    throw new NinaException(this, "invalidnumber", new Object[0]);
                }
                this.buf = new StringBuffer();
                this.etat = S.AR_WS;
                break;
            }
            case ARWN2: {
                if (this.q.get() == 48) {
                    try {
                        this.chr = Integer.parseInt(this.buf.reverse().toString(), 16);
                    }
                    catch (NumberFormatException e) {
                        throw new NinaException(this, "invalidnumber", new Object[0]);
                    }
                    this.buf = new StringBuffer();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                throw new NinaException(this, "invalidnumber", new Object[0]);
            }
            case AR_ZN: {
                this.q.set(60);
                this.q.north();
                this.etat = S.FR_N;
                break;
            }
            case AR_WQ: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == this.quote) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wq;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wy;
                    break;
                }
                if (this.q.get() == 110) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wn;
                    break;
                }
                if (this.q.get() == 114) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wr;
                    break;
                }
                if (this.q.get() == 116) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wt;
                    break;
                }
                if (this.q.get() == 48) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W0;
                    break;
                }
                if (this.q.get() == 125) {
                    this.bf2 = new StringBuffer();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWD1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidquote", new Object[0]);
            }
            case AR_Wq: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == 92) {
                    this.buf.append((char)this.quote);
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.chr = -1;
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidquote", new Object[0]);
            }
            case AR_Wy: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == this.quote) {
                    this.buf.append('\\');
                    this.chr = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() != 92) {
                        this.buf.append('\\');
                    }
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidquote", new Object[0]);
            }
            case AR_Wn: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == this.quote) {
                    this.buf.append('n');
                    this.chr = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() != 92) {
                        this.buf.append('n');
                        this.buf.append((char)this.q.get());
                    } else {
                        this.buf.append('\n');
                    }
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidquote", new Object[0]);
            }
            case AR_Wr: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == this.quote) {
                    this.buf.append('r');
                    this.chr = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() != 92) {
                        this.buf.append('r');
                        this.buf.append((char)this.q.get());
                    } else {
                        this.buf.append('\r');
                    }
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidquote", new Object[0]);
            }
            case AR_Wt: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == this.quote) {
                    this.buf.append('t');
                    this.chr = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() != 92) {
                        this.buf.append('t');
                        this.buf.append((char)this.q.get());
                    } else {
                        this.buf.append('\t');
                    }
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidquote", new Object[0]);
            }
            case AR_W0: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidquote", new Object[0]);
                }
                if (this.q.get() == this.quote) {
                    this.buf.append('0');
                    this.chr = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WS;
                    break;
                }
                if (this.q.get() >= 0) {
                    if (this.q.get() != 92) {
                        this.buf.append('0');
                        this.buf.append((char)this.q.get());
                    } else {
                        this.buf.append('\u0000');
                    }
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidquote", new Object[0]);
            }
            case ARWD1: {
                if (this.q.get() == 123) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWD2;
                    break;
                }
                if (Character.isJavaIdentifierPart(this.q.get())) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                this.buf.append('}');
                this.buf.append(this.bf2);
                this.etat = S.AR_WQ;
                break;
            }
            case ARWD2: {
                if (this.q.get() == 36) {
                    StringBuffer bt = new StringBuffer(this.getParameter(this.bf2.reverse().toString()));
                    this.buf.append(bt.reverse());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WQ;
                    break;
                }
                this.buf.append('}');
                this.buf.append(this.bf2);
                this.buf.append('{');
                this.etat = S.AR_WQ;
                break;
            }
            case AR_WR: {
                this.lst = new ArrayList<String>();
                if (this.q.get() == 41) {
                    this.bf2 = new StringBuffer();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWR2;
                    break;
                }
                this.bf2 = null;
                this.etat = S.ARWR1;
                break;
            }
            case ARWR1: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidsubfa", new Object[0]);
                }
                if (this.q.get() == 123) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWR5;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidsubfa", new Object[0]);
            }
            case ARWR2: {
                if (this.q.get() == 40) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWR1;
                    break;
                }
                if (this.q.get() == 44) {
                    this.lst.add(this.bf2.reverse().toString());
                    this.bf2 = new StringBuffer();
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWR3;
                    break;
                }
                if (this.q.get() == 34) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWR4;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidsubfa", new Object[0]);
            }
            case ARWR3: {
                if (this.q.get() == 39) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWR2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidsubfa", new Object[0]);
            }
            case ARWR4: {
                if (this.q.get() == 34) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWR2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidsubfa", new Object[0]);
            }
            case ARWR5: {
                if (this.q.get() == 36) {
                    this.metBordLabel(this.buf.reverse().toString());
                    this.q.set(-100);
                    this.q.west();
                } else {
                    if (this.bf2 != null) {
                        this.lst.add(this.bf2.toString());
                        this.bf2 = null;
                    }
                    HashMap<String, String> mp = new HashMap<String, String>();
                    int i = 1;
                    while (i <= this.lst.size()) {
                        mp.put(String.valueOf(i), this.lst.get(this.lst.size() - i));
                        ++i;
                    }
                    this.metBordRes(this.buf.reverse().toString(), mp);
                }
                this.lst = null;
                this.etat = S.AR_W;
                break;
            }
            case AR_WI: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidchrst", new Object[0]);
                }
                if (this.q.get() == 91) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wi;
                    break;
                }
                if (this.q.get() == 93) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWi2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidchrst", new Object[0]);
            }
            case AR_Wi: {
                if (this.q.get() == 92) {
                    this.buf.append('[').append('\\');
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WI;
                    break;
                }
                if (this.nestlv-- > 0) {
                    this.buf.append('[');
                    this.etat = S.AR_WI;
                    break;
                }
                this.metBordCharset(this.buf.reverse().toString());
                this.etat = S.AR_W;
                break;
            }
            case ARWi2: {
                if (this.q.get() == 92) {
                    this.buf.append(']').append('\\');
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WI;
                    break;
                }
                ++this.nestlv;
                this.buf.append(']');
                this.etat = S.AR_WI;
                break;
            }
            case AR_WG: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidregex", new Object[0]);
                }
                if (this.q.get() == 96) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_Wg;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidregex", new Object[0]);
            }
            case AR_Wg: {
                if (this.q.get() == 92) {
                    this.buf.append('`');
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WG;
                    break;
                }
                try {
                    NFAState dm = new NFAState(){};
                    NFAObject<Object, NFAState, Integer> nz = RegexpParser.parse(this.buf.reverse().toString(), dm);
                    this.metBordNFA(nz, 0);
                }
                catch (RegexParseException e) {
                    throw new NinaException(this, "invalidregex", new Object[0]);
                }
                this.etat = S.AR_W;
                break;
            }
            case AR_WS: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.get() == 47 || this.q.get() == 35 || this.q.get() == 37) {
                    if (this.chr >= 0) {
                        this.buf = new StringBuffer().append((char)this.chr);
                    }
                    this.chr = this.q.get();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WM;
                    break;
                }
                if (this.seqFlag >= 0) {
                    this.etat = S.AR_W;
                    break;
                }
                if (this.chr < 0) {
                    this.metBord(this.buf.reverse().toString(), this.quote, this.quoteFlag);
                    this.etat = S.AR_W;
                    break;
                }
                this.metBord((char)this.chr);
                this.etat = S.AR_W;
                break;
            }
            case AR_WM: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.isWhitespace()) {
                    this.q.south().east();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 39 || this.q.get() == 34) {
                    this.metmealy();
                    this.quote = this.q.get();
                    this.quoteFlag = -1;
                    this.q.set(-100);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_WX;
                    break;
                }
                if (this.q.get() == 125) {
                    this.metmealy();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WR;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 93) {
                    this.metmealy();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WI;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 41) {
                    this.metmealy();
                    this.q.set(-400);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_W1;
                    break;
                }
                if (this.q.get() == 126) {
                    this.metmealy();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WW;
                    this.buf = new StringBuffer();
                    break;
                }
                if (this.q.get() == 46) {
                    this.metmealy();
                    this.q.setEdge(CharSets.ALL_CHAR);
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 47) {
                    this.metmealy();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_WE;
                    break;
                }
                if (this.q.get() == 73 || this.q.get() == 105) {
                    this.quoteFlag = this.q.get();
                    this.q.west();
                    this.etat = S.ARWMF;
                    break;
                }
                if (this.q.get() >= 65 && this.q.get() <= 90 || this.q.get() >= 97 && this.q.get() <= 122) {
                    this.metmealy();
                    this.seqFlag = this.q.get();
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.ARWBS;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.metmealy();
                    this.metBord((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidmealy", new Object[0]);
            }
            case ARWBS: {
                if (this.q.get() == 92) {
                    this.action.setEdgeBackslash(this.q, this.seqFlag);
                    this.q.set(-100);
                    this.q.west();
                } else {
                    this.metBord((char)this.seqFlag);
                }
                this.etat = S.AR_W;
                break;
            }
            case ARWMF: {
                if (this.q.get() == 34) {
                    this.metmealy();
                    this.quote = this.q.get();
                    this.q.set(-100);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.AR_WX;
                    break;
                }
                this.metmealy();
                this.metBord((char)this.q.get());
                this.q.set(-100);
                this.etat = S.AR_W;
                break;
            }
            case AR_WX: {
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "invalidmealy", new Object[0]);
                }
                if (this.q.get() == this.quote) {
                    this.metBord(this.buf.reverse().toString(), this.quote, this.quoteFlag);
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidmealy", new Object[0]);
            }
            case AR_WW: {
                if (this.q.get() == 126) {
                    this.action.setEdgeSkipSpaces(this.q, this.buf.reverse().toString());
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.append((char)this.q.get());
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.set(-100);
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidmealy", new Object[0]);
            }
            case WP_W1: {
                if (this.q.get() == 40) {
                    this.buf.reverse();
                    this.q.set(-400);
                    this.etat = S.TOJX1;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.west();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case F2_W: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                this.q.east();
                this.etat = S.F2_N;
                break;
            }
            case F2_N: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRR_S;
                    break;
                }
                this.q.south();
                this.etat = S.LBLE;
                break;
            }
            case F3_W: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.west();
                    break;
                }
                this.q.east();
                this.etat = S.LBLE;
                break;
            }
            case F3_N: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isEntry()) {
                    this.q.north();
                    break;
                }
                this.q.south();
                this.etat = S.F3_W;
                break;
            }
            case FRR_S: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.south();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                this.q.north().east();
                this.etat = S.FRR_E;
                break;
            }
            case FRR_E: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.east();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                this.q.north().west();
                this.etat = S.FRR_N;
                break;
            }
            case FRR_N: {
                if (this.q.isFrame() || this.q.isArrow() || this.q.isDone()) {
                    this.q.set(-300);
                    this.q.north();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                this.q.south().west();
                this.etat = S.FRR_W;
                break;
            }
            case FRR_W: {
                if (this.q.isFrame() || this.q.isArrow()) {
                    this.q.set(-300);
                    this.q.west();
                    break;
                }
                if (this.q.isEntry()) {
                    this.q.set(-300);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.getVisiting() != null) {
                    this.buf = new StringBuffer(this.q.getVisiting());
                    this.q.setVisiting(null);
                    this.etat = S.TOIX2;
                    break;
                }
                if (this.enddead) {
                    this.etat = S.DED04;
                    break;
                }
                this.etat = S.DED01;
                break;
            }
            case DED01: {
                if (this.q.isBlankX()) {
                    this.q.east();
                    this.etat = S.DED02;
                    break;
                }
                this.q.west();
                break;
            }
            case DED02: {
                if (this.q.isBlankY() || this.q.get() == 35) {
                    this.q.south();
                    this.etat = S.DED03;
                    break;
                }
                this.q.north();
                break;
            }
            case DED03: {
                if (this.q.isBlankY()) {
                    this.q.north();
                    this.etat = S.DED05;
                    break;
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (!DEADSYM.equals(this.q.getLabel())) {
                    this.q.east();
                    break;
                }
                if (this.q.getScratch() != null) {
                    this.etat = S.DED04;
                    break;
                }
                this.enddead = true;
                this.action.setVertex(this.action.createState(this.q));
                this.etat = S.LBLE;
                break;
            }
            case DED04: {
                if (this.q.isBlankX()) {
                    this.q.east();
                    this.etat = S.DED05;
                    break;
                }
                this.q.west();
                break;
            }
            case DED05: {
                if (this.q.isBlankY() || this.q.get() == 35) {
                    this.q.south();
                    this.etat = S.DED06;
                    break;
                }
                this.q.north();
                break;
            }
            case DED06: {
                if (this.q.isBlankY()) {
                    return this.action.accept(this.q.getName());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.getLabel() == null) {
                    this.q.east();
                    break;
                }
                if (this.q.getScratch() != null) {
                    this.action.putStateByLabel(this.q.getLabel(), this.q.getScratch());
                    this.action.putTypeByLabel(this.q.getLabel(), this.q.getLabelType());
                    this.q.east();
                    break;
                }
                this.action.setVertex(this.action.createState(this.q));
                this.etat = S.LBLE;
                break;
            }
            case ARR_N: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.isBranch()) {
                    this.q.setEdge(((Z)this.q.getScratch()).edge);
                    this.action.setVertex(((Z)this.q.getScratch()).vertex);
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.west();
                    this.etat = S.FR_W;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.east();
                    this.etat = S.FRR_E;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.south();
                    this.etat = S.ARRZW;
                    break;
                }
                if (this.q.get() == 42 || this.q.get() == 64) {
                    this.q.west();
                    this.etat = S.ONS_W;
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case ARRZW: {
                this.q.set(-300);
                this.etat = S.FRR_W;
                break;
            }
            case ARR_E: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.east();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_E2;
                    break;
                }
                if (this.q.isBranch()) {
                    this.q.setEdge(((Z)this.q.getScratch()).edge);
                    this.action.setVertex(((Z)this.q.getScratch()).vertex);
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.north();
                    this.etat = S.FR_N;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.south();
                    this.etat = S.FRR_S;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.west();
                    this.etat = S.ARRZN;
                    break;
                }
                if (this.q.get() == 42 || this.q.get() == 64) {
                    this.q.north();
                    this.etat = S.ONS_n;
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case WP_E2: {
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.etat = S.TOIX2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case ARRZN: {
                this.q.set(-300);
                this.etat = S.FRR_N;
                break;
            }
            case ARR_S: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.isBranch()) {
                    this.q.setEdge(((Z)this.q.getScratch()).edge);
                    this.action.setVertex(((Z)this.q.getScratch()).vertex);
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.east();
                    this.etat = S.FR_E;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.west();
                    this.etat = S.FRR_W;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.north();
                    this.etat = S.ARRZE;
                    break;
                }
                if (this.q.get() == 42 || this.q.get() == 64) {
                    this.q.east();
                    this.etat = S.ONS_E;
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case ARRZE: {
                this.q.set(-300);
                this.etat = S.FRR_S;
                break;
            }
            case ARR_W: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.west();
                    this.buf = new StringBuffer();
                    this.etat = S.WP_W2;
                    break;
                }
                if (this.q.isBranch()) {
                    this.q.setEdge(((Z)this.q.getScratch()).edge);
                    this.action.setVertex(((Z)this.q.getScratch()).vertex);
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.south();
                    this.etat = S.FR_S;
                    break;
                }
                if (this.q.isDone()) {
                    this.q.north();
                    this.etat = S.FRR_N;
                    break;
                }
                if (this.q.isArrow3()) {
                    this.q.east();
                    this.etat = S.ARRZS;
                    break;
                }
                if (this.q.get() == 42 || this.q.get() == 64) {
                    this.q.south();
                    this.etat = S.ONS_S;
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case WP_W2: {
                if (this.q.get() == -400) {
                    this.buf.reverse();
                    this.q.set(-402);
                    this.etat = S.TOIX2;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.buf.appendCodePoint(this.q.get());
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case ARRZS: {
                this.q.set(-300);
                this.etat = S.FRR_S;
                break;
            }
            case BR_N: {
                if (this.q.get() == 124) {
                    this.q.set(-103);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-103);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 47) {
                    this.q.set(-103);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 94) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.set(-501);
                        this.q.south();
                        this.etat = S.ARR_S;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F2_W;
                    break;
                }
                if (this.q.isBranchN()) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.set(Quadro.putWedgeN(this.q.get()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                this.q.south();
                this.q.set(Quadro.putWedgeE(this.q.get()));
                this.q.east();
                this.etat = S.BR_E;
                break;
            }
            case BR_E: {
                if (this.q.get() == 45) {
                    this.q.set(-101);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-101);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 47) {
                    this.q.set(-101);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 62) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.set(-501);
                        this.q.west();
                        this.etat = S.ARR_W;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F2_N;
                    break;
                }
                if (this.q.isBranchE()) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.set(Quadro.putWedgeN(this.q.get()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                this.q.west();
                this.q.set(Quadro.putWedgeS(this.q.get()));
                this.q.south();
                this.etat = S.BR_S;
                break;
            }
            case BR_S: {
                if (this.q.get() == 124) {
                    this.q.set(-102);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-102);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() == 47) {
                    this.q.set(-102);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 118) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.set(-501);
                        this.q.north();
                        this.etat = S.ARR_N;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F3_W;
                    break;
                }
                if (this.q.isBranchS()) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.set(Quadro.putWedgeN(this.q.get()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                this.q.north();
                this.q.set(Quadro.putWedgeW(this.q.get()));
                this.q.west();
                this.etat = S.BR_W;
                break;
            }
            case BR_W: {
                if (this.q.get() == 45) {
                    this.q.set(-100);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.set(-100);
                    this.q.north();
                    this.etat = S.AR_N;
                    break;
                }
                if (this.q.get() == 47) {
                    this.q.set(-100);
                    this.q.south();
                    this.etat = S.AR_S;
                    break;
                }
                if (this.q.get() == 60) {
                    Object o = this.q.getScratch();
                    this.action.link(this.q, o);
                    if (o != null) {
                        this.q.set(-501);
                        this.q.east();
                        this.etat = S.ARR_E;
                        break;
                    }
                    this.q.set(-301);
                    this.etat = S.F3_N;
                    break;
                }
                if (this.q.isBranchW()) {
                    this.q.setScratch(new Z(this.action.getVertex(), this.q.getEdge()));
                    this.q.set(Quadro.putWedgeN(this.q.get()));
                    this.q.north();
                    this.etat = S.BR_N;
                    break;
                }
                this.q.east().north();
                this.etat = S.BR2_N;
                break;
            }
            case BR2_N: {
                if (this.q.get() == -102) {
                    this.q.set(-203);
                    this.q.north();
                    this.etat = S.ARR_N;
                    break;
                }
                if (this.q.isWedgeN()) {
                    this.q.east();
                    this.etat = S.BR_E;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.west();
                    this.etat = S.FR_W;
                    break;
                }
                this.q.south().east();
                this.etat = S.BR2_E;
                break;
            }
            case BR2_E: {
                if (this.q.get() == -100) {
                    this.q.set(-201);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                if (this.q.isWedgeE()) {
                    this.q.south();
                    this.etat = S.BR_S;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.north();
                    this.etat = S.FR_N;
                    break;
                }
                this.q.west().south();
                this.etat = S.BR2_S;
                break;
            }
            case BR2_S: {
                if (this.q.get() == -103) {
                    this.q.set(-202);
                    this.q.south();
                    this.etat = S.ARR_S;
                    break;
                }
                if (this.q.isWedgeS()) {
                    this.q.west();
                    this.etat = S.BR_W;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.east();
                    this.etat = S.FR_E;
                    break;
                }
                this.q.north().west();
                this.etat = S.BR2_W;
                break;
            }
            case BR2_W: {
                if (this.q.get() == -101) {
                    this.q.set(-200);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                if (this.q.isWedgeW()) {
                    this.q.north();
                    this.etat = S.BR2_N;
                    break;
                }
                if (this.q.isArrow()) {
                    this.action.setVertex(this.q.getScratch());
                    this.q.south();
                    this.etat = S.FR_S;
                    break;
                }
                throw new NinaException(this, "invalidedge", new Object[0]);
            }
            case TOIX1: {
                this.regX = this.q.getX();
                this.regY = this.q.getY();
                this.etat = S.TOIx1;
                this.todir = Quadro.Direction.WEST;
                break;
            }
            case TOJX1: {
                this.regX = this.q.getX();
                this.regY = this.q.getY();
                this.etat = S.TOIx1;
                this.todir = Quadro.Direction.EAST;
                break;
            }
            case TOIx1: {
                if (this.q.isBlankX()) {
                    this.q.east();
                    this.etat = S.TOIY1;
                    break;
                }
                this.q.west();
                break;
            }
            case TOIY1: {
                if (this.q.isBlankY() || this.q.get() == 35) {
                    this.q.south();
                    this.etat = S.SER1E;
                    break;
                }
                this.q.north();
                break;
            }
            case SER1E: {
                if (this.q.isBlankY()) {
                    this.q.north();
                    this.etat = S.TORY1;
                    break;
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.getLabel() == null || !this.q.getLabel().equals(this.buf.toString())) {
                    this.q.east();
                    break;
                }
                Object o = this.q.getScratch();
                this.action.link(this.q, o);
                if (o != null) {
                    this.q.setPosition(this.regX, this.regY);
                    this.q.set(-402);
                    this.q.west();
                    this.etat = S.RETP1;
                    break;
                }
                this.q.setVisiting(this.buf.toString());
                this.etat = S.LBLE;
                break;
            }
            case RETP1: {
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.move(this.todir);
                    this.etat = this.todir.equals((Object)Quadro.Direction.WEST) ? S.ARR_W : S.ARR_E;
                    break;
                }
                if (this.q.isBlankX()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                this.q.move(this.todir);
                break;
            }
            case TORY1: {
                if (this.q.isBlankY() || this.q.get() == 35) {
                    this.q.south();
                    this.etat = S.SER11;
                    break;
                }
                this.q.north();
                break;
            }
            case SER11: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.east();
                    this.etat = S.SER1q;
                    break;
                }
                if (this.q.get() == 91) {
                    this.q.east();
                    this.etat = S.SER1c;
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.east();
                    this.etat = S.SER1r;
                    break;
                }
                if (this.q.get() == 40) {
                    this.q.east();
                    this.etat = S.SER1F;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() == 45) {
                    this.q.east();
                    this.etat = S.SER1W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1q: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.east();
                    this.etat = S.SER1b;
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.east();
                    this.etat = S.SER11;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1c: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 93) {
                    this.q.east();
                    this.etat = S.SER11;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1r: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.east();
                    this.etat = S.SER11;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1b: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    this.etat = S.SER1q;
                    break;
                }
                this.q.east();
                this.etat = S.SER1q;
                break;
            }
            case SER1F: {
                if (this.q.get() == 41) {
                    if (this.buf.toString().equals(this.bf2.toString())) {
                        this.q.west();
                        this.etat = S.SER1G;
                        break;
                    }
                    this.etat = S.SER11;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "labelnotfound", this.buf.toString());
            }
            case SER1G: {
                if (this.q.get() == 40) {
                    this.q.set(-400);
                    this.q.east();
                    this.etat = S.SER1H;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "labelnotfound", this.buf.toString());
            }
            case SER1H: {
                if (this.q.get() == 41) {
                    this.q.set(-400);
                    this.q.east();
                    this.etat = S.AR_E;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "labelnotfound", this.buf.toString());
            }
            case SER1W: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.east();
                    this.etat = S.SER1Q;
                    break;
                }
                if (this.q.get() == 91) {
                    this.q.east();
                    this.etat = S.SER1C;
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.east();
                    this.etat = S.SER1R;
                    break;
                }
                if (this.q.get() == 40) {
                    this.q.east();
                    this.etat = S.SER1X;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() != 45) {
                    this.q.east();
                    this.etat = S.SER11;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1Q: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 92) {
                    this.q.east();
                    this.etat = S.SER1B;
                    break;
                }
                if (this.q.get() == 39) {
                    this.q.east();
                    this.etat = S.SER1W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1C: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 93) {
                    this.q.east();
                    this.etat = S.SER1W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1R: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == 96) {
                    this.q.east();
                    this.etat = S.SER1W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER1B: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    this.etat = S.SER1Q;
                    break;
                }
                this.q.east();
                this.etat = S.SER1Q;
                break;
            }
            case SER1X: {
                if (this.q.get() == 41) {
                    if (this.buf.toString().equals(this.bf2.toString())) {
                        this.q.set(-400);
                        this.q.west();
                        this.etat = S.SER1Y;
                        break;
                    }
                    this.etat = S.SER1W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "labelnotfound", this.buf.toString());
            }
            case SER1Y: {
                if (this.q.get() == 40) {
                    this.q.set(-400);
                    this.q.west();
                    this.etat = S.AR_W;
                    break;
                }
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                throw new NinaException(this, "labelnotfound", this.buf.toString());
            }
            case TOIX2: {
                if (this.q.isBlankX()) {
                    this.q.east();
                    this.etat = S.TOIY2;
                    break;
                }
                this.q.west();
                break;
            }
            case TOIY2: {
                if (this.q.isBlankY() || this.q.get() == 35) {
                    this.q.south();
                    this.etat = S.SER2E;
                    break;
                }
                this.q.north();
                break;
            }
            case SER2E: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.east();
                    this.etat = S.SER2F;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() == -101) {
                    this.q.east();
                    this.etat = S.SER2W;
                    break;
                }
                this.q.east();
                break;
            }
            case SER2F: {
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                if (this.q.get() != -400) {
                    this.q.east();
                    this.etat = S.SER2E;
                    break;
                }
                if (this.buf.toString().equals(this.bf2.toString())) {
                    this.q.west();
                    this.etat = S.SER2G;
                    break;
                }
                this.etat = S.SER2E;
                break;
            }
            case SER2G: {
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.east();
                    this.etat = S.SER2H;
                    break;
                }
                if (this.q.get() == -1) {
                    this.q.east();
                    break;
                }
                throw new NinaException(this, "labelnotfound", this.buf.toString());
            }
            case SER2H: {
                if (this.q.get() >= 0) {
                    this.q.east();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.east();
                    this.etat = S.ARR_E;
                    break;
                }
                throw new NinaException(this, "labelnotfound", this.buf.toString());
            }
            case SER2W: {
                if (this.q.isBlankY()) {
                    throw new NinaException(this, "labelnotfound", this.buf.toString());
                }
                if (this.q.isBlankX()) {
                    this.q.cr();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.east();
                    this.etat = S.SER2X;
                    this.bf2 = new StringBuffer();
                    break;
                }
                if (this.q.get() != -101) {
                    this.q.east();
                    this.etat = S.SER2E;
                    break;
                }
                this.q.east();
                break;
            }
            case SER2X: {
                if (this.q.get() >= 0) {
                    this.bf2.appendCodePoint(this.q.get());
                    this.q.east();
                    break;
                }
                if (this.q.get() != -400) {
                    this.q.east();
                    this.etat = S.SER2E;
                    break;
                }
                if (this.buf.toString().equals(this.bf2.toString())) {
                    this.q.set(-402);
                    this.q.west();
                    this.etat = S.SER2Y;
                    break;
                }
                this.etat = S.SER2E;
                break;
            }
            case SER2Y: {
                if (this.q.get() >= 0) {
                    this.q.west();
                    break;
                }
                if (this.q.get() == -400) {
                    this.q.set(-402);
                    this.q.west();
                    this.etat = S.ARR_W;
                    break;
                }
                throw new NinaException(this, "labelnotfound", this.buf.toString());
            }
            case ONS_0: {
                this.q.north();
                this.etat = S.ONS_N;
                break;
            }
            case ONS_N: {
                if (this.q.get() == 124 || this.q.get() == 47 || this.q.get() == 92 || this.q.isBranchN()) {
                    this.etat = S.AR_N;
                    break;
                }
                this.q.south().east();
                this.etat = S.ONS_E;
                break;
            }
            case ONS_E: {
                if (this.q.get() == 45 || this.q.get() == 47 || this.q.get() == 92 || this.q.isBranchE()) {
                    this.etat = S.AR_E;
                    break;
                }
                this.q.south().west();
                this.etat = S.ONS_S;
                break;
            }
            case ONS_S: {
                if (this.q.get() == 124 || this.q.get() == 47 || this.q.get() == 92 || this.q.isBranchS()) {
                    this.etat = S.AR_S;
                    break;
                }
                this.q.north().west();
                this.etat = S.ONS_W;
                break;
            }
            case ONS_W: {
                if (this.q.get() == 45 || this.q.get() == 47 || this.q.get() == 92 || this.q.isBranchE()) {
                    this.etat = S.AR_E;
                    break;
                }
                this.q.north().east();
                this.etat = S.ONS_n;
                break;
            }
            case ONS_n: {
                if (this.q.get() == -102 || this.q.isBranch()) {
                    this.etat = S.ARR_N;
                    break;
                }
                this.q.south().east();
                this.etat = S.ONS_e;
                break;
            }
            case ONS_e: {
                if (this.q.get() == -100 || this.q.isBranch()) {
                    this.etat = S.ARR_E;
                    break;
                }
                this.q.south().west();
                this.etat = S.ONS_s;
                break;
            }
            case ONS_s: {
                if (this.q.get() == -103 || this.q.isBranch()) {
                    this.etat = S.ARR_S;
                    break;
                }
                this.q.north().west();
                this.etat = S.ONS_w;
                break;
            }
            case ONS_w: {
                if (this.q.get() == -101 || this.q.isBranch()) {
                    this.etat = S.ARR_W;
                    break;
                }
                throw new RuntimeException();
            }
        }
        int n = this.counter = z == this.etat ? this.counter + 1 : 0;
        if (this.allCounter++ > ITERATION) {
            throw new NinaException("iterationover", ITERATION);
        }
        if (this.counter > 100000) {
            throw new RuntimeException(z.toString());
        }
        return null;
    }

    public String getPragma(String s) {
        return this.pragmas.get(s);
    }

    public void printTrace(PrintStream pr) {
        pr.println((Object)this.etat);
        pr.println(this.q.toString());
        pr.println((int)((char)(this.q.get() < 0 ? this.q.get() : (char)this.q.get())));
    }

    private static enum S {
        INIT,
        PRAG0,
        PRAG,
        LICN1,
        PACK,
        MACHN,
        TYPE,
        TYP2,
        TYP3,
        OPTN,
        OPTV,
        OPTQ,
        ALIAS,
        ALI_V,
        ALI_Q,
        PLB_1,
        PLB_2,
        PDF_1,
        PDF_2,
        PDF_3,
        REQ1,
        REQ2,
        VTYP1,
        SETCM,
        SETCH,
        COMNT,
        DEF1,
        DEF2,
        DEF3,
        DEF4,
        DEFI1,
        DEFI2,
        LINIT,
        LINI2,
        FI_L0,
        FI_L1,
        FI_L2,
        FI_L3,
        FI_L4,
        FI_E,
        FI_E2,
        FI_S,
        FI_S2,
        FI_W,
        FI_W2,
        FI_N,
        LQUOT,
        LCSET,
        LGNFA,
        LGRE,
        LGRE1,
        LGRE2,
        LSNFA,
        PRI01,
        PRI02,
        PRI03,
        PRI04,
        LPRI1,
        LPRI2,
        LBLE,
        FL_S,
        FL_W,
        FL_N,
        FL_E,
        FMNW,
        FMNW2,
        FM_E,
        FMNE,
        FMNE2,
        FM_S,
        FMSE,
        FMSE2,
        FM_W,
        FMSW,
        FMSW2,
        FM_N,
        FRNW,
        FRNW2,
        FR_E,
        FRNE,
        FRNE2,
        FR_S,
        FRSE,
        FRSE2,
        FR_W,
        FRSW,
        FRSW2,
        FR_N,
        AR_N,
        AR_E,
        AR_EE,
        AR_Ee,
        AR_EB,
        AREN0,
        AREN1,
        AR_EQ,
        AREQF,
        AR_Eq,
        ARED1,
        ARED2,
        AR_ER,
        ARER1,
        ARER2,
        ARER3,
        ARER4,
        AR_EI,
        AR_Ei,
        AR_EG,
        AR_Eg,
        AR_ES,
        AR_EM,
        AR_EX,
        AR_EW,
        AREE1,
        AREE2,
        AR_S,
        AR_W,
        AR_WE,
        AR_We,
        AR_WB,
        ARWQF,
        ARWN0,
        ARWN1,
        ARWN2,
        AR_WQ,
        AR_Wq,
        AR_Wy,
        AR_Wn,
        AR_Wr,
        AR_Wt,
        AR_W0,
        ARWD1,
        ARWD2,
        AR_WR,
        ARWR1,
        ARWR2,
        ARWR3,
        ARWR4,
        ARWR5,
        AR_WI,
        AR_Wi,
        ARWi2,
        AR_WG,
        AR_Wg,
        AR_WS,
        AR_WM,
        ARWBS,
        ARWMF,
        AR_WX,
        AR_WW,
        AR_ZN,
        AR_ZS,
        AR_ZE,
        AR_ZW,
        F2_W,
        F2_N,
        F3_W,
        F3_N,
        BR_N,
        BR_E,
        BR_S,
        BR_W,
        BR2_N,
        BR2_E,
        BR2_S,
        BR2_W,
        FRR_S,
        FRR_E,
        FRR_N,
        FRR_W,
        DED01,
        DED02,
        DED03,
        DED04,
        DED05,
        DED06,
        ARR_N,
        ARR_E,
        ARR_S,
        ARR_W,
        ARRZN,
        ARRZS,
        ARRZE,
        ARRZW,
        WP_E1,
        WP_W1,
        TOIX1,
        TOJX1,
        TOIx1,
        TOIY1,
        SER1E,
        RETP1,
        TORY1,
        SER11,
        SER1q,
        SER1c,
        SER1r,
        SER1b,
        SER1F,
        SER1G,
        SER1H,
        SER1W,
        SER1Q,
        SER1C,
        SER1R,
        SER1B,
        SER1X,
        SER1Y,
        WP_E2,
        WP_W2,
        TOIX2,
        TOIY2,
        SER2E,
        SER2F,
        SER2G,
        SER2H,
        SER2W,
        SER2X,
        SER2Y,
        ONS_0,
        ONS_N,
        ONS_E,
        ONS_S,
        ONS_W,
        ONS_n,
        ONS_e,
        ONS_s,
        ONS_w;

    }

    static class Z {
        Object vertex;
        Object edge;

        Z(Object v, Object e) {
            this.vertex = v;
            this.edge = e;
        }
    }
}

