package net.morilib.regex;

import net.morilib.range.integer.IntRange;
import net.morilib.regex.dfa.CharSet;
import junit.framework.TestCase;

public class CharSetTest extends TestCase {

	public void test0001() {
		IntRange r;

		r = CharSet.parse("c");
		assertTrue(r.contains('c'));
		assertFalse(r.contains('b'));
		assertFalse(r.contains('d'));
		assertFalse(r.contains('C'));
	}

	public void test0002() {
		IntRange r;

		r = CharSet.parse("cd");
		assertTrue(r.contains('c'));
		assertTrue(r.contains('d'));
		assertFalse(r.contains('b'));
		assertFalse(r.contains('e'));
		assertFalse(r.contains('C'));
	}

	public void test0003() {
		IntRange r;

		r = CharSet.parse("c-x");
		assertTrue(r.contains('c'));
		assertTrue(r.contains('d'));
		assertTrue(r.contains('x'));
		assertFalse(r.contains('b'));
		assertFalse(r.contains('y'));
		assertFalse(r.contains('C'));
	}

	public void test0004() {
		IntRange r;

		r = CharSet.parse("\\x63-\\x78");
		assertTrue(r.contains('c'));
		assertTrue(r.contains('d'));
		assertTrue(r.contains('x'));
		assertFalse(r.contains('b'));
		assertFalse(r.contains('y'));
		assertFalse(r.contains('C'));
	}

	public void test0005() {
		IntRange r;

		r = CharSet.parse("\\u0063-\\u0078");
		assertTrue(r.contains('c'));
		assertTrue(r.contains('d'));
		assertTrue(r.contains('x'));
		assertFalse(r.contains('b'));
		assertFalse(r.contains('y'));
		assertFalse(r.contains('C'));
	}

	public void test0006() {
		IntRange r;

		r = CharSet.parse("cde");
		assertTrue(r.contains('c'));
		assertTrue(r.contains('d'));
		assertTrue(r.contains('e'));
		assertFalse(r.contains('b'));
		assertFalse(r.contains('f'));
		assertFalse(r.contains('C'));
	}

	public void test0007() {
		IntRange r;

		r = CharSet.parse("edc");
		assertTrue(r.contains('c'));
		assertTrue(r.contains('d'));
		assertTrue(r.contains('e'));
		assertFalse(r.contains('b'));
		assertFalse(r.contains('f'));
		assertFalse(r.contains('C'));
	}

	public void test0008() {
		IntRange r;

		r = CharSet.parse("Cc-xE");
		assertTrue(r.contains('c'));
		assertTrue(r.contains('d'));
		assertTrue(r.contains('x'));
		assertTrue(r.contains('C'));
		assertTrue(r.contains('E'));
		assertFalse(r.contains('b'));
		assertFalse(r.contains('y'));
		assertFalse(r.contains('B'));
		assertFalse(r.contains('D'));
		assertFalse(r.contains('F'));
	}

	public void test0009() {
		IntRange r;

		r = CharSet.parse("\\d");
		assertTrue(r.contains('0'));
		assertTrue(r.contains('1'));
		assertTrue(r.contains('9'));
		assertFalse(r.contains('/'));
		assertFalse(r.contains(':'));
		assertFalse(r.contains('F'));
	}

	public void test0010() {
		IntRange r;

		r = CharSet.parse("\\w");
		assertTrue(r.contains('a'));
		assertTrue(r.contains('f'));
		assertTrue(r.contains('z'));
		assertTrue(r.contains('A'));
		assertTrue(r.contains('F'));
		assertTrue(r.contains('Z'));
		assertTrue(r.contains('0'));
		assertTrue(r.contains('1'));
		assertTrue(r.contains('9'));
		assertTrue(r.contains('_'));
		assertFalse(r.contains('@'));
		assertFalse(r.contains('['));
		assertFalse(r.contains('`'));
		assertFalse(r.contains('{'));
		assertFalse(r.contains('^'));
		assertFalse(r.contains('/'));
		assertFalse(r.contains(':'));
	}

	public void test0011() {
		IntRange r;

		r = CharSet.parse("\\s");
		assertTrue(r.contains(' '));
		assertTrue(r.contains('\t'));
		assertTrue(r.contains('\n'));
		assertFalse(r.contains('!'));
		assertFalse(r.contains('a'));
		assertFalse(r.contains(':'));
	}

	public void test0012() {
		IntRange r;

		r = CharSet.parse("\\D");
		assertTrue(r.contains('/'));
		assertTrue(r.contains(':'));
		assertTrue(r.contains('F'));
		assertFalse(r.contains('0'));
		assertFalse(r.contains('1'));
		assertFalse(r.contains('9'));
	}

	public void test0013() {
		IntRange r;

		r = CharSet.parse("\\W");
		assertTrue(r.contains('@'));
		assertTrue(r.contains('['));
		assertTrue(r.contains('`'));
		assertTrue(r.contains('{'));
		assertTrue(r.contains('^'));
		assertTrue(r.contains('/'));
		assertTrue(r.contains(':'));
		assertFalse(r.contains('a'));
		assertFalse(r.contains('f'));
		assertFalse(r.contains('z'));
		assertFalse(r.contains('A'));
		assertFalse(r.contains('F'));
		assertFalse(r.contains('Z'));
		assertFalse(r.contains('0'));
		assertFalse(r.contains('1'));
		assertFalse(r.contains('9'));
		assertFalse(r.contains('_'));
	}

	public void test0014() {
		IntRange r;

		r = CharSet.parse("\\S");
		assertTrue(r.contains('!'));
		assertTrue(r.contains('a'));
		assertTrue(r.contains(':'));
		assertFalse(r.contains(' '));
		assertFalse(r.contains('\t'));
		assertFalse(r.contains('\n'));
	}

	public void test0015() {
		IntRange r;

		r = CharSet.parse("\\p{L}");
		assertTrue(r.contains('A'));
		assertTrue(r.contains('z'));
		assertTrue(r.contains('\u03bb'));       // Greek Letter lambda
		assertTrue(r.contains('\u0430'));       // Cyrillic Letter a
		assertTrue(r.contains('\u3042'));       // Hiragana a
		// Kanji(Hanzi) indicates "Truth" and pronounces "Makoto/Shin" in Japanese
		assertTrue(r.contains('\u771f'));
		assertTrue(r.contains('\uac00'));       // Hangul ga
		assertFalse(r.contains(' '));
		assertFalse(r.contains('@'));
		assertFalse(r.contains('\u3099'));      // Hiragana Dakuon mark
	}

	public void test0016() {
		IntRange r;

		r = CharSet.parse("\\&");
		assertTrue(r.contains('&'));
		assertFalse(r.contains('%'));
		assertFalse(r.contains('\''));
		assertFalse(r.contains('C'));
	}

	public void test0017() {
		IntRange r;

		r = CharSet.parse("\\&-\\-");
		assertTrue(r.contains('&'));
		assertTrue(r.contains('+'));
		assertTrue(r.contains('-'));
		assertFalse(r.contains('%'));
		assertFalse(r.contains('.'));
		assertFalse(r.contains('C'));
	}

	public void test0101() {
		IntRange r;

		r = CharSet.parse("^c");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('d'));
		assertTrue(r.contains('C'));
		assertFalse(r.contains('c'));
	}

	public void test0102() {
		IntRange r;

		r = CharSet.parse("^cd");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('e'));
		assertTrue(r.contains('C'));
		assertFalse(r.contains('c'));
		assertFalse(r.contains('d'));
	}

	public void test0103() {
		IntRange r;

		r = CharSet.parse("^c-x");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('y'));
		assertTrue(r.contains('C'));
		assertFalse(r.contains('c'));
		assertFalse(r.contains('d'));
		assertFalse(r.contains('x'));
	}

	public void test0104() {
		IntRange r;

		r = CharSet.parse("^\\x63-\\x78");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('y'));
		assertTrue(r.contains('C'));
		assertFalse(r.contains('c'));
		assertFalse(r.contains('d'));
		assertFalse(r.contains('x'));
	}

	public void test0105() {
		IntRange r;

		r = CharSet.parse("^\\u0063-\\u0078");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('y'));
		assertTrue(r.contains('C'));
		assertFalse(r.contains('c'));
		assertFalse(r.contains('d'));
		assertFalse(r.contains('x'));
	}

	public void test0107() {
		IntRange r;

		r = CharSet.parse("^cde");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('f'));
		assertTrue(r.contains('C'));
		assertFalse(r.contains('c'));
		assertFalse(r.contains('d'));
		assertFalse(r.contains('e'));
	}

	public void test0108() {
		IntRange r;

		r = CharSet.parse("^Cc-xE");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('y'));
		assertTrue(r.contains('B'));
		assertTrue(r.contains('D'));
		assertTrue(r.contains('F'));
		assertFalse(r.contains('c'));
		assertFalse(r.contains('d'));
		assertFalse(r.contains('x'));
		assertFalse(r.contains('C'));
		assertFalse(r.contains('E'));
	}

	public void test0109() {
		IntRange r;

		r = CharSet.parse("^\\d");
		assertTrue(r.contains('/'));
		assertTrue(r.contains(':'));
		assertTrue(r.contains('F'));
		assertFalse(r.contains('0'));
		assertFalse(r.contains('1'));
		assertFalse(r.contains('9'));
	}

	public void test0110() {
		IntRange r;

		r = CharSet.parse("^\\D");
		assertTrue(r.contains('0'));
		assertTrue(r.contains('1'));
		assertTrue(r.contains('9'));
		assertFalse(r.contains('/'));
		assertFalse(r.contains(':'));
		assertFalse(r.contains('F'));
	}

	public void test0201() {
		IntRange r;

		r = CharSet.parse("c-x&f-y");
		assertTrue(r.contains('f'));
		assertTrue(r.contains('g'));
		assertTrue(r.contains('x'));
		assertFalse(r.contains('e'));
		assertFalse(r.contains('y'));
		assertFalse(r.contains('C'));
	}

	public void test0202() {
		IntRange r;

		r = CharSet.parse("c-x&f-y&a-h");
		assertTrue(r.contains('f'));
		assertTrue(r.contains('g'));
		assertTrue(r.contains('h'));
		assertFalse(r.contains('e'));
		assertFalse(r.contains('i'));
		assertFalse(r.contains('C'));
	}

	public void test0203() {
		IntRange r;

		r = CharSet.parse("f-y&c-x");
		assertTrue(r.contains('f'));
		assertTrue(r.contains('g'));
		assertTrue(r.contains('x'));
		assertFalse(r.contains('e'));
		assertFalse(r.contains('y'));
		assertFalse(r.contains('C'));
	}

	public void test0301() {
		IntRange r;

		r = CharSet.parse("[c-x]");
		assertTrue(r.contains('c'));
		assertTrue(r.contains('g'));
		assertTrue(r.contains('x'));
		assertFalse(r.contains('b'));
		assertFalse(r.contains('y'));
		assertFalse(r.contains('C'));
	}

	public void test0302() {
		IntRange r;

		r = CharSet.parse("[^c-x]");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('y'));
		assertTrue(r.contains('C'));
		assertFalse(r.contains('c'));
		assertFalse(r.contains('g'));
		assertFalse(r.contains('x'));
	}

	public void test0303() {
		IntRange r;

		r = CharSet.parse("[c-x]b");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('g'));
		assertTrue(r.contains('x'));
		assertFalse(r.contains('a'));
		assertFalse(r.contains('y'));
		assertFalse(r.contains('C'));
	}

	public void test0304() {
		IntRange r;

		r = CharSet.parse("[^c-x]c");
		assertTrue(r.contains('c'));
		assertTrue(r.contains('y'));
		assertTrue(r.contains('C'));
		assertFalse(r.contains('d'));
		assertFalse(r.contains('g'));
		assertFalse(r.contains('x'));
	}

	public void test0305() {
		IntRange r;

		r = CharSet.parse("[c-x]&[f-y]");
		assertTrue(r.contains('f'));
		assertTrue(r.contains('g'));
		assertTrue(r.contains('x'));
		assertFalse(r.contains('e'));
		assertFalse(r.contains('y'));
		assertFalse(r.contains('C'));
	}

	public void test0306() {
		IntRange r;

		r = CharSet.parse("c-x&[^f]");
		assertTrue(r.contains('c'));
		assertTrue(r.contains('e'));
		assertTrue(r.contains('g'));
		assertTrue(r.contains('x'));
		assertFalse(r.contains('b'));
		assertFalse(r.contains('f'));
		assertFalse(r.contains('y'));
		assertFalse(r.contains('C'));
	}

	public void test0307() {
		IntRange r;

		r = CharSet.parse("^c-x&[^f]");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('f'));
		assertTrue(r.contains('y'));
		assertTrue(r.contains('C'));
		assertFalse(r.contains('c'));
		assertFalse(r.contains('e'));
		assertFalse(r.contains('g'));
		assertFalse(r.contains('x'));
	}

	public void test0308() {
		IntRange r;

		r = CharSet.parse("[^c-x&[^f]]");
		assertTrue(r.contains('b'));
		assertTrue(r.contains('f'));
		assertTrue(r.contains('y'));
		assertTrue(r.contains('C'));
		assertFalse(r.contains('c'));
		assertFalse(r.contains('e'));
		assertFalse(r.contains('g'));
		assertFalse(r.contains('x'));
	}

}
