/*
 * Translated by Nina
 * This source code is under public domain
 */

package net.morilib.nina.translate;
import net.morilib.automata.DFAState;

public  class ReplaceAction   {

	static class TokenException extends RuntimeException {
	}

	static abstract class Engine {
		abstract int step(java.io.Reader __rd, int c) throws java.io.IOException;
		abstract boolean accepted();
		abstract int execaction(int c);
		abstract boolean isend();
		abstract int recover(Exception e);
		abstract int deadState();
		abstract int stateSize();
		abstract int finallyState();
	}
	private static final int NINA_ACCEPT = -1;
	private static final int NINA_FAIL = -9;
	private static final int NINA_HALT_ACCEPT = -91;
	private static final int NINA_HALT_REJECT = -72;
	private static final int NINA_YIELD = -85;
	private static final int NINA_BEGIN = -2;
	private static final int NINA_STACKLEN = 72;
	static final int INITIAL = 0;

	private int STATE;
	private int[] __sts = new int[NINA_STACKLEN];
	private Engine[] __stk = new Engine[NINA_STACKLEN];
	private Object[][] __stv = new Object[NINA_STACKLEN][];
	private int __slen = 0;

	private int unread = -1;
	Object yieldObject;
	java.io.Reader befstream = null;
	Throwable exception;

	private int __lookahead_state;
	private int __lookahead_mark = -1;
	private int[] __lookahead = null;
	private int __lookahead_ptr = -1;
	private int[] __lookaheadw = null;
	private int __lookaheadw_ptr = -1;
	private boolean __lookahead_ok = true;

private static final String STATELABEL = "STATELABEL_";
private static final int SL_LEN = STATELABEL.length();

private boolean exeo = false;
private StringBuffer b1, ot;
private AbstractNinaTranslator action;
private String lb;
private int cn;

ReplaceAction() {}

private void _init() {
	if(b1.length() > 0)  b1 = new StringBuffer();
}

private void _apc(int c) {
	if(c >= 0)  ot.appendCodePoint(c);
}

private void _apb(int c) {
	b1.appendCodePoint(c);
}

private void _apbb() {
	b1.append('\\');
}

@SuppressWarnings("unchecked")
private void _putmp(int c) {
	String t, z;
	Object o;

	if(c != ';') {
		ot.append(b1.toString());
	} else if((z = action.getConstName(t = b1.toString())) != null) {
		exeo = true;
		ot.append("return " + z);
	} else if(t.startsWith(STATELABEL)) {
		o = action.builder.getStateByLabel(t.substring(SL_LEN));
		ot.append(action.getStateNo((DFAState<Object, ?, Void>)o));
	} else {
		ot.append(t);
	}
	b1 = new StringBuffer();
}

public static String replace(String s, boolean[] a,
		AbstractNinaTranslator ac, int cn, String lb) {
	ReplaceAction c = new ReplaceAction();

	c.b1 = new StringBuffer();
	c.ot = new StringBuffer();
	c.action = ac;
	c.cn = cn;
	c.lb = lb;
	try {
		c.parse(new java.io.StringReader(s));
	} catch(java.io.IOException e) {
		throw new RuntimeException(e);
	}
	c.ot.append(c.b1);
	a[0] = c.exeo;
	return c.ot.toString();
}


	int _read1(java.io.Reader stream) throws java.io.IOException {
		int c;

		c = stream.read();
		return c < 0 ? -1 : c;
	}
	private int _read(java.io.Reader rd) throws java.io.IOException {
		int c;

		while(true) {
			if(unread >= 0) {
				c = unread;
				unread = -1;
				__logprint("Read unread: ", c);
			} else if(__lookahead_ptr >= 0) {
				if(__lookahead_ptr < __lookahead.length) {
					c = __lookahead[__lookahead_ptr++];
				} else {
					__lookahead = null;
					__lookahead_ptr = -1;
					c = _read(rd);
				}
				__logprint("Read Lookahead: ", c);
			} else if((c = _read1(rd)) != -1) {
				__logprint("Read: ", c);
			} else {
				__logprint("Read end-of-file");
			}
			return c;
		}
	}

	void UNGET(int c) {
		unread = c;
		__logprint("Set unread: ", c);
	}

	private void __logprint(String s, int c) {
	}

	private void __logopen() {
	}

	private void __logprint(String s) {
	}

	private void __logclose() {
	}

	private void __puttrace() {
	}

	void LOOKAHEAD(int c) {
		int[] a;

		if(__lookaheadw == null) {
			__lookahead_state = STATE;
			__lookaheadw = new int[72];
			__lookaheadw_ptr = 0;
			__lookaheadw[__lookaheadw_ptr++] = c;
		} else if(__lookaheadw_ptr < __lookaheadw.length) {
			__lookaheadw[__lookaheadw_ptr++] = c;
		} else {
			a = new int[__lookaheadw.length * 2];
			System.arraycopy(__lookaheadw, 0, a, 0,
					__lookaheadw.length);
			__lookaheadw = a;
			__lookaheadw[__lookaheadw_ptr++] = c;
		}
	}

	private void __copy_lookahead(int p) {
		int[] a;

		if(__lookahead == null) {
			a = new int[__lookaheadw_ptr];
		} else if(__lookaheadw_ptr < __lookahead.length) {
			a = __lookahead;
		} else {
			a = new int[__lookaheadw_ptr];
		}
		System.arraycopy(__lookaheadw, 0, a, 0, __lookaheadw_ptr);
		__lookahead = a;
		__lookahead_ptr = p;
		__lookaheadw = null;
		__lookaheadw_ptr = -1;
	}

	void LOOKAHEAD_COMMIT() {
		if(__lookahead_mark < 0) {
			__lookaheadw = null;
			__lookaheadw_ptr = -1;
		} else {
			__copy_lookahead(__lookahead_mark);
		}
		__lookahead_mark = -1;
		__logprint("Commit Lookahead");
	}

	void LOOKAHEAD_RB() {
		__copy_lookahead(0);
		STATE = __lookahead_state;
		__lookahead_ok = false;
		__lookahead_mark = -1;
		__logprint("Rollback Lookahead");
	}

	void LOOKAHEAD_MARK() {
		__lookahead_mark = __lookaheadw_ptr;
	}


	private int replaceAction_step(java.io.Reader __rd, int  $c)  throws java.io.IOException {
		boolean __l__ = __lookahead_ok;

		__lookahead_ok = true;
		switch(STATE) {
		case 0:
			if($c == '"') {
				STATE = 1;
				return 1;
			} else if($c == '$') {
				STATE = 2;
				return 1;
			} else if($c == '%') {
				STATE = 3;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 4;
				return 1;
			} else if(__l__ && $c == 'n') {
				LOOKAHEAD($c);
				STATE = 5;
				return 1;
			} else {
				STATE = 0;
				return 1;
			}
		case 5:
			if(__l__ && $c == 'i') {
				LOOKAHEAD($c);
				STATE = 6;
				return 1;
			}
			return 0;
		case 6:
			if(__l__ && $c == 'n') {
				LOOKAHEAD($c);
				STATE = 7;
				return 1;
			}
			return 0;
		case 7:
			if(__l__ && $c == 'a') {
				LOOKAHEAD($c);
				STATE = 8;
				return 1;
			}
			return 0;
		case 8:
			if(__l__ && $c == ':') {
				LOOKAHEAD($c);
				STATE = 9;
				return 1;
			}
			return 0;
		case 9:
			if(__l__ && $c == 'y') {
				LOOKAHEAD($c);
				STATE = 10;
				return 1;
			}
			return 0;
		case 10:
			if(__l__ && $c == 'i') {
				LOOKAHEAD($c);
				STATE = 11;
				return 1;
			}
			return 0;
		case 11:
			if(__l__ && $c == 'e') {
				LOOKAHEAD($c);
				STATE = 12;
				return 1;
			}
			return 0;
		case 12:
			if(__l__ && $c == 'l') {
				LOOKAHEAD($c);
				STATE = 13;
				return 1;
			}
			return 0;
		case 13:
			if($c == 'd') {
				LOOKAHEAD_COMMIT();
				STATE = 14;
				return 1;
			}
			return 0;
		case 14:
			if($c == ';') {
				STATE = 15;
				return 1;
			} else {
				STATE = 14;
				return 1;
			}
		case 15:
			return 0;
		case 4:
			if($c >= '0' && $c <= '9') {
				STATE = 4;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 4;
				return 1;
			} else if($c == '_') {
				STATE = 4;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 4;
				return 1;
			} else {
				STATE = 16;
				return 1;
			}
		case 16:
			return 0;
		case 3:
			if($c == '%') {
				STATE = 17;
				return 1;
			} else if($c >= '0' && $c <= '9') {
				STATE = 18;
				return 1;
			} else if($c == '=') {
				STATE = 19;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 18;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 18;
				return 1;
			} else if($c == '{') {
				STATE = 20;
				return 1;
			} else {
				UNGET($c);
				STATE = 21;
				return 1;
			}
		case 21:
			return 0;
		case 20:
			STATE = 22;
			return 1;
		case 22:
			if($c == '}') {
				STATE = 23;
				return 1;
			} else {
				STATE = 22;
				return 1;
			}
		case 23:
			return 0;
		case 19:
			if($c == '{') {
				STATE = 24;
				return 1;
			}
			return 0;
		case 24:
			if($c == '}') {
				STATE = 25;
				return 1;
			} else {
				STATE = 26;
				return 1;
			}
		case 26:
			if($c == '"') {
				STATE = 27;
				return 1;
			} else if($c == '\\') {
				STATE = 28;
				return 1;
			} else if($c == '}') {
				STATE = 25;
				return 1;
			} else {
				STATE = 26;
				return 1;
			}
		case 28:
			if($c == '"') {
				STATE = 26;
				return 1;
			} else if($c == '\\') {
				STATE = 26;
				return 1;
			} else {
				_apbb();
				STATE = 26;
				return 1;
			}
		case 27:
			if($c == '"') {
				STATE = 26;
				return 1;
			} else if($c == '\\') {
				STATE = 29;
				return 1;
			} else {
				STATE = 27;
				return 1;
			}
		case 29:
			if($c == '"') {
				STATE = 27;
				return 1;
			} else if($c == '\\') {
				STATE = 27;
				return 1;
			} else {
				_apbb();
				STATE = 27;
				return 1;
			}
		case 25:
			return 0;
		case 18:
			if($c >= '0' && $c <= '9') {
				STATE = 18;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 18;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 18;
				return 1;
			} else {
				UNGET($c);
				STATE = 23;
				return 1;
			}
		case 17:
			return 0;
		case 2:
			if($c == '$') {
				STATE = 30;
				return 1;
			} else if($c >= '0' && $c <= '9') {
				STATE = 31;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 31;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 31;
				return 1;
			} else if($c == '{') {
				STATE = 32;
				return 1;
			} else {
				UNGET($c);
				STATE = 33;
				return 1;
			}
		case 33:
			return 0;
		case 32:
			STATE = 34;
			return 1;
		case 34:
			if($c == '}') {
				STATE = 35;
				return 1;
			} else {
				STATE = 34;
				return 1;
			}
		case 35:
			return 0;
		case 31:
			if($c >= '0' && $c <= '9') {
				STATE = 31;
				return 1;
			} else if($c >= 'A' && $c <= 'Z') {
				STATE = 31;
				return 1;
			} else if($c >= 'a' && $c <= 'z') {
				STATE = 31;
				return 1;
			} else {
				UNGET($c);
				STATE = 35;
				return 1;
			}
		case 30:
			return 0;
		case 1:
			if($c == '"') {
				STATE = 0;
				return 1;
			} else {
				STATE = 1;
				return 1;
			}
		}
		return 0;
	}

	private boolean replaceAction_accepted() {
		return (STATE == 34 ||
				STATE == 0 ||
				STATE == 35 ||
				STATE == 1 ||
				STATE == 32 ||
				STATE == 2 ||
				STATE == 33 ||
				STATE == 3 ||
				STATE == 4 ||
				STATE == 15 ||
				STATE == 17 ||
				STATE == 16 ||
				STATE == 18 ||
				STATE == 21 ||
				STATE == 20 ||
				STATE == 23 ||
				STATE == 22 ||
				STATE == 25 ||
				STATE == 31 ||
				STATE == 30);
	}

	int replaceAction_execaction(int  $c) {
		switch(STATE) {
		case 0:
			_apc($c);               
_init();
			break;
		case 7:
			break;
		case 6:
			break;
		case 15:
			action.appendYield(ot, b1.substring(1));
b1 = new StringBuffer();                
STATE = INITIAL;  exeo = true;
			break;
		case 19:
			break;
		case 24:
			break;
		case 30:
			action.appendReturn(ot);
STATE = INITIAL;
			break;
		case 32:
			break;
		case 34:
			_apb($c);
			break;
		case 35:
			action.appendValue(ot, b1);
b1 = new StringBuffer();   
STATE = INITIAL;
			break;
		case 26:
			_apb($c);
			break;
		case 31:
			_apb($c);
			break;
		case 25:
			ot.append(action.executeMeta(b1.toString()));
STATE = INITIAL;
			break;
		case 9:
			break;
		case 3:
			break;
		case 33:
			ot.append('$'); 
STATE = INITIAL;
			break;
		case 28:
			break;
		case 29:
			break;
		case 10:
			break;
		case 14:
			_apb($c);
			break;
		case 23:
			action.appendLvalue(ot, b1);
b1 = new StringBuffer();    
STATE = INITIAL;
			break;
		case 4:
			{ _apb($c);    }
			break;
		case 8:
			break;
		case 12:
			break;
		case 1:
			{ _apc($c); }
			break;
		case 27:
			_apb($c);
			break;
		case 20:
			break;
		case 21:
			ot.append('%'); 
STATE = INITIAL;
			break;
		case 11:
			break;
		case 17:
			action.appendMyPosition(ot, lb, cn);
STATE = INITIAL;
			break;
		case 18:
			_apb($c);
			break;
		case 2:
			break;
		case 5:
			break;
		case 22:
			_apb($c);
			break;
		case 16:
			{ _putmp($c);       
  STATE = INITIAL;  
  UNGET($c);       }
			break;
		case 13:
			break;
		}
		return 1;
	}

	boolean replaceAction_isend() {
		return false;
	}

	private final Engine ENGINE_replaceAction = new Engine() {

		int step(java.io.Reader __rd, int c) throws java.io.IOException {
			return replaceAction_step(__rd, c);
		}

		boolean accepted() {
			return replaceAction_accepted();
		}

		int execaction(int c) {
			return replaceAction_execaction(c);
		}

		boolean isend() {
			return replaceAction_isend();
		}

		int recover(Exception e) {
			return -1;
		}

		int deadState() {
			return -1;
		}

		int stateSize() {
			return 36;
		}

		int finallyState() {
			return -1;
		}

		public String toString() {
			return "replaceAction";
		}

	};

	void __stkpush(int st, Engine en) {
		Object[][] c;
		Engine[] b;
		int[] a;

		if(__slen >= __sts.length) {
			a = new int[__sts.length * 2];
			b = new Engine[__stk.length * 2];
			c = new Object[__stk.length * 2][];
			System.arraycopy(__sts, 0, a, 0, __sts.length);
			System.arraycopy(__stk, 0, b, 0, __stk.length);
			System.arraycopy(__stv, 0, c, 0, __stv.length);
			__sts = a;
			__stk = b;
			__stv = c;
		}
		__sts[__slen] = st;
		__stk[__slen] = en;
		__stv[__slen++] = new Object[en.stateSize()];
	}

	private int _parse(java.io.Reader rd, int x, Boolean rt) throws java.io.IOException {
		boolean b = false;
		int c = x, a;
		Engine en;

		b = __stk[__slen - 1].accepted();
		if(rd == null) {
			throw new RuntimeException("can not recurse");
		} else if(rt.booleanValue()) {
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_ACCEPT:
				__logprint("accept " + __stk[__slen - 1]);
				return NINA_ACCEPT;
			case NINA_FAIL:
				__logprint("match failed: begin");
				__puttrace();
				return NINA_FAIL;
			case NINA_HALT_ACCEPT:
				__logprint("machine halted: begin");
				return NINA_HALT_ACCEPT;
			case NINA_HALT_REJECT:
				__logprint("machine halted: begin");
				return NINA_HALT_REJECT;
			case NINA_YIELD:
				__logprint("machine yielded: ", c);
				return NINA_YIELD;
			}
		}

		try {
			do {
				en = __stk[__slen - 1];
				if(c < 0) {
					// do nothing
				} else if((a = en.step(rd, c)) > 0) {
					__logprint("transit to state " + STATE + ": ", c);
					b = en.accepted();
					switch(en.execaction(c)) {
					case NINA_ACCEPT:
						__logprint("accept " + __stk[__slen - 1]);
						UNGET(c);
						return NINA_ACCEPT;
					case NINA_FAIL:
						__logprint("match failed: ", c);
						__puttrace();
						UNGET(c);
						return NINA_FAIL;
					case NINA_HALT_ACCEPT:
						__logprint("machine halted: ", c);
						return NINA_HALT_ACCEPT;
					case NINA_HALT_REJECT:
						__logprint("machine halted: ", c);
						return NINA_HALT_REJECT;
					case NINA_YIELD:
						__logprint("machine yielded: ", c);
						return NINA_YIELD;
					}
				} else if(a < 0) {
					__logprint("entering " + __stk[__slen - 1]);
					return c;
				} else if(b) {
					__logprint("accept " + __stk[__slen - 1]);
					UNGET(c);
					return NINA_ACCEPT;
				} else if(__lookaheadw_ptr >= 0) {
					__logprint("match failed: try lookahead: ", c);
					LOOKAHEAD(c);
					LOOKAHEAD_RB();
					b = en.accepted();
				} else {
					__logprint("match failed: ", c);
					__puttrace();
					UNGET(c);
					return NINA_FAIL;
				}
			} while((c = _read(rd)) >= 0);
			if(!b)  throw new TokenException();
			return NINA_ACCEPT;
		} catch(RuntimeException e) {
			UNGET(c);
			throw e;
		}
	}

	private Boolean execfinally() {
		int a, b;

		if((a = __stk[__slen - 1].finallyState()) >= 0) {
			b = STATE;  STATE = a;
			switch(__stk[__slen - 1].execaction(NINA_BEGIN)) {
			case NINA_HALT_ACCEPT:
				__slen = 0;
				return Boolean.TRUE;
			case NINA_HALT_REJECT:
				__slen = 0;
				return Boolean.FALSE;
			}
			STATE = b;
		}
		return null;
	}

	private int getdeadstate() {
		return __stk[__slen - 1].deadState();
	}

	private int getrecover(Exception e) {
		return __stk[__slen - 1].recover(e);
	}

	 boolean parse(java.io.Reader rd, Engine entry) throws java.io.IOException {
		int c = -1;
		Boolean b = Boolean.FALSE;

		__logopen();
		try {
			if(__slen == 0) {
				b = Boolean.TRUE;
				__stkpush(0, entry);
			}

			ot: while(true) {
				try {
					if((c = _parse(rd, c, b)) >= 0) {
						// do nothing
					} else if(c == NINA_FAIL) {
						while((STATE = getdeadstate()) < 0) {
							if((b = execfinally()) != null)  break ot;
							if(__slen-- <= 1) {
								throw new TokenException();
							}
						}
					} else if(c == NINA_HALT_ACCEPT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.TRUE;  break;
					} else if(c == NINA_HALT_REJECT) {
						if((b = execfinally()) != null)  break;
						__slen = 0;
						b = Boolean.FALSE;  break;
					} else if(c == NINA_YIELD) {
						return false;
					} else if(__slen > 1) {
						if((b = execfinally()) != null)  break;
						STATE = __sts[--__slen];
					} else {
						if((b = execfinally()) != null)  break;
						b = new Boolean(__stk[--__slen].accepted());
						break;
					}
				} catch(RuntimeException e) {
					exception = e;
					if(__slen <= 0)  throw e;
					while((STATE = getrecover(e)) < 0) {
						if((b = execfinally()) != null)  return b;
						if(__slen-- <= 1)  throw e;
					}
				}
				b = Boolean.TRUE;
			}
			if(!b.booleanValue())  throw new TokenException();
			return b.booleanValue();
		} finally {
			__logclose();
		}
	}

	 boolean parse(java.io.Reader rd) throws java.io.IOException {
		return parse(rd, ENGINE_replaceAction);
	}

	 static boolean parseAll(java.io.Reader rd) throws java.io.IOException {
		ReplaceAction o = new ReplaceAction();

		return o.parse(rd);
	}

	 void setStream(java.io.Reader rd) {
		if(befstream != null) {
			throw new IllegalStateException();
		}
		yieldObject = befstream = rd;
	}

	 Object parseNext() throws java.io.IOException {
		Object o;

		if(befstream == null) {
			throw new IllegalStateException();
		} else if(yieldObject == null) {
			return null;
		} else if(parse(befstream, ENGINE_replaceAction)) {
			if(yieldObject == null)  throw new NullPointerException();
			o = yieldObject;  yieldObject = null;
			return o;
		} else {
			if(yieldObject == null)  throw new NullPointerException();
			return yieldObject;
		}
	}

	 boolean parse(java.io.InputStream rd) throws java.io.IOException {
		return parse(new java.io.InputStreamReader(rd));
	}

	 static boolean parseAll(
			java.io.InputStream rd) throws java.io.IOException {
		return parseAll(new java.io.InputStreamReader(rd));
	}

}
