/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range.integer;

import java.util.Arrays;
import net.morilib.range.IntervalsInt;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.range.integer.IntInterval;
import net.morilib.range.integer.IntRange;
import net.morilib.range.integer.IntRangeAdder;

public class IntCharSets {
    public static final IntRange ALL_CHAR = new IntInterval(0, 65535);
    public static final IntRange ASCII_CONTROLSPACE = new IntInterval(10, 10).join(new IntInterval(9, 9));
    public static final IntRange ASCII_WHITESPACE = ASCII_CONTROLSPACE.join(new IntInterval(32, 32));
    public static final IntRange NOT_ASCII_WHITESPACE = ASCII_WHITESPACE.complement();
    public static final IntRange ASCII_WORD = new IntInterval(65, 90).join(new IntInterval(97, 122)).join(new IntInterval(48, 57)).join(new IntInterval(95, 95));
    public static final IntRange NOT_ASCII_WORD = ASCII_WORD.complement();
    public static final IntRange ASCII_NUMBERS = new IntInterval(48, 57);
    public static final IntRange NOT_ASCII_NUMBERS = ASCII_NUMBERS.complement();
    private static final int _CI_INIT = 0;
    private static final int _CI_ON = 1;

    public static Range toRange(IntRange r) {
        RangeAdder a = new RangeAdder();
        for (IntInterval v : r.intervals()) {
            a.add(IntervalsInt.newClosedInterval(v.left, v.right));
        }
        return a.toRange();
    }

    private static boolean _get(int[] a, int k) {
        int x = k / 32;
        int b = k % 32;
        return (a[x] & 1 << b) != 0;
    }

    private static void _set(int[] a, int k) {
        if (k >= 0 && k < 65536) {
            int x = k / 32;
            int b = k % 32;
            int n = x;
            a[n] = a[n] | 1 << b;
        }
    }

    public static IntRange toCaseInsensitive(IntRange r) {
        IntRangeAdder s = new IntRangeAdder();
        int[] a = new int[2048];
        int st = 0;
        int b = 0;
        Arrays.fill(a, 0);
        for (IntInterval v : r.intervals()) {
            b = v.right < 65536 ? v.right : 65536;
            int k = v.left < 0 ? 0 : v.left;
            while (k <= b) {
                IntCharSets._set(a, Character.toUpperCase(k));
                IntCharSets._set(a, Character.toLowerCase(k));
                ++k;
            }
        }
        int k = 0;
        while (k < 65536) {
            switch (st) {
                case 0: {
                    if (!IntCharSets._get(a, k)) break;
                    b = k;
                    st = 1;
                    break;
                }
                case 1: {
                    if (IntCharSets._get(a, k)) break;
                    s.addInterval(new IntInterval(b, k - 1));
                    st = 0;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            ++k;
        }
        if (st == 1) {
            s.addInterval(new IntInterval(b, 65535));
        }
        return s.toRange();
    }
}

