/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.StringWriter;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.automata.nfa.NFAAccept;
import net.morilib.automata.nfa.NFAAlternative;
import net.morilib.automata.nfa.NFAConcatenation;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.RegexParseException;
import net.morilib.automata.nfa.RegexpParser;
import net.morilib.automata.nfa.SingleObjectNFA;
import net.morilib.nina.DoubleQuoteTokenizer;
import net.morilib.nina.Nina;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.NinaException;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaNFA;
import net.morilib.nina.NinaParser;
import net.morilib.nina.NinaState;
import net.morilib.nina.NinaSubautomata;
import net.morilib.range.Range;

public class NFABuilder
implements NinaAction {
    private static final Pattern CHARX = Pattern.compile(".\\p{M}*", 32);
    private NinaState vertex;
    private NinaNFA nfa = new NinaNFA();
    private String label;
    private String name;

    @Override
    public void labelAdded(NinaEvent q, NinaFrameReader rd, boolean accept) {
        int l;
        StringWriter wr = new StringWriter();
        char[] a = new char[1024];
        while ((l = rd.read(a)) >= 0) {
            wr.write(a, 0, l);
        }
        if (this.vertex == null) {
            this.nfa.initial = this.vertex = new NinaState();
        }
        this.vertex.label = wr.toString();
        if (accept) {
            this.nfa.accept.put(this.vertex, null);
        }
    }

    @Override
    public void link(NinaEvent q, Object ver) {
        NinaState v = this.vertex;
        NinaState ninaState = this.vertex = ver != null ? (NinaState)ver : new NinaState();
        if (q.getEdge() instanceof NFA) {
            this.nfa.linkNFA(v, this.vertex, (NFA)q.getEdge());
        } else if (q.getEdge() instanceof Range) {
            this.nfa.linkAlphabet((NFAState)v, (NFAState)this.vertex, (Range)q.getEdge());
        } else {
            this.nfa.linkAlphabet((NFAState)v, (NFAState)this.vertex, q.getEdge());
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Object getVertex() {
        return this.vertex;
    }

    @Override
    public void setVertex(Object o) {
        this.vertex = (NinaState)o;
    }

    @Override
    public void doneBlockSearching(NinaEvent q) {
        this.vertex = (NinaState)q.getScratch();
    }

    @Override
    public void setEdge(NinaEvent q, Object o) {
        q.setEdge(o);
    }

    private NFAObject<Object, NFAState, Void> createQuoteNFA1(NinaEvent q, CharSequence s) {
        ArrayList l = new ArrayList();
        int k = 0;
        while (k < s.length()) {
            char x = s.charAt(k);
            Integer c = Nina.prendCharcode(q.getCharset(), x);
            SingleObjectNFA o = SingleObjectNFA.newInstance(c);
            l.add(o);
            ++k;
        }
        return NFAConcatenation.newInstance(l);
    }

    private NFAObject<Object, NFAState, Void> createQuoteNFA2(NinaEvent q, CharSequence s) {
        ArrayList l = new ArrayList();
        int k = 0;
        while (k < s.length()) {
            SingleObjectNFA o;
            Integer c;
            char x = s.charAt(k);
            char X = Character.toUpperCase(x);
            if ((x = Character.toLowerCase(x)) == X) {
                c = Nina.prendCharcode(q.getCharset(), x);
                o = SingleObjectNFA.newInstance(c);
                l.add(o);
            } else {
                c = Nina.prendCharcode(q.getCharset(), x);
                o = SingleObjectNFA.newInstance(c);
                c = Nina.prendCharcode(q.getCharset(), X);
                SingleObjectNFA p = SingleObjectNFA.newInstance(c);
                l.add(NFAAlternative.newInstance(o, p));
            }
            ++k;
        }
        return NFAConcatenation.newInstance(l);
    }

    private NFAObject<Object, NFAState, Void> createQuoteNFA(NinaEvent q, CharSequence s, int qf) {
        if (qf == 73) {
            NFAObject<Object, NFAState, Void> o = this.createQuoteNFA1(q, s.toString().toUpperCase());
            NFAObject<Object, NFAState, Void> p = this.createQuoteNFA1(q, s.toString().toLowerCase());
            return NFAAlternative.newInstance(o, p);
        }
        if (qf == 105) {
            return this.createQuoteNFA2(q, s);
        }
        if (qf == 110) {
            ArrayList l = new ArrayList();
            Matcher m = CHARX.matcher(s);
            while (m.find()) {
                String x = m.group();
                String nc = Normalizer.normalize(x, Normalizer.Form.NFC);
                String nd = Normalizer.normalize(x, Normalizer.Form.NFD);
                NFAObject<Object, NFAState, Void> o = this.createQuoteNFA1(q, nc);
                NFAObject<Object, NFAState, Void> p = this.createQuoteNFA1(q, nd);
                l.add(NFAAlternative.newInstance(o, p));
            }
            return NFAConcatenation.newInstance(l);
        }
        return this.createQuoteNFA1(q, s);
    }

    @Override
    public void setEdgeCharSequence(NinaEvent q, CharSequence s, int qc, int qf) {
        NFAObject<Object, NFAState, Void> o;
        if (qc == 34) {
            ArrayList l = new ArrayList();
            List<DoubleQuoteTokenizer.Elems> b = DoubleQuoteTokenizer.parse(s.toString());
            for (DoubleQuoteTokenizer.Elems p : b) {
                l.add(this.createQuoteNFA(q, p.getString(), qf));
            }
            o = NFAAlternative.newInstance(l);
        } else {
            o = this.createQuoteNFA(q, s, qf);
        }
        NFAState d = new NFAState(){};
        q.setEdge(NFAAccept.newInstance(o, d));
    }

    @Override
    public void setEdgeResource(NinaEvent q, NinaParser p, String s, Map<String, String> map, NinaSubautomata b) {
        Object n = p.compileSubautomaton(s, new NFABuilder(), map, b, null).getMachine();
        q.setEdge(n);
    }

    @Override
    public void setEdgeNFA(NinaEvent q, NFA<Object, NFAState, Integer> s, int f) {
        q.setEdge(s);
    }

    @Override
    public void setEdgeEnd(NinaEvent q) {
        throw new NinaException("endtransitionerror", "NFA");
    }

    @Override
    public NinaAction accept(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Object getMachine() {
        return this.nfa;
    }

    @Override
    public void setMealyEdge(int c) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setMealyEdge(Object o) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setPriority(int p) {
        if (this.vertex != null) {
            this.vertex.priority = p;
        }
    }

    @Override
    public NinaState createState(NinaEvent q) {
        return new NinaState();
    }

    @Override
    public void putStateByLabel(String l, Object s) {
    }

    @Override
    public Object getStateByLabel(String l) {
        return null;
    }

    @Override
    public String getLabelByState(Object s) {
        return null;
    }

    @Override
    public Object getDeadState() {
        return this.getStateByLabel("D");
    }

    @Override
    public void setStartState(Object o) {
        this.nfa.initial = this.vertex = (NinaState)o;
    }

    @Override
    public void setUserEdge(NinaEvent q, String o) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public Set<String> getLabels() {
        return Collections.emptySet();
    }

    @Override
    public void putTypeByLabel(String l, String s) {
    }

    @Override
    public String getTypeByLabel(String l) {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setEdgeSequence(NinaEvent q, Range r, int len) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setMealyEdgeType(int c) {
    }

    @Override
    public void setAccept(boolean accept) {
        if (accept) {
            this.nfa.accept.put(this.vertex, null);
        }
    }

    @Override
    public void setEdgeDynamic(NinaEvent q, String var) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public Map<String, String> getDynamicTransitMap() {
        return Collections.emptyMap();
    }

    @Override
    public void setEdgeGrammar(NinaEvent q, String name) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setEdgeRepeatedResource(NinaEvent q, String s, Object d) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public NinaAction empty(NinaEvent q, String name) {
        this.setStartState(this.createState(q));
        return this.accept(name);
    }

    private void _setRe(NinaEvent q, String re) {
        try {
            NFAState d = new NFAState(){};
            NFAObject s = RegexpParser.parse(re, d);
            this.setEdge(q, s);
        }
        catch (RegexParseException e) {
            throw new NinaException("invalidregex", new Object[0]);
        }
    }

    @Override
    public void setEdgeDigits(NinaEvent q, int digits, boolean sign) {
        StringBuilder b = new StringBuilder();
        if (sign) {
            b.append("[-+]?");
        }
        if (digits < 0) {
            b.append("[0-9]+");
        } else {
            b.append("[0-9]");
            int i = 1;
            while (i < digits) {
                b.append("[0-9]?");
                ++i;
            }
        }
        this._setRe(q, b.toString());
    }

    @Override
    public void setEdgeHexadecimal(NinaEvent q, int bits) {
        StringBuilder b = new StringBuilder();
        if (bits < 0) {
            b.append("[0-9A-Fa-f]+");
        } else {
            b.append("[0-9A-Fa-f]");
            int i = 8;
            while (i < bits) {
                b.append("[0-9A-Fa-f]?");
                ++i;
            }
        }
        this._setRe(q, b.toString());
    }

    @Override
    public void setEdgeOctal(NinaEvent q, int bits) {
        switch (bits) {
            case 8: {
                this._setRe(q, "([0-3][0-7]?|[4-7])[0-7]?");
                break;
            }
            case 16: {
                this._setRe(q, "([0-1][0-7]?|[2-7])[0-7]?[0-7]?[0-7]?[0-7]?");
                break;
            }
            case 32: {
                this._setRe(q, "([0-3][0-7]?|[4-7])[0-7]?[0-7]?[0-7]?[0-7]?[0-7]?[0-7]?[0-7]?[0-7]?[0-7]?");
                break;
            }
            default: {
                this._setRe(q, "[0-7]+");
            }
        }
    }

    @Override
    public void setEdgeFloat(NinaEvent q) {
        this._setRe(q, "[-+]?([0-9]+|[0-9]*.[0-9]+)([eE][-+]?[0-9]+)?");
    }

    @Override
    public void setEdgeIndent(NinaEvent q, String cmp, int off) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setEdgeIdentifier(NinaEvent q, String lang) {
        if (lang.equals("Java")) {
            this._setRe(q, "[A-Za-z_$\\u0080-\\ufffc][A-Za-z0-9_$\\u0080-\\ufffc]*");
        } else {
            this._setRe(q, "[A-Za-z_][A-Za-z0-9_]*");
        }
    }

    @Override
    public void setEdgeSkipSpaces(NinaEvent q, String str) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setEdgeBackslash(NinaEvent q, int c) {
        switch (c) {
            case 88: {
                this._setRe(q, "[\\P{M}][\\p{M}]*");
                break;
            }
            case 66: 
            case 98: {
                throw new NinaException("isnotdfa", new Object[0]);
            }
            default: {
                throw new NinaException("invalidsequence", new Object[0]);
            }
        }
    }

    @Override
    public void setEdgeStringSequence(NinaEvent q, int l, String cs) {
        if (l < 0) {
            this._setRe(q, "[" + cs + "]*");
        } else {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < l) {
                b.append("[").append(cs).append("]");
                ++i;
            }
            this._setRe(q, b.toString());
        }
    }

    @Override
    public void setEdgeFormatInteger(NinaEvent q, int l, String flg) {
        this.setEdgeStringSequence(q, l, "0-9");
    }

    @Override
    public void setEdgeFormatHex(NinaEvent q, int l, String flg) {
        this.setEdgeStringSequence(q, l, "0-9A-Fa-f");
    }

    @Override
    public void setEdgeFormatOct(NinaEvent q, int l, String flg) {
        this.setEdgeStringSequence(q, l, "0-7");
    }
}

