/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.subr;

import java.math.BigInteger;
import java.util.Iterator;
import net.morilib.lisp.nano.ConsIterator;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.LispCharacter;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispNumber;
import net.morilib.lisp.nano.LispSmallInt;
import net.morilib.lisp.nano.LispString;
import net.morilib.lisp.nano.util.Iterators;

public final class SubrUtils {
    private SubrUtils() {
    }

    public static BigInteger ceil(BigInteger n, BigInteger d) {
        BigInteger v = n;
        if (v.compareTo(BigInteger.ZERO) > 0) {
            v = v.add(d);
        }
        return v.divide(d);
    }

    public static BigInteger floor(BigInteger n, BigInteger d) {
        BigInteger v = n;
        if (v.compareTo(BigInteger.ZERO) < 0) {
            v = v.subtract(d);
        }
        return v.divide(d);
    }

    public static int getSmallInt(Datum d, LispMessage mesg) {
        if (d instanceof LispSmallInt) {
            LispSmallInt li = (LispSmallInt)d;
            return li.getExactSmallInt();
        }
        throw mesg.getError("err.require.smallint", d);
    }

    public static int getNonnegativeSmallInt(Datum d, LispMessage mesg) {
        if (d instanceof LispSmallInt) {
            LispSmallInt li = (LispSmallInt)d;
            int k = li.getExactSmallInt();
            if (k < 0) {
                throw mesg.getError("err.require.int.nonnegative", d);
            }
            return k;
        }
        throw mesg.getError("err.require.int.nonnegative", d);
    }

    public static char getCharacter(Datum d, LispMessage mesg) {
        if (d instanceof LispCharacter) {
            return ((LispCharacter)d).getCharacter();
        }
        throw mesg.getError("err.require.char", d);
    }

    public static int getCharacterCodePoint(Datum d, LispMessage mesg) {
        if (d instanceof LispCharacter) {
            return ((LispCharacter)d).getCharacterCodePoint();
        }
        throw mesg.getError("err.require.char", d);
    }

    public static String getString(Datum d, LispMessage mesg) {
        if (d instanceof LispString) {
            return ((LispString)d).getString();
        }
        throw mesg.getError("err.require.string", d);
    }

    public static int getU8(Datum d, LispMessage mesg) {
        int c = SubrUtils.getSmallInt(d, mesg);
        if (c < 0 || c > 255) {
            throw mesg.getError("err.uvector.outofrange.u8", d);
        }
        return c;
    }

    public static void checkTerminated(ConsIterator itr, Datum body, LispMessage mesg) {
        if (itr.hasNext()) {
            throw mesg.getError("err.argument", body);
        }
        if (!itr.getTerminal().isNil()) {
            throw mesg.getError("err.list", body);
        }
    }

    public static Datum nextIf(Iterator<Datum> itr, LispMessage mesg, Datum body) {
        return Iterators.nextIf(itr, mesg.getError("err.argument", body));
    }

    public static LispNumber getNumber(Datum x, LispMessage mesg) {
        if (x instanceof LispNumber) {
            return (LispNumber)x;
        }
        throw mesg.getError("err.require.number", x);
    }

    public static int toFoldCase(int ch) {
        if (ch == 304 || ch == 305) {
            return ch;
        }
        return Character.toLowerCase(Character.toUpperCase(ch));
    }
}

