/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.io;

import java.io.IOException;
import net.morilib.awk.nano.AwkCastException;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkString;
import net.morilib.awk.nano.value.AwkValue;

public class AwkClose
extends AwkExpression {
    private AwkExpression file;

    public AwkClose(AwkExpression file) {
        this.file = file;
    }

    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        try {
            AwkValue v = this.file.eval(ns, o);
            if (!v.isString()) {
                throw new AwkCastException("string required");
            }
            o.close(v.toString(ns));
            return AwkValue.TRUE;
        }
        catch (IOException e) {
            ns.getRoot().assign("ERRNO", AwkString.valueOf(e.getMessage()));
            return AwkValue.FALSE;
        }
    }
}

