/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.range.integer;

import net.morilib.range.IntervalsInt;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/10/09
 */
public class IntCharSets {

	/**
	 * 
	 */
	public static final IntRange ALL_CHAR =
		new IntInterval(0, Character.MAX_VALUE);

	/**
	 * 
	 */
	public static final IntRange ASCII_CONTROLSPACE =
			new IntInterval('\n', '\n').
			join(new IntInterval('\t', '\t'));

	/**
	 * 
	 */
	public static final IntRange ASCII_WHITESPACE =
			ASCII_CONTROLSPACE.join(new IntInterval(' ', ' '));

	/**
	 * 
	 */
	public static final IntRange NOT_ASCII_WHITESPACE =
			ASCII_WHITESPACE.complement();

	/**
	 * 
	 */
	public static final IntRange ASCII_WORD =
			new IntInterval('A', 'Z').
			join(new IntInterval('a', 'z')).
			join(new IntInterval('0', '9')).
			join(new IntInterval('_', '_'));

	/**
	 * 
	 */
	public static final IntRange NOT_ASCII_WORD =
			ASCII_WORD.complement();

	/**
	 * The character set of the numbers by ASCII characters.
	 */
	public static final IntRange ASCII_NUMBERS =
			new IntInterval('0', '9');

	/**
	 * 
	 */
	public static final IntRange NOT_ASCII_NUMBERS =
			ASCII_NUMBERS.complement();

	/**
	 * 
	 * @param r
	 * @return
	 */
	public static Range toRange(IntRange r) {
		RangeAdder a = new RangeAdder();

		for(IntInterval v : r.intervals()) {
			a.add(IntervalsInt.newClosedInterval(v.left, v.right));
		}
		return a.toRange();
	}

}
