/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.pattern;

import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;

/**
 * パターン中間表現をあらわすインターフェースです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public interface AwkPattern {

	/**
	 * BEGINパターンのときtrueを得ます。
	 */
	public boolean isBegin();

	/**
	 * ENDパターンのときtrueを得ます。
	 */
	public boolean isEnd();

	/**
	 * 行にマッチした結果を返します。
	 * 
	 * @param ns   名前空間
	 * @param f    ファイル管理クラス
	 * @param s    行の文字列
	 * @param stat 前の状態
	 * @return
	 */
	public AwkMatchState match(AwkNamespace ns, AwkFiles f, String s,
			AwkMatchState stat);

	/**
	 * パターンが範囲指定されているときtrueを得ます。
	 */
	public boolean isRanged();

}
