/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.parser;

/**
 * 予約語ののトークンです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03/09
 */
public class AwkReserved extends AwkToken {

	/**
	 * ブロックの開始です。
	 */
	public static final AwkToken BLOCK_B = new AwkReserved("{");

	/**
	 * ブロックの終了です。
	 */
	public static final AwkToken BLOCK_E = new AwkReserved("}");

	/**
	 * セミコロンです。
	 */
	public static final AwkToken SEMICL = new AwkReserved(";");

	/**
	 * 追加の出力リダイレクトです。
	 */
	public static final AwkToken APNDOUT = new AwkReserved(">>");

	/**
	 * パイプです。
	 */
	public static final AwkToken PIPE  = new AwkReserved("|");

	/**
	 * if文です。
	 */
	public static final AwkToken IF = new AwkReserved("if");

	/**
	 * else文です。
	 */
	public static final AwkToken ELSE = new AwkReserved("else");

	/**
	 * for文です。
	 */
	public static final AwkToken FOR = new AwkReserved("for");

	/**
	 * while文です。
	 */
	public static final AwkToken WHILE = new AwkReserved("while");

	/**
	 * do文です。
	 */
	public static final AwkToken DO = new AwkReserved("do");

	/**
	 * break文です。
	 */
	public static final AwkToken BREAK = new AwkReserved("break");

	/**
	 * continue文です。
	 */
	public static final AwkToken CONT = new AwkReserved("continue");

	/**
	 * next文です。
	 */
	public static final AwkToken NEXT = new AwkReserved("next");

	/**
	 * exit文です。
	 */
	public static final AwkToken EXIT = new AwkReserved("exit");

	/**
	 * return文です。
	 */
	public static final AwkToken RETURN = new AwkReserved("return");

	/**
	 * delete文です。
	 */
	public static final AwkToken DELETE = new AwkReserved("delete");

	/**
	 * function文です。
	 */
	public static final AwkToken FUNC = new AwkReserved("function");

	/**
	 * getline文です。
	 */
	public static final AwkToken GETLINE = new AwkReserved("getline");

	/**
	 * print文です。
	 */
	public static final AwkToken PRINT = new AwkReserved("print");

	/**
	 * printf文です。
	 */
	public static final AwkToken PRINTF = new AwkReserved("printf");

	/**
	 * close文です。
	 */
	public static final AwkToken CLOSE = new AwkReserved("close");

	/**
	 * 行の終わりです。
	 */
	public static final AwkToken EOL = new AwkReserved("<eol>");

	/**
	 * ファイルの終わりです。
	 */
	public static final AwkToken ENDMARKER = new AwkReserved("<eof>");

	AwkReserved(String desc) {
		super(desc);
	}

}
