/*
 * Copyright 2013-2014 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NinaSubautomata {

	//
	static final String MAIN = "main";

	//
	private Map<String, Object> subs = new HashMap<String, Object>();
	private String mainname;

	/**
	 * 
	 * @param n
	 * @param main
	 */
	public NinaSubautomata(String n) {
		mainname = n;
	}

	/**
	 * 
	 * @return
	 */
	public String getMainname() {
		return mainname;
	}

	/**
	 * 
	 * @param n
	 * @return
	 */
	public boolean containsKey(String n) {
		if(MAIN.equals(n)) {
			return subs.containsKey(mainname);
		} else {
			return subs.containsKey(n);
		}
	}

	/**
	 * 
	 * @param n
	 * @return
	 */
	public Object get(String n) {
		if(MAIN.equals(n)) {
			return subs.get(mainname);
		} else {
			return subs.get(n);
		}
	}

	/**
	 * 
	 * @param n
	 * @param o
	 * @return
	 */
	public Object put(String n, Object o) {
		if(MAIN.equals(n)) {
			return subs.put(mainname, o);
		} else {
			return subs.put(n, o);
		}
	}

	/**
	 * 
	 * @return
	 */
	public Set<Map.Entry<String, Object>> entrySet() {
		return subs.entrySet();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return subs.toString();
	}

}
