/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.automata.lr;

/**
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2006/07/08
 */
public final class LRAction {

	/**
	 * 
	 */
	public static final int SHIFT  = 1;

	/**
	 * 
	 */
	public static final int REDUCE = 2;

	/**
	 * 
	 */
	public static final int ACCEPT = 3;

	//
	private int action;
	private int nextStateID;
	private Terminal symbol;
	private ContextFreeRule reduceRule;

	//
	private LRAction() {
		// do nothing
	}

	/**
	 * 
	 * @param id
	 */
	protected static LRAction newShift(Terminal t, int id) {
		LRAction res = new LRAction();

		res.symbol = t;
		res.action = SHIFT;
		res.nextStateID = id;
		return res;
	}

	/**
	 * 
	 * @param rule
	 */
	protected static LRAction newReduce(Terminal t,
			ContextFreeRule rule) {
		LRAction res = new LRAction();

		res.symbol = t;
		res.action = REDUCE;
		res.reduceRule = rule;
		return res;
	}

	/**
	 * 
	 * @param id
	 */
	protected static LRAction newAccept() {
		LRAction res = new LRAction();

		res.action = ACCEPT;
		return res;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isShift() {
		return action == SHIFT;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isReduce() {
		return action == REDUCE;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isAccept() {
		return action == ACCEPT;
	}

	/**
	 * 
	 * @return
	 */
	public int getAction() {
		return action;
	}

	/**
	 * 
	 * @return
	 */
	public int getNextStateID() {
		return nextStateID;
	}

	/**
	 * 
	 * @return
	 */
	public ContextFreeRule getReduceRule() {
		return reduceRule;
	}

	/**
	 * 
	 * @return
	 */
	public Terminal getSymbol() {
		return symbol;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();

		if(action == SHIFT) {
			buf.append("shift: ").append(nextStateID);
		} else if(action == REDUCE) {
			buf.append("reduce: ").append(reduceRule);
		} else if(action == ACCEPT) {
			buf.append("accept");
		}
		return buf.toString();
	}

}