/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2009
 */
public class SynLetrec extends Syntax {

	/*package*/ void compile(
			Datum body,
			Environment env,
			LispCompiler comp,
			CompiledCode.Builder build,
			boolean toplevel,
			Cons callsym,
			boolean istail,
			LispMessage mesg,
			List<Cons> symlist,
			CodeExecutor exec,
			IntStack memento) {
		if(body instanceof Cons) {
			CompiledCode.Builder nbuild = new CompiledCode.Builder();
			Datum bcar = ((Cons)body).getCar();
			Datum bcdr = ((Cons)body).getCdr();

			// マクロ用の環境を生成する
			Environment nenv = new Environment(env);

			// ローカル変数の定義
			if(bcar instanceof Cons) {
				Datum d = bcar;
				while(d != Nil.NIL) {
					if(d instanceof Cons) {
						Datum d2 = ((Cons)d).getCar();

						if(d2 instanceof Cons) {
							Cons  d3  = (Cons)d2;
							Datum d3c = d3.getCar();
							/*Cons  l0 = IntLispUtils.extractLambda(
									d3.getCdr(),
									d3.getCar());
							Datum lt = IntLispUtils.extractLambdaList(
									d3.getCdr());*/

							if(!(d3c instanceof SymbolName)) {
								throw mesg.getError(
										"err.letrec.malform");
							}

							SyntaxUtils.compileBind(
									d3c,
									d3.getCdr(),
									env,
									comp,
									nbuild,
									new Cons(),
									false,
									mesg,
									"err.letrec.malform",
									new ArrayList<Cons>(),
									exec, memento);
							nbuild.addPop();

							// undefine defined syntax
							nenv.bindDatumWithoutScope(
									d3c, Undef.UNDEF);
						} else {
							//throw new LispException("malformed letrec");
							throw mesg.getError("err.letrec.malform");
						}
						d = ((Cons)d).getCdr();
					} else {
						//throw new LispException("malformed letrec");
						throw mesg.getError("err.letrec.malform");
					}
				}
			} else if(bcar != Nil.NIL) {
				//throw new LispException("malformed letrec");
				throw mesg.getError("err.letrec.malform");
			}

			// リストをコンパイルする
			symlist.add(callsym);
			SyntaxUtils.compileList(bcdr, nenv, comp, nbuild,
					new Cons(), istail, mesg, symlist,
					exec, memento);
			symlist.remove(0);
			nbuild.addReturnOp();

			// 一時的なClosureを生成する
			ClosureClass cl = new ClosureClass(
					Nil.NIL, nbuild.getCodeRef());

			// 一時的なClosureを呼び出す
			build.addPush(cl);
			build.addBeginList();
			build.addEndList();
			build.addCall();
		} else {
			//throw new LispException("malformed letrec");
			throw mesg.getError("err.letrec.malform");
		}
	}

}
