/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.printf;

import java.io.IOException;
import java.io.Writer;

import net.morilib.awk.nano.value.AwkValue;

/**
 * %eのアクションです。
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2013/05/11
 */
public class PrintfActionE implements PrintfAction {

	public void action(Writer b, int flags, int width, int precision,
			Object arg) throws IOException {
		String f, s;
		int g;

		g = flags & ((flags & Printf.LEFT) != 0 ? ~Printf.ZERO : -1);
		f = Printf.formatToString(g, 1, precision);
		s = String.format(f + "e", ((AwkValue)arg).toFloat());
		Printf.indentNumber(b, s, flags, width);
	}

}
