/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import net.morilib.range.CharSetException;
import net.morilib.range.Interval;
import net.morilib.range.IntervalsInt;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.range.Ranges;
import net.morilib.unicode.UnicodeUtils;
import net.morilib.util.CharCodes;

public final class CharSets {
    public static final Range ALL_CHAR = IntervalsInt.newClosedInterval(0, Integer.MAX_VALUE);
    public static final Range DOT = CharSets.complement(Interval.newPoint(10));
    public static final Range NUMBERS = CharSets.newCharInterval('0', '9');
    public static final Range NOT_NUMBER = CharSets.complement(NUMBERS);
    public static final Range ASCII_CONTROLSPACE = CharSets.newCharInterval('\t', '\r');
    public static final Range ASCII_WHITESPACE = ASCII_CONTROLSPACE.join(Interval.newPoint(32));
    public static final Range NOT_ASCII_WHITESPACE = CharSets.complement(ASCII_WHITESPACE);
    public static final Range ASCII_WORD = CharSets.parse("a-zA-Z_0-9");
    public static final Range NOT_ASCII_WORD = CharSets.parse("^a-zA-Z_0-9");
    public static final Range ASCII_NUMBERS = CharSets.newCharInterval('0', '9');
    public static final Range NOT_ASCII_NUMBERS = CharSets.complement(ASCII_NUMBERS);
    public static final Range CAPITAL_LETTERS = CharSets.newCharInterval('A', 'Z');
    public static final Range SMALL_LETTERS = CharSets.newCharInterval('a', 'z');
    public static final Range ENGLISH_ALPHABETS = Ranges.sum(CAPITAL_LETTERS, SMALL_LETTERS);
    public static final Range ENGLISH_ALPHABETS_NUMBERS = Ranges.sum(ENGLISH_ALPHABETS, ASCII_NUMBERS);
    public static final Range HIRAGANA = CharSets.newCharInterval('\u3041', '\u3094');
    public static final Range KATAKANA = CharSets.newCharInterval('\u30a1', '\u30fa');
    public static final Range SPACES = Ranges.sum(IntervalsInt.newPoint(32), IntervalsInt.newPoint(9));
    public static final Range TOKEN = Ranges.sum(IntervalsInt.newPoint(32), IntervalsInt.newPoint(9));
    private static final String DEFCD = "UTF-8";

    private CharSets() {
    }

    public static final Range newCharInterval(char f, char t) {
        return IntervalsInt.newClosedInterval(f, t);
    }

    public static final Range newCharInterval(char c) {
        return IntervalsInt.newClosedInterval(c, c);
    }

    private static Interval getintv(int ch, int ch2) {
        return IntervalsInt.newClosedInterval(ch, ch2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parse(CharSequence s, int start, String cset, CharSetHandler h) {
        int cb = -1;
        int pt = start;
        int st = 1;
        int pc = 0;
        StringBuilder b = new StringBuilder();
        block28: while (pt < s.length()) {
            int c;
            try {
                c = s.charAt(pt++);
                c = CharCodes.unicodeToOtherCode((char)c, cset);
            }
            catch (UnsupportedEncodingException e1) {
                throw new CharSetException();
            }
            if (st == 1) {
                if (c == 92) {
                    st = 2;
                    continue;
                }
                cb = c;
                st = 4;
                continue;
            }
            if (st == 2) {
                switch (c) {
                    case 117: 
                    case 120: {
                        st = 3;
                        break;
                    }
                    case 92: {
                        cb = c;
                        st = 4;
                        break;
                    }
                    case 116: {
                        cb = 9;
                        st = 4;
                        break;
                    }
                    case 110: {
                        cb = 10;
                        st = 4;
                        break;
                    }
                    case 114: {
                        cb = 13;
                        st = 4;
                        break;
                    }
                    case 102: {
                        cb = 12;
                        st = 4;
                        break;
                    }
                    case 100: {
                        h.addRange(NUMBERS);
                        st = 1;
                        break;
                    }
                    case 68: {
                        h.addRange(NOT_NUMBER);
                        st = 1;
                        break;
                    }
                    case 115: {
                        h.addRange(ASCII_WHITESPACE);
                        st = 1;
                        break;
                    }
                    case 83: {
                        h.addRange(NOT_ASCII_WHITESPACE);
                        st = 1;
                        break;
                    }
                    case 119: {
                        h.addRange(ASCII_WORD);
                        st = 1;
                        break;
                    }
                    case 87: {
                        h.addRange(NOT_ASCII_WORD);
                        st = 1;
                        break;
                    }
                    case 80: 
                    case 112: {
                        pc = c;
                        st = 8;
                        break;
                    }
                    default: {
                        cb = c;
                        st = 4;
                        break;
                    }
                }
                continue;
            }
            if (st == 3) {
                if (pt + 2 >= s.length()) {
                    throw new CharSetException();
                }
                b.append((char)c);
                b.append(s.charAt(pt));
                b.append(s.charAt(++pt));
                b.append(s.charAt(++pt));
                ++pt;
                try {
                    cb = Integer.parseInt(b.toString(), 16);
                    b.delete(0, b.length());
                    st = 4;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Illegal code");
                }
            }
            if (st == 4) {
                if (c == 92) {
                    h.singleChar(cb);
                    st = 2;
                    continue;
                }
                if (c == 45) {
                    st = 5;
                    continue;
                }
                h.singleChar(cb);
                cb = c;
                st = 4;
                continue;
            }
            if (st == 5) {
                if (c == 92) {
                    st = 6;
                    continue;
                }
                if (c < cb) {
                    throw new CharSetException();
                }
                h.rangedChar(cb, c);
                st = 1;
                continue;
            }
            if (st == 6) {
                switch (c) {
                    case 117: 
                    case 120: {
                        st = 7;
                        continue block28;
                    }
                    case 92: {
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                    }
                }
                if (c < cb) {
                    throw new CharSetException(String.valueOf(cb) + ">" + c);
                }
                h.rangedChar(cb, c);
                st = 1;
                continue;
            }
            if (st == 7) {
                if (pt + 2 >= s.length()) {
                    throw new CharSetException();
                }
                b.append((char)c);
                b.append(s.charAt(pt));
                b.append(s.charAt(++pt));
                b.append(s.charAt(++pt));
                ++pt;
                try {
                    int cz = Integer.parseInt(b.toString(), 16);
                    if (cz < cb) {
                        throw new CharSetException();
                    }
                    h.rangedChar(cb, cz);
                    b.delete(0, b.length());
                    st = 1;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Illegal code");
                }
            }
            if (st == 8) {
                if (c == 123) {
                    st = 9;
                    continue;
                }
                if (c == 92) {
                    st = 2;
                    continue;
                }
                cb = c;
                st = 4;
                continue;
            }
            if (st != 9) continue;
            if (c != 125) {
                b.append((char)c);
                continue;
            }
            Range r = UnicodeUtils.getPropertyRange(b.toString());
            if (r == null) {
                throw new RuntimeException("Illagal group:" + b.toString());
            }
            if (pc == 80) {
                r = CharSets.complement(r);
            }
            h.addRange(r);
        }
        if (st == 4) {
            h.singleChar(cb);
        }
    }

    public static void parse(CharSequence s, int start, CharSetHandler h) {
        CharSets.parse(s, start, DEFCD, h);
    }

    public static List<Interval> complement(Iterable<Interval> ra) {
        ArrayList<Interval> rb = new ArrayList<Interval>();
        int l = 0;
        for (Interval v : ra) {
            int m = (Integer)v.getInfimumBound();
            if (l <= m - 1) {
                rb.add(IntervalsInt.newClosedInterval(l, m - 1));
            }
            l = (Integer)v.getSupremumBound() + 1;
        }
        if (l < 0x7FFFFFFE) {
            rb.add(IntervalsInt.newClosedInterval(l, Integer.MAX_VALUE));
        }
        return rb;
    }

    public static Range complement(Range ra) {
        RangeAdder rb = new RangeAdder();
        for (Interval v : CharSets.complement(ra.intervals())) {
            rb.addInterval(v);
        }
        return rb.toRange();
    }

    public static Range parse(CharSequence s, String cset) {
        final RangeAdder ra = new RangeAdder();
        int k = 0;
        if (s.length() == 0) {
            throw new CharSetException();
        }
        boolean c = s.charAt(0) == '^';
        if (c) {
            ++k;
        }
        CharSets.parse(s, k, cset, new CharSetHandler(){

            @Override
            public void singleChar(int ch) {
                ra.add(CharSets.getintv(ch, ch));
            }

            @Override
            public void rangedChar(int cb, int ce) {
                ra.add(CharSets.getintv(cb, ce));
            }

            @Override
            public void addRange(Range r) {
                ra.add(r);
            }
        });
        return c ? CharSets.complement(ra.toRange()) : ra.toRange();
    }

    public static Range parse(CharSequence s) {
        return CharSets.parse(s, DEFCD);
    }

    private static List<Interval> parseTr(CharSequence s, String cset) {
        final ArrayList<Interval> ra = new ArrayList<Interval>();
        int k = 0;
        if (s.length() == 0) {
            throw new CharSetException();
        }
        boolean c = s.charAt(0) == '^';
        if (c) {
            ++k;
        }
        CharSets.parse(s, k, cset, new CharSetHandler(){

            @Override
            public void singleChar(int ch) {
                ra.add(CharSets.getintv(ch, ch));
            }

            @Override
            public void rangedChar(int cb, int ce) {
                ra.add(CharSets.getintv(cb, ce));
            }

            @Override
            public void addRange(Range r) {
                RangeAdder b = new RangeAdder();
                for (Interval v : ra) {
                    b.addInterval(v);
                }
                b.add(r);
                ra.clear();
                for (Interval v : b.toRange().intervals()) {
                    ra.add(v);
                }
            }
        });
        return c ? CharSets.complement(ra) : ra;
    }

    private static int card(Interval r1) {
        return (int)IntervalsInt.cardinality(r1);
    }

    private static int card(List<Interval> r1) {
        int r = 0;
        int i = 0;
        while (i < r1.size()) {
            r += (int)IntervalsInt.cardinality(r1.get(i));
            ++i;
        }
        return r;
    }

    public static String tr(CharSequence s, CharSequence t1, CharSequence t2, String cset) {
        StringBuilder b = new StringBuilder();
        List<Interval> r1 = CharSets.parseTr(t1, cset);
        List<Interval> r2 = CharSets.parseTr(t2, cset);
        if (CharSets.card(r1) != CharSets.card(r2)) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < s.length()) {
            block6: {
                int ind = 0;
                char c = s.charAt(i);
                int j = 0;
                while (j < r1.size()) {
                    Interval i1 = r1.get(j);
                    if (i1.contains(c)) {
                        int in2 = 0;
                        int c1 = (int)IntervalsInt.indexOf(i1, c);
                        int k = 0;
                        while (k < r2.size()) {
                            int cd2 = CharSets.card(r2.get(k));
                            if (ind + c1 < in2 + cd2) {
                                b.append((char)IntervalsInt.intAt(r2.get(k), c1));
                                break block6;
                            }
                            in2 += cd2;
                            ++k;
                        }
                        throw new RuntimeException();
                    }
                    ind += CharSets.card(i1);
                    ++j;
                }
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    public static String tr(CharSequence s, CharSequence t1, CharSequence t2) {
        return CharSets.tr(s, t1, t2, DEFCD);
    }

    public static List<Range> parseSequence(CharSequence s, int start) {
        StringBuilder b = new StringBuilder();
        int pt = start;
        int st = 1;
        int pc = 0;
        ArrayList<Range> l = new ArrayList<Range>();
        while (pt < s.length()) {
            int c = s.charAt(pt++);
            if (st == 1) {
                if (c == 92) {
                    st = 2;
                    continue;
                }
                l.add(Interval.newPoint(c));
                continue;
            }
            if (st == 2) {
                switch (c) {
                    case 117: 
                    case 120: {
                        st = 3;
                        break;
                    }
                    case 92: {
                        l.add(Interval.newPoint(c));
                        st = 1;
                        break;
                    }
                    case 100: {
                        l.add(NUMBERS);
                        st = 1;
                        break;
                    }
                    case 68: {
                        l.add(NOT_NUMBER);
                        st = 1;
                        break;
                    }
                    case 115: {
                        l.add(ASCII_WHITESPACE);
                        st = 1;
                        break;
                    }
                    case 83: {
                        l.add(NOT_ASCII_WHITESPACE);
                        st = 1;
                        break;
                    }
                    case 119: {
                        l.add(ASCII_WORD);
                        st = 1;
                        break;
                    }
                    case 87: {
                        l.add(NOT_ASCII_WORD);
                        st = 1;
                        break;
                    }
                    case 80: 
                    case 112: {
                        pc = c;
                        st = 8;
                        break;
                    }
                    default: {
                        l.add(Interval.newPoint(c));
                        st = 1;
                        break;
                    }
                }
                continue;
            }
            if (st == 3) {
                if (pt + 2 >= s.length()) {
                    throw new CharSetException();
                }
                b.append((char)c);
                b.append(s.charAt(pt));
                b.append(s.charAt(++pt));
                b.append(s.charAt(++pt));
                ++pt;
                try {
                    c = Integer.parseInt(b.toString(), 16);
                    b.delete(0, b.length());
                    l.add(Interval.newPoint(c));
                    st = 1;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Illegal code");
                }
            }
            if (st == 8) {
                if (c == 123) {
                    st = 9;
                    continue;
                }
                if (c == 92) {
                    st = 2;
                    continue;
                }
                l.add(Interval.newPoint(c));
                st = 1;
                continue;
            }
            if (st != 9) continue;
            if (c != 125) {
                b.append((char)c);
                continue;
            }
            Range r = UnicodeUtils.getPropertyRange(b.toString());
            if (r == null) {
                throw new RuntimeException("Illagal group:" + b.toString());
            }
            if (pc == 80) {
                r = CharSets.complement(r);
            }
            l.add(r);
        }
        return l;
    }

    public static interface CharSetHandler {
        public void singleChar(int var1);

        public void rangedChar(int var1, int var2);

        public void addRange(Range var1);
    }
}

