/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.example;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;

import net.morilib.nina.Nina;
import net.morilib.nina.NinaConsoleStub;
import net.morilib.nina.NinaPattern;
import net.morilib.nina.NinaSubautomata;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/18
 */
public class ZZTest0003 {

	public static void main(String[] args) {
		InputStream ins = null;
		NinaPattern m;
		Reader rd;

		try {
			ins = new FileInputStream("/home/user/work/example02.nina");
			rd  = new InputStreamReader(ins);
			m = Nina.pattern("example02", rd,
					Collections.<String, String>emptyMap(),
					new NinaSubautomata("a"),
					new NinaConsoleStub());
			System.out.println(m.matcher("aba").matches());
			System.out.println(m.matcher("abab").matches());
		} catch(IOException e) {
			// exception
			throw new RuntimeException(e);
		} finally {
			try {
				if(ins != null) ins.close();
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		}
	}

}
