/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

import net.morilib.sh.misc.XtraceStream;

public class ShTreeBlock implements ShTree {

	private List<ShTree> line;

	public ShTreeBlock(List<ShTree> line) {
		this.line = new ArrayList<ShTree>(line);
	}

	public int eval(ShEnvironment env,
			ShFileSystem fs,
			ShBuiltInCommands cmds,
			ShRuntime run,
			InputStream stdin,
			PrintStream stdout,
			PrintStream stderr,
			XtraceStream p) throws IOException, ShSyntaxException {
		int r = 0;

		for(ShTree s : line) {
			r = s.eval(env, fs, cmds, run, stdin, stdout, stderr, p);
		}
		return r;
	}

	public void compileInternally(ShTreeExpressionMachine.Builder b,
			Object brk, Object cnt) {
		for(ShTree e : line) {
			e.compileInternally(b, brk, cnt);
		}
	}

	public String toString() {
		StringBuffer b = new StringBuffer("{\n");
		String d = "";

		for(ShTree l : line) {
			b.append(d).append(l);
			d = " ; ";
		}
		return b.append("\n}").toString();
	}

}
