/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShSignal;
import net.morilib.sh.ShTree;

public abstract class AbstractShEnvironment
implements ShEnvironment {
    private static final String P_LCS = "([A-Za-z]+)(_([A-Za-z]+)(\\.([\\-A-Za-z_0-9]+))?)?";
    private static final Pattern P_LC = Pattern.compile("([A-Za-z]+)(_([A-Za-z]+)(\\.([\\-A-Za-z_0-9]+))?)?");
    private static final String PS = ":";
    protected List<String> path;

    protected void setpath() {
        String s = this.find("PATH");
        if (s != null) {
            s = s.replaceFirst("^:+", "");
            s = s.replaceFirst(":+$", "");
            this.path = Arrays.asList(s.split(":+"));
        }
    }

    @Override
    public List<String> getPath() {
        return this.path;
    }

    @Override
    public void bind(String name, ShTree function) {
    }

    @Override
    public void put(String name, ShTree function) {
    }

    @Override
    public ShTree findFunction(String name) {
        return null;
    }

    @Override
    public boolean isEnvironment() {
        return true;
    }

    @Override
    public boolean isSet(String name) {
        return false;
    }

    @Override
    public void set(String name) {
    }

    @Override
    public void reset(String name) {
    }

    @Override
    public void set(String name, boolean value) {
    }

    @Override
    public boolean isSystem(String name) {
        return false;
    }

    @Override
    public String getTrap(ShSignal signal) {
        return null;
    }

    @Override
    public void setTrap(ShSignal signal, String cmd) {
    }

    @Override
    public Charset getCharset() {
        String s = this.getLocale().getVariant();
        if (s == null || s.equals("")) {
            return Charset.defaultCharset();
        }
        if (s.equalsIgnoreCase("utf8")) {
            return Charset.forName("UTF-8");
        }
        if (s.equalsIgnoreCase("eucjp")) {
            return Charset.forName("EUC-JP");
        }
        if (s.equalsIgnoreCase("sjis")) {
            return Charset.forName("Windows-31J");
        }
        try {
            return Charset.forName(s);
        }
        catch (IllegalCharsetNameException e) {
            return Charset.defaultCharset();
        }
        catch (UnsupportedCharsetException e) {
            return Charset.defaultCharset();
        }
    }

    @Override
    public Locale getLocale() {
        Matcher m;
        String s = this.find("LANG");
        if (s == null || s.equals("") || !(m = P_LC.matcher(s)).matches()) {
            return Locale.getDefault();
        }
        String a1 = m.group(1);
        if (a1.equals("C")) {
            return Locale.US;
        }
        String a2 = m.group(3);
        if (a2 == null) {
            return new Locale(a1);
        }
        String a3 = m.group(5);
        if (a3 == null) {
            return new Locale(a1, a2);
        }
        return new Locale(a1, a2, a3);
    }
}

