/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.value;

import java.util.Collection;
import java.util.List;
import net.morilib.awk.nano.AwkReturnException;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.expr.AwkFunctionPrototype;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkFunctionNamespace;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkFunction;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkUserFunction
extends AwkFunction {
    private AwkExpression function;
    private String[] argnames;

    public AwkUserFunction(String name, AwkNamespace env, AwkExpression function, Collection<String> argnames) {
        super(name, env);
        this.function = function.compileInternally();
        this.argnames = argnames.toArray(new String[0]);
    }

    public AwkUserFunction(AwkFunctionPrototype f, AwkNamespace env) {
        this(f.getName(), env, f.getFunction(), f.getArgnames());
    }

    AwkValue _apply(AwkNamespace ns, AwkFiles o, List<AwkValue> args) {
        AwkNamespace e = ns;
        int i = 0;
        while (i < this.argnames.length) {
            AwkUndefined v = i < args.size() ? args.get(i) : AwkUndefined.UNDEF;
            e.assignArgument(this.argnames[i], v);
            ++i;
        }
        try {
            return this.function.eval(e, o);
        }
        catch (AwkReturnException f) {
            return f.getValue();
        }
    }

    @Override
    public AwkValue apply(AwkNamespace ns, AwkFiles o, List<AwkValue> args) {
        return this._apply(this.env == null ? new AwkFunctionNamespace(ns) : this.env, o, args);
    }

    @Override
    public AwkValue init(AwkNamespace ns, AwkFiles o, List<AwkValue> args) {
        return this._apply(new AwkFunctionNamespace(ns), o, args);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

