/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.lr;

import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.Terminal;

public final class LRAction {
    public static final int SHIFT = 1;
    public static final int REDUCE = 2;
    public static final int ACCEPT = 3;
    private int action;
    private int nextStateID;
    private Terminal symbol;
    private ContextFreeRule reduceRule;

    private LRAction() {
    }

    protected static LRAction newShift(Terminal t, int id) {
        LRAction res = new LRAction();
        res.symbol = t;
        res.action = 1;
        res.nextStateID = id;
        return res;
    }

    protected static LRAction newReduce(Terminal t, ContextFreeRule rule) {
        LRAction res = new LRAction();
        res.symbol = t;
        res.action = 2;
        res.reduceRule = rule;
        return res;
    }

    protected static LRAction newAccept() {
        LRAction res = new LRAction();
        res.action = 3;
        return res;
    }

    public boolean isShift() {
        return this.action == 1;
    }

    public boolean isReduce() {
        return this.action == 2;
    }

    public boolean isAccept() {
        return this.action == 3;
    }

    public int getAction() {
        return this.action;
    }

    public int getNextStateID() {
        return this.nextStateID;
    }

    public ContextFreeRule getReduceRule() {
        return this.reduceRule;
    }

    public Terminal getSymbol() {
        return this.symbol;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.action == 1) {
            buf.append("shift: ").append(this.nextStateID);
        } else if (this.action == 2) {
            buf.append("reduce: ").append(this.reduceRule);
        } else if (this.action == 3) {
            buf.append("accept");
        }
        return buf.toString();
    }
}

