/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.dfa;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.AlphabetsNotDiscreteException;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFAs;
import net.morilib.automata.nfa.NFAs;
import net.morilib.range.Interval;
import net.morilib.util.ArrayListStack;
import net.morilib.util.TreeSectionMap;

public class ConvertedRangeDFA<T, O, B>
implements DFA<T, O, B> {
    private Map<Object, TreeSectionMap<Interval, Object, State>> graph = new IdentityHashMap<Object, TreeSectionMap<Interval, Object, State>>();
    private Map<Object, EnumMap<TextBound, State>> boundgraph = new IdentityHashMap<Object, EnumMap<TextBound, State>>();
    private Map<Object, Set<O>> accept = new IdentityHashMap<Object, Set<O>>();
    private Map<Object, Set<B>> tags = new IdentityHashMap<Object, Set<B>>();
    private Map<Object, State> states = new HashMap<Object, State>();
    private State initial;

    private State newstate(Object nst) {
        State s = this.states.get(nst);
        if (s == null) {
            s = new State(nst);
            this.states.put(nst, s);
        }
        return s;
    }

    private void addTrans(Object st, Interval i, Object nst) {
        State n = this.newstate(nst);
        TreeSectionMap<Interval, Object, State> edges = this.graph.get(st);
        if (edges == null) {
            edges = new TreeSectionMap(i, n);
            this.graph.put(st, edges);
        } else {
            edges.insert(i, n);
        }
    }

    private void addTransBound(Object st, TextBound b, Object nst) {
        State n = this.newstate(nst);
        EnumMap<TextBound, State> edges = this.boundgraph.get(st);
        if (edges == null) {
            edges = new EnumMap(TextBound.class);
            this.boundgraph.put(st, edges);
        }
        edges.put(b, n);
    }

    private void setInitialState(Object o) {
        this.initial = this.newstate(o);
    }

    @Override
    public DFAState<T, O, B> getInitialState() {
        return this.initial;
    }

    public static <T, A, B> DFA<T, A, B> convertDFA(NFA<T, A, B> nfa) {
        HashMap<Set<NFAState>, Set<NFAState>> dstates = new HashMap<Set<NFAState>, Set<NFAState>>();
        ArrayListStack<Set<NFAState>> stk = new ArrayListStack<Set<NFAState>>();
        ConvertedRangeDFA res = new ConvertedRangeDFA();
        Set<NFAState> init = NFAs.getEpsilonReachable(nfa, nfa.getInitialStates());
        super.setInitialState(init);
        stk.push(init);
        while (!stk.isEmpty()) {
            Set t = (Set)stk.pop();
            dstates.put(t, t);
            res.tags.put(t, NFAs.getMatchTag(nfa, t));
            res.accept.put(t, NFAs.getAccept(nfa, t));
            for (Interval r : nfa.nextAlphabets(t)) {
                Set<NFAState> u = NFAs.getEpsilonReachable(nfa, NFAs.getStates(nfa, (Set<NFAState>)t, r));
                Set<NFAState> z = (Set<NFAState>)dstates.get(u);
                if (z == null) {
                    dstates.put(u, u);
                    stk.push(u);
                    z = u;
                }
                super.addTrans(t, r, z);
            }
            for (TextBound b : TextBound.ALL) {
                EnumSet<TextBound> bs = EnumSet.of(b);
                Set<NFAState> u = NFAs.getEpsilonReachable(nfa, NFAs.getStatesBound(nfa, t, bs));
                if (u.isEmpty()) continue;
                Set<NFAState> z = (Set<NFAState>)dstates.get(u);
                if (z == null) {
                    dstates.put(u, u);
                    stk.push(u);
                    z = u;
                }
                super.addTransBound(t, b, z);
            }
        }
        return res;
    }

    private class State
    implements DFAState<T, O, B> {
        private Object st;

        private State(Object st) {
            this.st = st;
        }

        @Override
        public DFAState<T, O, B> go(T alphabet) {
            TreeSectionMap ts = (TreeSectionMap)ConvertedRangeDFA.this.graph.get(this.st);
            if (ts == null) {
                return DFAs.deadState();
            }
            State s2 = (State)ts.map(alphabet);
            if (s2 == null) {
                return DFAs.deadState();
            }
            return s2;
        }

        @Override
        public DFAState<T, O, B> goBound(TextBound bound) {
            EnumMap ts = (EnumMap)ConvertedRangeDFA.this.boundgraph.get(this.st);
            if (ts == null) {
                return DFAs.deadState();
            }
            State s2 = (State)ts.get((Object)bound);
            if (s2 == null) {
                return DFAs.deadState();
            }
            return s2;
        }

        @Override
        public Set<O> getAccepted() {
            Set res = (Set)ConvertedRangeDFA.this.accept.get(this.st);
            return res == null ? Collections.emptySet() : res;
        }

        @Override
        public boolean isInitialState() {
            return ConvertedRangeDFA.this.initial == this.st;
        }

        @Override
        public boolean isDead() {
            return ConvertedRangeDFA.this.graph.get(this.st) == null;
        }

        @Override
        public DFAState<T, O, B> goInt(int x) {
            return this.go(x);
        }

        @Override
        public DFAState<T, O, B> goChar(char x) {
            return this.go(Integer.valueOf(x));
        }

        @Override
        public boolean isAccepted() {
            Set res = (Set)ConvertedRangeDFA.this.accept.get(this.st);
            return res != null && !res.isEmpty();
        }

        @Override
        public Set<T> getAlphabets() {
            throw new AlphabetsNotDiscreteException();
        }

        @Override
        public Iterable<Interval> getAlphabetRanges() {
            TreeSectionMap ts = (TreeSectionMap)ConvertedRangeDFA.this.graph.get(this.st);
            if (ts == null) {
                return Collections.emptySet();
            }
            return ts.keys();
        }

        @Override
        public Object getLabel(T alphabet) {
            return null;
        }

        @Override
        public Object getLabelInt(int x) {
            return null;
        }

        @Override
        public Object getLabelChar(char x) {
            return null;
        }
    }
}

