/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.unix.regex;

import java.util.ArrayList;
import java.util.List;
import net.morilib.unix.charset.IntRange;
import net.morilib.unix.charset.UnixCharSets;
import net.morilib.unix.misc.WideString;
import net.morilib.unix.regex.BasicMatcher;
import net.morilib.unix.regex.BasicPatternSyntaxException;
import net.morilib.unix.regex.BasicRegexCharacters;

public class BasicPattern {
    public static final int CASE_INSENSITIVE = 1;
    public static final int ALL_MATCH = 2;
    private static final int ANCHOR_BE = 3;
    private static final int ANCHOR_B = 2;
    private static final int ANCHOR_E = 1;
    private static final int NO_ANCHOR = 0;
    List<Elm> elements;
    int flags;
    int anchors;

    BasicPattern(List<Elm> e, int f, boolean ban, boolean ean) {
        this.elements = e;
        this.flags = f;
        this.anchors = (ban ? 2 : 0) | (ean ? 1 : 0);
    }

    boolean isAnchorBoth() {
        return this.anchors == 3;
    }

    boolean isAnchorBegin() {
        return this.anchors == 2;
    }

    boolean isAnchorEnd() {
        return this.anchors == 1;
    }

    boolean isNoAnchors() {
        return this.anchors == 0;
    }

    public static BasicPattern compile(String pattern, int flags) {
        ArrayList<Integer> cap = new ArrayList<Integer>();
        ArrayList<Elm> l = new ArrayList<Elm>();
        StringBuffer b = null;
        StringBuffer b2 = null;
        boolean ban = false;
        boolean ean = false;
        String p = pattern;
        St1 stat = St1.INIT;
        int cn = 1;
        int i = 0;
        if (pattern.length() == 0) {
            return new BasicPattern(new ArrayList<Elm>(), 0, false, false);
        }
        if (pattern.codePointAt(0) == 94) {
            ban = true;
            ++i;
        }
        cap.add(0);
        while (i < p.length()) {
            int c = p.codePointAt(i);
            if (c == 36 && !stat.equals((Object)St1.ESC1) && !stat.equals((Object)St1.ESC2) && i + 1 == p.length()) {
                ean = true;
                break;
            }
            switch (stat) {
                case INIT: {
                    if (c == 92) {
                        stat = St1.ESC1;
                        break;
                    }
                    if (c == 42) {
                        throw new BasicPatternSyntaxException();
                    }
                    if (c == 91) {
                        stat = St1.BRA;
                        break;
                    }
                    if (c == 46) {
                        l.add(new Elm(BasicRegexCharacters.DOT, cap));
                        stat = St1.NRM;
                        break;
                    }
                    l.add(new Elm(c, cap));
                    stat = St1.NRM;
                    break;
                }
                case NRM: {
                    if (c == 92) {
                        stat = St1.ESC2;
                        break;
                    }
                    if (c == 42) {
                        ((Elm)l.get((int)(l.size() - 1))).repeatFrom = 0;
                        ((Elm)l.get((int)(l.size() - 1))).repeatTo = -1;
                        break;
                    }
                    if (c == 91) {
                        stat = St1.BRA;
                        break;
                    }
                    if (c == 46) {
                        l.add(new Elm(BasicRegexCharacters.DOT, cap));
                        break;
                    }
                    l.add(new Elm(c, cap));
                    break;
                }
                case ESC2: {
                    if (c == 123) {
                        b = new StringBuffer();
                        stat = St1.NUM1;
                        break;
                    }
                    if (c == 43) {
                        ((Elm)l.get((int)(l.size() - 1))).repeatFrom = 1;
                        ((Elm)l.get((int)(l.size() - 1))).repeatTo = -1;
                        stat = St1.INIT;
                        break;
                    }
                    if (c == 63) {
                        ((Elm)l.get((int)(l.size() - 1))).repeatFrom = 0;
                        ((Elm)l.get((int)(l.size() - 1))).repeatTo = 1;
                        stat = St1.INIT;
                        break;
                    }
                }
                case ESC1: {
                    if (c == 40) {
                        cap = new ArrayList<Integer>(cap);
                        cap.add(cn++);
                        stat = St1.INIT;
                        break;
                    }
                    if (c == 41) {
                        if (cap.size() == 1) {
                            throw new BasicPatternSyntaxException();
                        }
                        cap = new ArrayList<Integer>(cap);
                        cap.remove(cap.size() - 1);
                        stat = St1.INIT;
                        break;
                    }
                    if (c >= 49 && c <= 57) {
                        if (c - 48 >= cn) {
                            throw new BasicPatternSyntaxException();
                        }
                        l.add(new Elm(c - 48));
                        stat = St1.INIT;
                        break;
                    }
                    l.add(new Elm(c, cap));
                    stat = St1.NRM;
                    break;
                }
                case BRA: {
                    b = new StringBuffer().appendCodePoint(c);
                    stat = St1.BRA2;
                    break;
                }
                case BRA2: {
                    if (c == 93) {
                        stat = St1.NRM;
                        l.add(new Elm(UnixCharSets.parse(b.toString()), cap));
                        break;
                    }
                    b.appendCodePoint(c);
                    break;
                }
                case NUM1: {
                    if (c >= 48 && c <= 57) {
                        b.append((char)c);
                        break;
                    }
                    if (c == 92) {
                        stat = St1.NUM2;
                        break;
                    }
                    if (c == 44) {
                        b2 = new StringBuffer();
                        stat = St1.NUM3;
                        break;
                    }
                    throw new BasicPatternSyntaxException();
                }
                case NUM2: {
                    int x;
                    if (c != 125) {
                        throw new BasicPatternSyntaxException();
                    }
                    ((Elm)l.get((int)(l.size() - 1))).repeatFrom = x = Integer.parseInt(b.toString());
                    ((Elm)l.get((int)(l.size() - 1))).repeatTo = x;
                    stat = St1.INIT;
                    break;
                }
                case NUM3: {
                    if (c >= 48 && c <= 57) {
                        b2.append((char)c);
                        stat = St1.NUM4;
                        break;
                    }
                    if (c == 92) {
                        stat = St1.NUM5;
                        break;
                    }
                    throw new BasicPatternSyntaxException();
                }
                case NUM4: {
                    if (c >= 48 && c <= 57) {
                        b2.append((char)c);
                        break;
                    }
                    if (c == 92) {
                        stat = St1.NUM6;
                        break;
                    }
                    throw new BasicPatternSyntaxException();
                }
                case NUM5: {
                    int x;
                    if (c != 125) {
                        throw new BasicPatternSyntaxException();
                    }
                    ((Elm)l.get((int)(l.size() - 1))).repeatFrom = x = Integer.parseInt(b.toString());
                    ((Elm)l.get((int)(l.size() - 1))).repeatTo = -1;
                    stat = St1.INIT;
                    break;
                }
                case NUM6: {
                    if (c != 125) {
                        throw new BasicPatternSyntaxException();
                    }
                    int x = Integer.parseInt(b.toString());
                    int y = Integer.parseInt(b2.toString());
                    ((Elm)l.get((int)(l.size() - 1))).repeatFrom = x;
                    ((Elm)l.get((int)(l.size() - 1))).repeatTo = y;
                    stat = St1.INIT;
                }
            }
            i += c > 65535 ? 2 : 1;
        }
        if (stat.equals((Object)St1.BRA) || stat.equals((Object)St1.BRA2)) {
            throw new BasicPatternSyntaxException();
        }
        if (stat.equals((Object)St1.ESC1) || stat.equals((Object)St1.ESC2)) {
            l.add(new Elm(92, cap));
        }
        return new BasicPattern(l, flags, ban, ean);
    }

    public static BasicPattern compile(String pattern) {
        return BasicPattern.compile(pattern, 0);
    }

    public BasicMatcher matcher(String s) {
        return new BasicMatcher(this, new WideString(s));
    }

    public static boolean matches(String pattern, String s) {
        return BasicPattern.compile(pattern).matcher(s).matches();
    }

    public static boolean matchesAll(String pattern, String s) {
        return BasicPattern.compile(pattern).matcher(s).matchesAll();
    }

    static class Elm {
        BasicRegexCharacters chars;
        int repeatFrom = -1;
        int repeatTo = -1;
        List<Integer> capture;
        int captured = -1;

        Elm(BasicRegexCharacters chars, List<Integer> cap) {
            this.chars = chars;
            this.capture = cap;
        }

        Elm(IntRange chars, List<Integer> cap) {
            this.chars = BasicRegexCharacters.valueOf(chars);
            this.capture = cap;
        }

        Elm(int ch, List<Integer> cap) {
            this.chars = BasicRegexCharacters.valueOf(ch);
            this.capture = cap;
        }

        Elm(int captured) {
            this.captured = captured;
        }

        boolean isok(int i) {
            return this.repeatTo < 0 || i < this.repeatTo;
        }
    }

    private static enum St1 {
        INIT,
        NRM,
        ESC1,
        ESC2,
        BRA,
        BRA2,
        NUM1,
        NUM2,
        NUM3,
        NUM4,
        NUM5,
        NUM6;

    }
}

