/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.io.LineWriter;
import net.morilib.awk.nano.io.RecordReader;

public final class AwkVirtualFile {
    static final String STDIN = "/dev/stdin";
    static final String STDIN2 = "/dev/fd/0";
    static final String STDOUT = "/dev/stdout";
    static final String STDERR = "/dev/stderr";
    static final String STDOT2 = "/dev/fd/1";
    static final String STDER2 = "/dev/fd/2";
    static final String NULL = "/dev/null";
    public static final String DEBUG = "/dev/debug";
    static final LineWriter NULLWRITER = new LineWriter(){

        @Override
        public void print(String s) {
        }

        @Override
        public void println(String s) {
        }

        @Override
        public void printf(String format, Object ... args) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws IOException {
        }
    };
    public static final ByteArrayOutputStream DEBUG_BIN_IO = new ByteArrayOutputStream();

    public static LineWriter out(String fname, AwkFiles fs) {
        if (fname.equals(STDOUT) || fname.equals(STDOT2)) {
            return fs.getStdout();
        }
        if (fname.equals(STDERR) || fname.equals(STDER2)) {
            return fs.getStderr();
        }
        if (fname.equals(NULL)) {
            return NULLWRITER;
        }
        return null;
    }

    public static RecordReader in(String fname, AwkFiles fs) {
        if (fname.equals(STDIN) || fname.equals(STDIN2)) {
            return fs.getStdin();
        }
        return null;
    }

    public static OutputStream outBinary(String fname, AwkFiles fs) {
        if (fname.equals(DEBUG)) {
            return DEBUG_BIN_IO;
        }
        return null;
    }
}

