/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed.cmd;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import net.morilib.sed.SedCommand;
import net.morilib.sed.SedCommandLine;
import net.morilib.sed.SedEngine;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedSpace;
import net.morilib.sed.cmd.SedACommand;

public class SedCompositeCommand
implements SedCommand {
    private SedCommandLine[] commands;

    public SedCompositeCommand(Collection<SedCommandLine> commands) {
        this.commands = commands.toArray(new SedCommandLine[0]);
    }

    public SedCompositeCommand(SedCommandLine ... commands) {
        this(Arrays.asList(commands));
    }

    @Override
    public String getLongDescription() {
        return "composite command";
    }

    @Override
    public char getName() {
        return '{';
    }

    @Override
    public void process(SedSpace s, SedLineBuffer rd) throws IOException {
        s.setNextLabel(SedEngine.execute(this, s, rd, this.commands));
    }

    public SedCommandLine[] getCommandLines() {
        SedCommandLine[] l = new SedCommandLine[this.commands.length];
        System.arraycopy(this.commands, 0, l, 0, l.length);
        return l;
    }

    public int hashCode() {
        return Arrays.hashCode(this.commands);
    }

    public boolean equals(Object o) {
        if (o instanceof SedACommand) {
            return Arrays.equals(this.commands, ((SedCompositeCommand)o).commands);
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{\n");
        SedCommandLine[] sedCommandLineArray = this.commands;
        int n = this.commands.length;
        int n2 = 0;
        while (n2 < n) {
            SedCommandLine s = sedCommandLineArray[n2];
            b.append(s).append('\n');
            ++n2;
        }
        return b.append('}').toString();
    }
}

