/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.automata.DFAState;
import net.morilib.nina.DFABuilder;
import net.morilib.nina.NinaState;
import net.morilib.nina.Quadro;
import net.morilib.nina.TMBuilder;
import net.morilib.nina.translate.AbstractNinaTranslator;
import net.morilib.nina.translate.LRTranslator;
import net.morilib.nina.translate.LRTranslatorJavaScript;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.ReplaceAction;
import net.morilib.nina.translate.sh.ReplaceStrangeChar;
import net.morilib.range.Interval;
import net.morilib.sh.ShEnvironment;

public class NinaTranslatorJavaScript
extends AbstractNinaTranslator {
    private static final Pattern RET_CONST = Pattern.compile("return +([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*;");
    private static final Pattern E_CONST = Pattern.compile("([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*");
    private static final Pattern _IAT = Pattern.compile("(.*),([A-Z]+|\\*)");
    private static final Pattern _CLS = Pattern.compile("<(.*)>");
    private static final Pattern _STR = Pattern.compile("\"(.*)\"");
    private static final String LOK = "LOOKAHEAD($c);";

    public NinaTranslatorJavaScript() {
        this.parent = this;
    }

    private int infimumbound(Interval a) {
        Object o = a.getInfimumBound();
        return o == Interval.FROM_INFIMUM ? 0 : (Integer)o;
    }

    private String tostr(int c) {
        return Integer.toString(c);
    }

    private void printintv(PrintStream out, Interval v, boolean els, Object o) {
        String z;
        String s = v.isInfimumClosed() ? ">=" : ">";
        String t = v.isSupremumClosed() ? "<=" : "<";
        String a = els ? "\t\t\t} else if" : "\t\tif";
        int c = (Integer)v.getInfimumBound();
        int d = (Integer)v.getSupremumBound();
        String x = this.tostr(c);
        String y = this.tostr(d);
        String string = z = o != null && o.toString().startsWith(LOK) ? "__l__ && " : "";
        if (v.isClosed() && c == d) {
            out.format("%s(%s$c == %s) {\n", a, z, x);
        } else {
            out.format("%s(%s$c %s %s && $c %s %s) {\n", a, z, s, x, t, y);
        }
    }

    private void printobj(PrintStream out, Object o, boolean els, Object m) {
        String a = els ? "\t\t} else if" : "\t\tif";
        String z = m != null && m.toString().startsWith(LOK) ? "__l__ && " : "";
        out.format("%s(%s$c.equals(\"%s\")) {\n", a, z, o.toString());
    }

    private void printclchar(PrintStream out, char c, String a, String z) {
        out.format("%s(%s$c == %d) {\n", a, z, (int)c);
    }

    private boolean printclass1(PrintStream out, Object o, boolean els, Object m) {
        String z;
        String a = els ? "\t\t} else if" : "\t\tif";
        String string = z = m != null && m.toString().startsWith(LOK) ? "__l__ && " : "";
        if (o instanceof Character) {
            this.printclchar(out, ((Character)o).charValue(), a, z);
        } else if (o instanceof Integer) {
            this.printclchar(out, (char)((Integer)o).intValue(), a, z);
        } else {
            String s = o.toString();
            if (E_CONST.matcher(s).matches()) {
                out.format("%s(%s%s == $c) {\n", a, z, s);
            } else {
                Matcher t = _STR.matcher(s);
                if (t.matches()) {
                    out.format("%s(%s\"%s\" == $c) {\n", a, z, this.escapeprint(t.group(1)));
                } else {
                    t = _CLS.matcher(s);
                    if (t.matches()) {
                        return false;
                    }
                    if (s.length() == 1) {
                        this.printclchar(out, s.charAt(0), a, z);
                        out.format("\t\t\t} else if(%s\"%s\" == $c) {\n", z, this.escapeprint(s));
                    } else {
                        out.format("%s(%s\"%s\" == $c) {\n", a, z, this.escapeprint(s));
                    }
                }
            }
        }
        return true;
    }

    private boolean printclass2(PrintStream out, Object o, boolean els, Object m) {
        Matcher t;
        String s;
        String z;
        String a = els ? "\t\t} else if" : "\t\tif";
        String string = z = m != null && m.toString().startsWith(LOK) ? "__l__ && " : "";
        if (!(o instanceof Character || o instanceof Integer || E_CONST.matcher(s = o.toString()).matches() || (t = _STR.matcher(s)).matches())) {
            t = _CLS.matcher(s);
            if (t.matches()) {
                s = t.group(1);
                if (s.equalsIgnoreCase("number") || s.equalsIgnoreCase("string") || s.equalsIgnoreCase("boolean")) {
                    out.format("%s(%s(typeof $c) == '%s') {\n", a, z, s.toLowerCase());
                } else {
                    out.format("%s(%s$c instanceof %s) {\n", a, z, s);
                }
                return true;
            }
            s.length();
        }
        return false;
    }

    private String outln(boolean els, PrintStream out, String s) {
        if (els) {
            out.printf("\t\t} else if(%s) {\n", s);
        } else {
            out.printf("\t\tif(%s) {\n", s);
        }
        return "\t";
    }

    private boolean putend(String s, PrintStream out, DFAState<Object, ?, Void> dfa, boolean els) {
        TMBuilder.DBS x;
        DFABuilder.DBS b;
        if (dfa instanceof DFABuilder.DBS && (b = ((DFABuilder.DBS)dfa).getEnd()) != null) {
            this.outln(els, out, s);
            Object o = ((DFABuilder.DBS)dfa).getMealyEnd();
            if (o != null) {
                out.format("\t\t\t%s\n", o.toString());
            }
            out.format("\t\t\tSTATE = %d;\n", this.getStateNo(b));
            out.format("\t\t\treturn 1;\n", new Object[0]);
            els = true;
        } else if (dfa instanceof TMBuilder.DBS && (x = ((TMBuilder.DBS)dfa).getEnd()) != null) {
            this.outln(els, out, s);
            this.printIntervalAction(out, dfa, ((TMBuilder.DBS)dfa).getMealyEnd());
            out.format("\t\t\t\tSTATE = %d;\n", this.getStateNo(x));
            out.format("\t\t\t\treturn 1;\n", new Object[0]);
            els = true;
        }
        return els;
    }

    private boolean putuseredges(PrintStream out, DFAState<Object, ?, Void> dfa, boolean els) {
        Set<String> k;
        if (dfa instanceof DFABuilder.DBS && (k = ((DFABuilder.DBS)dfa).getUserEdges()) != null) {
            for (String x : k) {
                DFABuilder.DBS b = ((DFABuilder.DBS)dfa).getUserEdge(x);
                Object o = ((DFABuilder.DBS)dfa).getUserMealyEdge(x);
                if (els) {
                    out.printf("\t\t} else if(%s) {\n", x);
                } else {
                    out.printf("\t\tif(%s) {\n", x);
                }
                if (o != null) {
                    out.format("\t\t\t%s\n", o.toString());
                }
                out.format("\t\t\tSTATE = %d;\n", this.getStateNo(b));
                out.format("\t\t\treturn 1;\n", new Object[0]);
                els = true;
            }
        }
        return els;
    }

    private boolean putothers(PrintStream out, DFAState<Object, ?, Void> dfa, boolean els, String so) {
        if (dfa instanceof TMBuilder.DBS) {
            TMBuilder.DBS x = ((TMBuilder.DBS)dfa).getOthers();
            if (x != null) {
                String s = this.outln(els, out, so);
                this.printIntervalAction(out, dfa, ((TMBuilder.DBS)dfa).getMealyOthers());
                out.format("%s\t\t\tSTATE = %d;\n", s, this.getStateNo(x));
                out.format("%s\t\t\treturn 1;\n", s);
                return true;
            }
            return els;
        }
        if (!(dfa instanceof DFABuilder.DBS)) {
            return els;
        }
        DFABuilder.DBS a = (DFABuilder.DBS)dfa;
        DFABuilder.DBS b = a.getOthers();
        if (b != null) {
            String s = this.outln(els, out, so);
            Object o = a.getMealyOthers();
            if (o != null) {
                out.format("%s\t\t%s\n", s, o.toString());
            }
            out.format("%s\t\tSTATE = %d;\n", s, this.getStateNo(b));
            out.format("%s\t\treturn 1;\n", s);
            return true;
        }
        b = a.getRecursive();
        if (b == null) {
            return els;
        }
        if (a.getRecursiveName().startsWith("g:")) {
            String s = this.outln(els, out, so);
            String t = a.getRecursiveName().substring(2);
            out.format("%s\t\t$this.__stkpush(%d, new LR%sEngine());\n", s, this.getStateNo(b), t);
            out.format("%s\t\tSTATE = 0;\n", s);
            out.format("%s\t\treturn NINA_ACCEPT;\n", s);
            return true;
        }
        String s = this.outln(els, out, so);
        String t = ReplaceStrangeChar.replace(a.getRecursiveName());
        out.format("%s\t\t$this.__stkpush(%d, $this.ENGINE_%s);\n", s, this.getStateNo(b), t);
        out.format("%s\t\tSTATE = 0;\n", s);
        out.format("%s\t\treturn NINA_ACCEPT;\n", s);
        return true;
    }

    private boolean printDynamicTransition(PrintStream out, DFAState<Object, ?, Void> dfa, boolean els) {
        DFABuilder.DBS d;
        if (dfa instanceof DFABuilder.DBS && (d = ((DFABuilder.DBS)dfa).getDynamic()) != null) {
            String s = ((DFABuilder.DBS)dfa).getDynamicVariable();
            out.print("\t\t");
            if (els) {
                out.print("} else ");
            }
            out.printf("if(__l__ && $this.__startWith(%s, $c)) {\n", s);
            out.format("\t\t\t$this.__stkpush(%d, new DynamicEngine(%s, %d));\n", this.getStateNo(d), s, this.getStateNo(dfa));
            out.format("\t\t\tSTATE = 0;\n", s);
            out.format("\t\t\treturn NINA_ACCEPT;\n", s);
            return true;
        }
        return els;
    }

    private void printWritetape(PrintStream out, String a) {
        if (a.length() != 0) {
            if (a.length() > 1) {
                out.printf("\t\t\t\tthis._writetape(\"%s\");\n", a);
            } else {
                out.printf("\t\t\t\tthis._writetape(%d);\n", a.charAt(0));
            }
        }
    }

    private void printIntervalAction(PrintStream out, DFAState<Object, ?, Void> d, Object o) {
        if (d instanceof TMBuilder.DBS) {
            if (o == null) {
                out.printf("\t\t\t\tthis._movetape(R);\n", new Object[0]);
            } else {
                String s = o.toString();
                if (!s.equals("UNGET($c);")) {
                    Matcher m = _IAT.matcher(s);
                    if (m.matches()) {
                        this.printWritetape(out, m.group(1));
                        if (!m.group(2).equals("*")) {
                            out.printf("\t\t\t\tthis._movetape(%s);\n", m.group(2));
                        }
                    } else {
                        this.printWritetape(out, s);
                    }
                }
            }
        } else if (o != null) {
            out.format("\t\t\t\t%s\n", o.toString());
        }
    }

    private void printState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        boolean els = false;
        int sn = this.getStateNo(dfa);
        out.format("\tcase %d:\n", sn);
        for (Interval v : dfa.getAlphabetRanges()) {
            if (v.isEmpty()) continue;
            int c = this.infimumbound(v);
            if (v.isInfimumOpen()) {
                ++c;
            }
            Object o = dfa.getLabelInt(c);
            this.printintv(out, v, els, o);
            this.printIntervalAction(out, dfa, o);
            DFAState<Object, ?, Void> d = dfa.goInt(c);
            out.format("\t\t\tSTATE = %d;\n", this.getStateNo(d));
            out.println("\t\t\treturn 1;");
            els = true;
        }
        els = this.printDynamicTransition(out, dfa, els);
        els = this.putend("$c == null", out, dfa, els);
        els = this.putuseredges(out, dfa, els);
        if (els = this.putothers(out, dfa, els, "$c != null")) {
            out.println("\t\t}");
        }
        out.println("\t\treturn 0;");
    }

    private void printObjectState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        boolean els = false;
        int sn = this.getStateNo(dfa);
        out.format("\t\tcase %d:\n", sn);
        for (Object p : dfa.getAlphabets()) {
            Object o = dfa.getLabel(p);
            this.printobj(out, p, els, o);
            this.printIntervalAction(out, dfa, o);
            DFAState<Object, ?, Void> d = dfa.go(p);
            out.format("\t\t\tSTATE = %d;\n", this.getStateNo(d));
            out.println("\t\t\treturn 1;");
            els = true;
        }
        els = this.printDynamicTransition(out, dfa, els);
        els = this.putend("$c == null", out, dfa, els);
        els = this.putuseredges(out, dfa, els);
        if (els = this.putothers(out, dfa, els, "$c != null")) {
            out.println("\t\t}");
        }
        out.println("\t\treturn 0;");
    }

    private void printClassState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        DFAState<Object, ?, Void> d;
        Object o;
        boolean els = false;
        int sn = this.getStateNo(dfa);
        out.format("\t\tcase %d:\n", sn);
        for (Object p : dfa.getAlphabets()) {
            if (!this.printclass1(out, p, els, o = dfa.getLabel(p))) continue;
            this.printIntervalAction(out, dfa, o);
            d = dfa.go(p);
            out.format("\t\t\tSTATE = %d;\n", this.getStateNo(d));
            out.println("\t\t\treturn 1;");
            els = true;
        }
        for (Object p : dfa.getAlphabets()) {
            if (!this.printclass2(out, p, els, o = dfa.getLabel(p))) continue;
            this.printIntervalAction(out, dfa, o);
            d = dfa.go(p);
            out.format("\t\t\tSTATE = %d;\n", this.getStateNo(d));
            out.println("\t\t\treturn 1;");
            els = true;
        }
        els = this.printDynamicTransition(out, dfa, els);
        els = this.putend("$c == null", out, dfa, els);
        els = this.putuseredges(out, dfa, els);
        if (els = this.putothers(out, dfa, els, "$c != null")) {
            out.println("\t\t}");
        }
        out.println("\t\treturn 0;");
    }

    private boolean isProcessed(DFAState<Object, ?, Void> state) {
        return this.containsState(state);
    }

    private int getDeadStateNo() {
        Object s = this.builder.getDeadState();
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    private int getStateNoByLabel(String l) {
        Object s = this.builder.getStateByLabel(l);
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    @Override
    public void printStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printState(out, this.popStack());
            }
        }
    }

    @Override
    public void printObjectStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printObjectState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printObjectState(out, this.popStack());
            }
        }
    }

    @Override
    public void printClassStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printClassState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printClassState(out, this.popStack());
            }
        }
    }

    @Override
    public void printAcceptStates(PrintStream out) {
        String d = "\treturn (";
        if (this.acceptsSize() == 0) {
            out.println("\treturn false;");
        } else {
            for (Integer i : this.acceptsIterable()) {
                out.print(d);
                out.format("STATE == %d", i);
                d = " ||\n\t\t\t";
            }
            out.println(");");
        }
    }

    @Override
    public void printAcceptToken(PrintStream out) {
        int m = -1;
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!s.isAccepted()) continue;
            String p = null;
            m = -1;
            out.format("\tcase %d:\n", this.stateNo(s));
            for (Object a : s.getAccepted()) {
                int q;
                if (a == null || !(a instanceof NinaState) || (q = ((NinaState)a).getPriority()) < 0 || q <= m) continue;
                m = q;
            }
            for (Object a : s.getAccepted()) {
                NinaState n;
                String x;
                if (a == null || !(a instanceof NinaState) || (x = (n = (NinaState)a).getLabel()) == null || (x = x.trim()).equals("")) continue;
                if (m >= 0) {
                    if (n.getPriority() != m) continue;
                    p = x;
                    continue;
                }
                if (RET_CONST.matcher(x).matches()) {
                    p = x;
                    break;
                }
                if (p != null) {
                    this.getOptions().pwarn("ambiguousaccept", new Object[0]);
                }
                p = x;
            }
            out.format("\t\t%s\n", p != null ? p : "return $$;");
        }
    }

    @Override
    public void printActions(PrintStream out) {
        boolean[] a = new boolean[1];
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            String p = null;
            out.format("\tcase %d:\n", this.stateNo(s));
            String x = s.toString();
            if (x != null && !(x = x.trim()).equals("")) {
                p = x;
            }
            if (p == null) {
                out.println("\t\tbreak;");
                continue;
            }
            p = ReplaceAction.replace(p, a, this, this.stateNo(s), this.builder.getLabelByState(s));
            String[] stringArray = p.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                out.format("\t\t%s\n", v);
                ++n2;
            }
            if (a[0]) continue;
            out.println("\t\tbreak;");
        }
    }

    @Override
    public void printImports(List<String> imp, PrintStream out) {
    }

    @Override
    public void printIsEnd(PrintStream out) {
        HashSet<Integer> t = new HashSet<Integer>();
        String d = "\treturn (";
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!(s instanceof DFABuilder.DBS) || ((DFABuilder.DBS)s).getEnd() == null) continue;
            t.add(this.stateNo(s));
        }
        if (t.size() == 0) {
            out.println("\treturn false;");
        } else {
            for (Integer i : t) {
                out.print(d);
                out.format("STATE == %d", i);
                d = " ||\n\t\t\t";
            }
            out.println(");");
        }
    }

    @Override
    public void printDeadState(String n, PrintStream out) {
        out.printf("\treturn %d;\n", this.getDeadStateNo());
    }

    @Override
    protected void printRecover(PrintStream out) {
        String d = "";
        for (String x : this.builder.getLabels()) {
            if (!x.endsWith("Exception")) continue;
            DFAState s = (DFAState)this.builder.getStateByLabel(x);
            out.printf("\t\t%sif(e == '%s') {\n", d, x, x);
            out.printf("\t\t\treturn %d;\n", this.getStateNo(s));
            d = "} else ";
        }
        if (d.equals("")) {
            out.println("\t\treturn -1;");
        } else {
            out.println("\t\t} else {");
            out.println("\t\t\treturn -1;");
            out.println("\t\t}");
        }
    }

    @Override
    public void printFinallyState(PrintStream out) {
        out.printf("\treturn %d;\n", this.getStateNoByLabel("finally"));
    }

    @Override
    protected void printInitTrap(PrintStream out) {
    }

    @Override
    protected void printNFADeadState(PrintStream out) {
        out.print("\t\treturn (false");
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!s.isDead()) continue;
            out.print(" ||\n\t\t");
            out.print("STATE == ");
            out.print(this.stateNo(s));
        }
        out.println(");");
    }

    @Override
    protected void printAttrs(PrintStream out) {
    }

    @Override
    protected void printConstants(PrintStream out) {
        for (Map.Entry<String, Integer> t : this.quadro.getConstantMap().entrySet()) {
            out.printf("%s = %d;\n", t.getKey(), (int)t.getValue());
        }
    }

    @Override
    public void reportStatistics(PrintStream std) {
        this.getOptions().print("statheader", new Object[0]);
        this.getOptions().print("statstates", this.stateSize());
        this.getOptions().print("stataccept", this.acceptsSize());
    }

    @Override
    protected InputStream openScript(ShEnvironment env) {
        if (this.options.getInjectFile() == null) {
            return NinaTranslator.class.getResourceAsStream("/net/morilib/nina/translate/nina_template." + this.getMachine() + ".js.sh");
        }
        env.bind("TRANS_COMMAND", "nina_template." + this.getMachine() + ".js.sh");
        return NinaTranslator.class.getResourceAsStream("/net/morilib/nina/translate/nina_injector.sh");
    }

    @Override
    public String getExtension() {
        return ".js";
    }

    @Override
    protected PrintStream openOutput() throws IOException {
        return new PrintStream(this.getOptions().getOutputStream(this.getOptions().getOutputDir(), String.valueOf(this.getOptions().getOutputFilename()) + this.getExtension()), true);
    }

    @Override
    protected AbstractNinaTranslator newPrototype() {
        NinaTranslatorJavaScript r = new NinaTranslatorJavaScript();
        r.quadro = this.quadro;
        return r;
    }

    @Override
    protected void appendValue(StringBuffer ot, StringBuffer b1) {
        Object o = this.builder.getStateByLabel(b1.toString());
        if (o == null) {
            ot.append('$');
            ot.append(b1);
        } else {
            ot.append("($this.__stv[$this.__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])");
        }
    }

    @Override
    protected void appendLvalue(StringBuffer ot, StringBuffer b1) {
        Object o = this.builder.getStateByLabel(b1.toString());
        if (o == null) {
            ot.append('@');
            ot.append(b1);
        } else {
            ot.append("($this.__stv[$this.__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])");
        }
    }

    @Override
    protected void appendMyPosition(StringBuffer ot, String ln, int cn) {
        ot.append("($this.__stv[$this.__slen - 1][");
        ot.append(cn);
        ot.append("])");
    }

    @Override
    protected void appendReturn(StringBuffer ot) {
        ot.append("$$");
    }

    @Override
    protected String getConstName(String t) {
        if (t.equals("EXIT")) {
            return "NINA_ACCEPT";
        }
        if (t.equals("FAIL")) {
            return "NINA_FAIL";
        }
        if (t.equals("ACCEPT")) {
            return "NINA_HALT_ACCEPT";
        }
        if (t.equals("REJECT")) {
            return "NINA_HALT_REJECT";
        }
        return null;
    }

    @Override
    protected void appendYield(StringBuffer ot, String b) {
        ot.append("$this.yieldObject = (").append(b).append(");");
        ot.append("return NINA_YIELD;");
    }

    @Override
    protected LRTranslator getLRTranslator(Quadro q) {
        return new LRTranslatorJavaScript(q);
    }

    @Override
    protected void setLocalenv(Quadro q, ShEnvironment env) {
    }
}

