/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.math.stochastic.MarkovProcess;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.NinaException;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaParser;
import net.morilib.nina.NinaSubautomata;
import net.morilib.range.CharSets;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.util.Tuple2;

public class MarkovBuilder
implements NinaAction {
    private static final Pattern PTN1 = Pattern.compile("\"(.*)\"");
    private static final Pattern PTN2 = Pattern.compile("\\[(.*)\\]");
    private DBS initial;
    private DBS vertex;
    private String label;
    private String name;
    private String output;

    private Object parseOutput(String s) {
        if (s == null) {
            return "";
        }
        Matcher m = PTN1.matcher(s);
        if (m.matches()) {
            return m.group(1);
        }
        m = PTN2.matcher(s);
        if (m.matches()) {
            String t = m.group(1);
            Range r = CharSets.parse(t);
            if (r.contains(0x7FFFFFFE)) {
                throw new NinaException("notcomplement", new Object[0]);
            }
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (Interval v : r.intervals()) {
                int k = (Integer)v.getInfimumBound();
                while (v.contains(k)) {
                    l.add(k);
                    ++k;
                }
            }
            return l;
        }
        return s;
    }

    @Override
    public void labelAdded(NinaEvent q, NinaFrameReader rd, boolean accept) {
        this.vertex.accepted = accept;
    }

    @Override
    public void link(NinaEvent q, Object ver) {
        DBS v = this.vertex;
        this.vertex = ver != null ? (DBS)ver : this.createState(q);
        v.linkAlphabet(this.vertex, Double.valueOf(q.getEdge().toString()), this.parseOutput(this.output));
        this.output = null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Object getVertex() {
        return this.vertex;
    }

    @Override
    public void setVertex(Object o) {
        this.vertex = (DBS)o;
    }

    @Override
    public void doneBlockSearching(NinaEvent q) {
        this.vertex = (DBS)q.getScratch();
    }

    @Override
    public void setEdge(NinaEvent q, Object o) {
        q.setEdge(o);
    }

    @Override
    public void setEdgeCharSequence(NinaEvent q, CharSequence o, int qc) {
        q.setEdge(o);
    }

    @Override
    public void setEdgeResource(NinaEvent q, NinaParser p, String s, Map<String, String> map, NinaSubautomata sub) {
        throw new NinaException("cannotaddnfa", new Object[0]);
    }

    @Override
    public void setEdgeNFA(NinaEvent q, NinaParser p, NFA<Object, NFAState, Void> s) {
        throw new NinaException("cannotaddnfa", new Object[0]);
    }

    @Override
    public void setEdgeEnd(NinaEvent q) {
        throw new NinaException("endtransitionerror", "Markov chain");
    }

    @Override
    public NinaAction accept(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MarkovProcess getMachine() {
        return this.initial;
    }

    @Override
    public void setMealyEdge(int c) {
        char[] a = new char[]{(char)c};
        this.setMealyEdge(new String(a));
    }

    @Override
    public void setMealyEdge(Object o) {
        this.output = o != null ? o.toString() : null;
    }

    @Override
    public void setPriority(int p) {
    }

    @Override
    public void putStateByLabel(String l, Object s) {
    }

    @Override
    public Object getStateByLabel(String l) {
        return null;
    }

    @Override
    public String getLabelByState(Object s) {
        return null;
    }

    @Override
    public Object getDeadState() {
        return this.getStateByLabel("D");
    }

    @Override
    public DBS createState(NinaEvent q) {
        return new DBS();
    }

    @Override
    public void setStartState(Object o) {
        this.initial = this.vertex = (DBS)o;
    }

    @Override
    public void setUserEdge(NinaEvent q, String o) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public Set<String> getLabels() {
        return Collections.emptySet();
    }

    @Override
    public void putTypeByLabel(String l, String s) {
    }

    @Override
    public String getTypeByLabel(String l) {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setEdgeSequence(NinaEvent q, Range r, int len) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setMealyEdgeType(int c) {
    }

    @Override
    public void setAccept(boolean accept) {
        this.vertex.accepted = accept;
    }

    @Override
    public void setEdgeDynamic(NinaEvent q, String var) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public Map<String, String> getDynamicTransitMap() {
        return Collections.emptyMap();
    }

    @Override
    public void setEdgeGrammar(NinaEvent q, String name) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setEdgeRepeatedResource(NinaEvent q, String s, Object d) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public NinaAction empty(NinaEvent q, String name) {
        this.setStartState(this.createState(q));
        return this.accept(name);
    }

    @Override
    public void setEdgeDigits(NinaEvent q, int digits, boolean sign) {
        throw new NinaException("isnotfa", new Object[0]);
    }

    @Override
    public void setEdgeHexadecimal(NinaEvent q, int bits) {
        throw new NinaException("isnotfa", new Object[0]);
    }

    @Override
    public void setEdgeOctal(NinaEvent q, int bits) {
        throw new NinaException("isnotfa", new Object[0]);
    }

    @Override
    public void setEdgeFloat(NinaEvent q) {
        throw new NinaException("isnotfa", new Object[0]);
    }

    @Override
    public void setEdgeIndent(NinaEvent q, String cmp, int off) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    static class DBS
    implements MarkovProcess {
        List<Tuple2<Number, DBS>> edges = new ArrayList<Tuple2<Number, DBS>>();
        List<Object> outputs = new ArrayList<Object>();
        boolean accepted;
        double sum;

        DBS() {
        }

        void linkAlphabet(DBS d, Number o, Object l) {
            this.edges.add(new Tuple2<Number, DBS>(o, d));
            this.outputs.add(l);
            this.sum += o.doubleValue();
        }

        private Object getOutput(Object o) {
            if (o instanceof String) {
                return o;
            }
            if (o instanceof List) {
                List l = (List)o;
                int k = (int)((double)l.size() * Math.random());
                StringBuffer b = new StringBuffer();
                b.appendCodePoint((Integer)l.get(k));
                return b.toString();
            }
            return "";
        }

        @Override
        public DBS go(double r, StringBuffer b) {
            double l = 0.0;
            DBS x = null;
            int k = 0;
            while (k < this.edges.size()) {
                Tuple2<Number, DBS> e = this.edges.get(k);
                double v = e.getA().doubleValue() / this.sum;
                x = e.getB();
                if (r > l && r <= l + v) {
                    b.append(this.getOutput(this.outputs.get(k)));
                    return x;
                }
                l += v;
                ++k;
            }
            return x;
        }

        @Override
        public boolean isDead() {
            return this.edges.isEmpty();
        }

        @Override
        public boolean isAccepted() {
            return this.accepted;
        }
    }
}

