/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.io;

import java.io.IOException;

import net.morilib.awk.nano.AwkCastException;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkString;
import net.morilib.awk.nano.value.AwkValue;

/**
 * close文の中間表現です。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkClose extends AwkExpression {

	private AwkExpression file;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param file クローズするファイル名
	 */
	public AwkClose(AwkExpression file) {
		this.file = file;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.expr.AwkExpression#eval(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles)
	 */
	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		AwkValue v;

		try {
			if((v = file.eval(ns, o)).isString()) {
				o.close(v.toString(ns));
			} else {
				throw new AwkCastException("string required");
			}
			return AwkValue.TRUE;
		} catch(IOException e) {
			ns.getRoot().assign("ERRNO",
					AwkString.valueOf(e.getMessage()));
			return AwkValue.FALSE;
		}
	}

}
