/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.expr;

import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkFloat;
import net.morilib.awk.nano.value.AwkValue;

/**
 * 浮動小数定数を表す中間表現です。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkLiteralFloat extends AwkExpression {

	private double value;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param value 定数値
	 */
	public AwkLiteralFloat(double value) {
		this.value = value;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.expr.AwkExpression#eval(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles)
	 */
	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		return AwkFloat.valueOf(value);
	}

}
