/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.InputStream;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShSecurityPolicy;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/05/24
 */
public class ShSubFileSystem implements ShFileSystem {

	private ShFileSystem filesystem;
	private ShFile current;

	/**
	 * 
	 * @param fs
	 */
	public ShSubFileSystem(ShFileSystem fs) {
		filesystem = fs;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getCurrentDirectory()
	 */
	public ShFile getCurrentDirectory() {
		return current;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#setCurrentDirectory(net.morilib.sh.ShFile)
	 */
	public void setCurrentDirectory(ShFile s) {
		current = s;
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getRoot()
	 */
	public ShFile getRoot() {
		return filesystem.getRoot();
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getFile(java.lang.String)
	 */
	public ShFile getFile(String s) {
		return filesystem.getFile(s);
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getFile(java.lang.String, java.lang.String)
	 */
	public ShFile getFile(String dir, String name) {
		return filesystem.getFile(dir, name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getFile(net.morilib.sh.ShFile, net.morilib.sh.ShFile)
	 */
	public ShFile getFile(ShFile dir, String name) {
		return filesystem.getFile(dir, name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getSecurityPolicy()
	 */
	public ShSecurityPolicy getSecurityPolicy() {
		return filesystem.getSecurityPolicy();
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getProfile()
	 */
	public InputStream getProfile() {
		return filesystem.getProfile();
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getRc()
	 */
	public InputStream getRc() {
		return filesystem.getRc();
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getHome()
	 */
	public ShFile getHome() {
		return filesystem.getHome();
	}

	/* (non-Javadoc)
	 * @see net.morilib.sh.ShFileSystem#getNativeFile(java.lang.String)
	 */
	public ShFile getNativeFile(String s) {
		return filesystem.getNativeFile(s);
	}

	public ShFile searchPath(ShEnvironment env, String name) {
		return filesystem.searchPath(env, name);
	}

}
