/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.morilib.automata.DFAState;
import net.morilib.nina.DFABuilder;
import net.morilib.nina.NinaState;
import net.morilib.nina.Quadro;
import net.morilib.nina.translate.AbstractNinaTranslator;
import net.morilib.nina.translate.LRTranslator;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.sh.ReplaceStrangeChar;
import net.morilib.range.Interval;
import net.morilib.sh.ShEnvironment;

public class NinaTranslatorXML
extends AbstractNinaTranslator {
    private static final Pattern RET_CONST = Pattern.compile("return +([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*;");
    private static final Pattern E_CONST = Pattern.compile("([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*");
    private static final String LOK = "LOOKAHEAD($c);";

    public NinaTranslatorXML() {
        this.parent = this;
    }

    private int infimumbound(Interval a) {
        Object o = a.getInfimumBound();
        return o == Interval.FROM_INFIMUM ? 0 : (Integer)o;
    }

    private void printintv(PrintStream out, Interval v, Object o) {
        int c = (Integer)v.getInfimumBound();
        int d = (Integer)v.getSupremumBound();
        String z = o != null && o.toString().startsWith(LOK) ? " ignoreLookahead=\"true\"" : "";
        out.format("      <condition from=\"%d\" to=\"%d\"%s>\n", c, d, z);
    }

    private void printobj(PrintStream out, Object o, Object m) {
        String z = o != null && o.toString().startsWith(LOK) ? " ignoreLookahead=\"true\"" : "";
        out.format("      <condition equals=\"%s\"%s>\n", o.toString(), z);
    }

    private void printclass(PrintStream out, Object o, Object m) {
        String z;
        String string = z = o != null && o.toString().startsWith(LOK) ? " ignoreLookahead=\"true\"" : "";
        if (o instanceof Character) {
            out.format("      <condition equalsChar=\"%d\"%s>\n", ((Character)o).charValue(), z);
        } else {
            String s = o.toString();
            if (E_CONST.matcher(s).matches()) {
                out.format("      <condition equals=\"%s\"%s>\n", s, z);
            } else {
                out.format("      <condition instanceof=\"%s\"%s>\n", s, z);
            }
        }
    }

    private void putend(PrintStream out, DFAState<Object, ?, Void> dfa) {
        DFABuilder.DBS b;
        if (dfa instanceof DFABuilder.DBS && (b = ((DFABuilder.DBS)dfa).getEnd()) != null) {
            out.println("      <condition end=\"true\">");
            Object o = ((DFABuilder.DBS)dfa).getMealyEnd();
            if (o != null) {
                out.println("        <action><![CDATA[");
                out.println(o.toString());
                out.println("        ]]></action>");
            }
            out.format("        <goto state=\"%d\" />\n", this.getStateNo(b));
            out.println("      </condition>");
        }
    }

    private void putuseredges(PrintStream out, DFAState<Object, ?, Void> dfa) {
        Set<String> k;
        if (dfa instanceof DFABuilder.DBS && (k = ((DFABuilder.DBS)dfa).getUserEdges()) != null) {
            for (String x : k) {
                DFABuilder.DBS b = ((DFABuilder.DBS)dfa).getUserEdge(x);
                Object o = ((DFABuilder.DBS)dfa).getUserMealyEdge(x);
                out.printf("      <condition expr=\"%s\">\n", x);
                if (o != null) {
                    out.println("        <action><![CDATA[");
                    out.println(o.toString());
                    out.println("        ]]></action>");
                }
                out.format("        <goto state=\"%d\" />\n", this.getStateNo(b));
                out.println("      </condition>");
            }
        }
    }

    private void putothers(PrintStream out, DFAState<Object, ?, Void> dfa) {
        if (dfa instanceof DFABuilder.DBS) {
            DFABuilder.DBS a = (DFABuilder.DBS)dfa;
            DFABuilder.DBS b = a.getOthers();
            if (b != null) {
                out.println("      <conditionElse>");
                Object o = a.getMealyOthers();
                if (o != null) {
                    out.println("        <action><![CDATA[");
                    out.println(o.toString());
                    out.println("        ]]></action>");
                }
                out.format("        <goto state=\"%d\" />\n", this.getStateNo(b));
                out.println("      </conditionElse>");
            } else {
                b = a.getRecursive();
                if (b != null) {
                    out.println("      <conditionElse>");
                    String t = ReplaceStrangeChar.replace(a.getRecursiveName());
                    out.printf("        <call automaton=\"%s\">\n", t);
                    out.println("      </conditionElse>");
                }
            }
        }
    }

    private void printAcceptTokenState(PrintStream out, DFAState<Object, ?, Void> s) {
        int m = -1;
        if (!s.isAccepted()) {
            return;
        }
        String p = null;
        m = -1;
        for (Object a : s.getAccepted()) {
            int q;
            if (a == null || !(a instanceof NinaState) || (q = ((NinaState)a).getPriority()) < 0 || q <= m) continue;
            m = q;
        }
        for (Object a : s.getAccepted()) {
            NinaState n;
            String x;
            if (a == null || !(a instanceof NinaState) || (x = (n = (NinaState)a).getLabel()) == null || (x = x.trim()).equals("")) continue;
            if (m >= 0) {
                if (n.getPriority() != m) continue;
                p = x;
                continue;
            }
            if (RET_CONST.matcher(x).matches()) {
                p = x;
                break;
            }
            if (p != null) {
                this.getOptions().pwarn("ambiguousaccept", new Object[0]);
            }
            p = x;
        }
        if (p != null) {
            out.println("      <action><![CDATA[");
            out.println(p);
            out.println("      ]]></action>");
        }
    }

    private void printActionsStateDFA(PrintStream out, DFAState<Object, ?, Void> s) {
        String p = null;
        String x = s.toString();
        if (x != null && !(x = x.trim()).equals("")) {
            p = x;
        }
        if (p != null) {
            out.println("      <action><![CDATA[");
            out.println(p);
            out.println("      ]]></action>");
        }
    }

    private void printActionState(PrintStream out, DFAState<Object, ?, Void> s) {
        if (s instanceof DFABuilder.DBS) {
            this.printActionsStateDFA(out, s);
        } else {
            this.printAcceptTokenState(out, s);
        }
    }

    private void printStateHeader(PrintStream out, DFAState<Object, ?, Void> dfa) {
        int sn = this.getStateNo(dfa);
        String t = "";
        String s = this.builder.getLabelByState(dfa);
        if (s != null && !s.equals("")) {
            t = String.valueOf(t) + " label=\"" + s + "\"";
            if ((s = this.builder.getTypeByLabel(s)) != null && !s.equals("")) {
                t = String.valueOf(t) + " type=\"" + s + "\"";
            }
        }
        out.format("    <state name=\"%d\"%s>\n", sn, t);
    }

    private void printState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        this.printStateHeader(out, dfa);
        for (Interval v : dfa.getAlphabetRanges()) {
            if (v.isEmpty()) continue;
            int c = this.infimumbound(v);
            if (v.isInfimumOpen()) {
                ++c;
            }
            Object o = dfa.getLabelInt(c);
            this.printintv(out, v, o);
            if (o != null) {
                out.println("        <action><![CDATA[");
                out.println(o.toString());
                out.println("        ]]></action>");
            }
            out.format("        <goto state=\"%d\" />\n", this.getStateNo(dfa.goInt(c)));
            out.println("      </condition>");
        }
        this.putend(out, dfa);
        this.putuseredges(out, dfa);
        this.putothers(out, dfa);
        out.format("      <accept>%s</accept>\n", dfa.isAccepted() ? "true" : "false");
        this.printActionState(out, dfa);
        out.println("    </state>");
    }

    private void printObjectState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        this.printStateHeader(out, dfa);
        for (Object p : dfa.getAlphabets()) {
            Object o = dfa.getLabel(p);
            this.printobj(out, p, o);
            if (o != null) {
                out.println("        <action><![CDATA[");
                out.println(o.toString());
                out.println("        ]]></action>");
            }
            out.format("        <goto state=\"%d\" />\n", this.getStateNo(dfa.go(p)));
            out.println("      </condition>");
        }
        this.putend(out, dfa);
        this.putuseredges(out, dfa);
        this.putothers(out, dfa);
        out.println("    </state>");
    }

    private void printClassState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        this.printStateHeader(out, dfa);
        for (Object p : dfa.getAlphabets()) {
            Object o = dfa.getLabel(p);
            this.printclass(out, p, o);
            if (o != null) {
                out.println("        <action><![CDATA[");
                out.println(o.toString());
                out.println("        ]]></action>");
            }
            out.format("        <goto state=\"%d\" />\n", this.getStateNo(dfa.go(p)));
            out.println("      </condition>");
        }
        this.putend(out, dfa);
        this.putuseredges(out, dfa);
        this.putothers(out, dfa);
        out.println("    </state>");
    }

    private boolean isProcessed(DFAState<Object, ?, Void> state) {
        return this.containsState(state);
    }

    private int getDeadStateNo() {
        Object s = this.builder.getDeadState();
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    private int getStateNoByLabel(String l) {
        Object s = this.builder.getStateByLabel(l);
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    @Override
    public void printStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printState(out, this.popStack());
            }
        }
    }

    @Override
    public void printObjectStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printObjectState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printObjectState(out, this.popStack());
            }
        }
    }

    @Override
    public void printClassStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printClassState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printClassState(out, this.popStack());
            }
        }
    }

    @Override
    public void printAcceptStates(PrintStream out) {
    }

    @Override
    public void printAcceptToken(PrintStream out) {
    }

    @Override
    public void printActions(PrintStream out) {
    }

    @Override
    public void printImports(List<String> imp, PrintStream out) {
    }

    @Override
    public void printIsEnd(PrintStream out) {
    }

    @Override
    public void printDeadState(String n, PrintStream out) {
        int a = this.getDeadStateNo();
        if (a >= 0) {
            out.printf("    <error state=\"%d\" />\n", a);
        }
    }

    @Override
    protected void printRecover(PrintStream out) {
        out.println("    <try>");
        for (String x : this.builder.getLabels()) {
            if (!x.endsWith("Exception")) continue;
            DFAState s = (DFAState)this.builder.getStateByLabel(x);
            out.printf("      <catch exception=\"%s\" state=\"%d\" />\n", x, this.getStateNo(s));
        }
        int a = this.getStateNoByLabel("finally");
        if (a >= 0) {
            out.printf("      <finally state=\"%d\" />\n", a);
        }
        out.println("    </try>");
    }

    @Override
    public void printFinallyState(PrintStream out) {
    }

    @Override
    protected void printInitTrap(PrintStream out) {
    }

    @Override
    protected void printNFADeadState(PrintStream out) {
    }

    @Override
    protected void printAttrs(PrintStream out) {
    }

    @Override
    protected void printConstants(PrintStream out) {
        out.println("    <defines>");
        for (Map.Entry<String, Integer> t : this.quadro.getConstantMap().entrySet()) {
            out.printf("      <define name=\"%s\" value=\"%d\" />\n", t.getKey(), (int)t.getValue());
        }
        out.println("    </defines>");
    }

    @Override
    public void reportStatistics(PrintStream std) {
        this.getOptions().print("statheader", new Object[0]);
        this.getOptions().print("statstates", this.stateSize());
        this.getOptions().print("stataccept", this.acceptsSize());
    }

    @Override
    protected InputStream openScript() {
        return NinaTranslator.class.getResourceAsStream("/net/morilib/nina/translate/nina_template." + this.getMachine() + ".xml.sh");
    }

    @Override
    protected PrintStream openOutput() throws IOException {
        String s = this.getOptions().getOutputDir();
        return new PrintStream(new FileOutputStream(new File(s, String.valueOf(this.getOptions().getOutputFilename()) + ".xml")), true);
    }

    @Override
    protected AbstractNinaTranslator newPrototype() {
        NinaTranslatorXML r = new NinaTranslatorXML();
        r.quadro = this.quadro;
        return r;
    }

    @Override
    protected void appendValue(StringBuffer ot, StringBuffer b1) {
        ot.append(b1);
    }

    @Override
    protected void appendLvalue(StringBuffer ot, StringBuffer b1) {
        ot.append(b1);
    }

    @Override
    protected void appendMyPosition(StringBuffer ot, String ln, int cn) {
        ot.append(ln);
    }

    @Override
    protected void appendReturn(StringBuffer ot) {
        ot.append("$$");
    }

    @Override
    protected String getConstName(String t) {
        if (t.equals("EXIT")) {
            return "NINA_ACCEPT";
        }
        if (t.equals("FAIL")) {
            return "NINA_FAIL";
        }
        if (t.equals("ACCEPT")) {
            return "NINA_HALT_ACCEPT";
        }
        if (t.equals("REJECT")) {
            return "NINA_HALT_REJECT";
        }
        return null;
    }

    @Override
    protected void appendYield(StringBuffer ot, String b) {
        ot.append(b);
    }

    @Override
    protected LRTranslator getLRTranslator(Quadro q) {
        throw new RuntimeException();
    }

    @Override
    protected void setLocalenv(Quadro q, ShEnvironment env) {
    }
}

