/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.GrammarSymbol;
import net.morilib.automata.lr.LRAction;
import net.morilib.automata.lr.Nonterminal;
import net.morilib.automata.lr.Terminal;
import net.morilib.deculture.misc.CharacterTerminal;
import net.morilib.deculture.misc.ConstantNonterminal;
import net.morilib.deculture.misc.ConstantTerminal;
import net.morilib.deculture.misc.DecultureException;
import net.morilib.deculture.misc.SubautomatonTerminal;
import net.morilib.deculture.parser.DecultureDefinition;
import net.morilib.nina.LRObject;
import net.morilib.nina.Quadro;
import net.morilib.nina.translate.LRActionConverter;
import net.morilib.nina.translate.LRTranslator;
import net.morilib.nina.translate.sh.ShNinatBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class LRTranslatorJava
extends LRTranslator {
    private static final Pattern E_CONST = Pattern.compile("([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*");

    LRTranslatorJava(Quadro q) {
        super(q);
    }

    private SubautomatonTerminal _put(LRObject lr, Puts p, int st, GrammarSymbol g, String f, PrintStream out) {
        if (g instanceof CharacterTerminal) {
            int c = ((CharacterTerminal)g).getCharacter();
            if (c == 39 || c == 92) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\%c')) {\n", f, Character.valueOf((char)c));
            } else if (c == 10) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\n')) {\n", f);
            } else if (c == 13) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\r')) {\n", f);
            } else if (c == 9) {
                out.printf("\t\t\t\t%sif(__eq(__t, '\\t')) {\n", f);
            } else {
                out.printf("\t\t\t\t%sif(__eq(__t, '%c')) {\n", f, Character.valueOf((char)c));
            }
            p.put(out, lr, f, st, g);
        } else if (g instanceof ConstantTerminal) {
            String x = lr.getDefinition().getType(((ConstantTerminal)g).getConstant());
            if (E_CONST.matcher(x).matches()) {
                out.printf("\t\t\t\t%sif(__eq(__t, %s)) {\n", f, x);
            } else {
                out.printf("\t\t\t\t%sif(__t instanceof %s) {\n", f, x);
            }
            p.put(out, lr, f, st, g);
        } else if (g != ContextFreeGrammar.ENDMARKER) {
            throw new DecultureException(g.toString());
        }
        return null;
    }

    @Override
    public String getReturn() {
        return "$$";
    }

    @Override
    public void translateVariable(StringBuffer buf, DecultureDefinition def, Object g, int z) {
        if (g instanceof CharacterTerminal) {
            buf.append(String.format("((Character)_refv(%d))", z));
        } else if (g instanceof ConstantTerminal) {
            buf.append(String.format("((%s)_refv(%d))", def.getType(((ConstantTerminal)g).getConstant()), z));
        } else if (g == ContextFreeGrammar.ENDMARKER) {
            buf.append(String.format("(_refv(%d))", z));
        } else if (g instanceof ConstantNonterminal) {
            String s = ((ConstantNonterminal)g).getConstant();
            s = (s = def.getNonterminalType(s)) != null ? s : "Object";
            buf.append(String.format("((%s)_refv(%d))", s, z));
        } else {
            throw new DecultureException(g.toString());
        }
    }

    @Override
    public void setCommands(ShNinatBuiltInCommands c) {
        c.putCommand("put_shift", new PutShift());
        c.putCommand("put_reduce", new PutReduce());
        c.putCommand("put_accept", new PutAccept());
        c.putCommand("put_goto", new PutGoto());
        c.putCommand("put_grammar_initial", new PutGrammarInitial());
        c.putCommand("cat_definition", new CatDefinitionPart());
        c.putCommand("echo_lexer", new LRTranslator.EchoLexer(this));
    }

    private class CatDefinitionPart
    implements ShProcess {
        private CatDefinitionPart() {
        }

        @Override
        public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
            LRObject lr = LRTranslatorJava.this.getlr(args);
            out.println(lr.getDefinition().getDefinition());
            return 0;
        }
    }

    private class PutAccept
    extends Puts {
        private PutAccept() {
        }

        @Override
        boolean isput(LRObject lr, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            return a.isAccept();
        }

        @Override
        void put(PrintStream out, LRObject lr, String f, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            if (a.isAccept()) {
                out.printf("\t\t\t\t\treturn true;\n", new Object[0]);
            }
        }

        @Override
        void end(PrintStream out, LRObject lr, int st, SubautomatonTerminal g) {
            out.printf("\t\t\t\t\treturn false;\n", new Object[0]);
        }
    }

    private class PutGoto
    implements ShProcess {
        private PutGoto() {
        }

        @Override
        public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream out, PrintStream stderr, String ... args) throws IOException {
            LRObject lr = LRTranslatorJava.this.getlr(args);
            int k = 0;
            while (k < lr.getTable().getSizeOfStates()) {
                out.printf("\t\t\tcase %d:\n", k);
                Set<Map.Entry<Nonterminal, Integer>> s = lr.getTable().goTos(k).entrySet();
                String f = "";
                for (Map.Entry<Nonterminal, Integer> e : s) {
                    int n = lr.getNonterminalNumber(e.getKey());
                    out.printf("\t\t\t\t%sif(__n == %d) {\n", f, n);
                    out.printf("\t\t\t\t\treturn %d;\n", e.getValue());
                    f = "} else ";
                }
                if (!f.equals("")) {
                    out.printf("\t\t\t\t}\n", new Object[0]);
                }
                out.printf("\t\t\t\tthrow new RuntimeException();\n", new Object[0]);
                ++k;
            }
            return 0;
        }
    }

    private class PutGrammarInitial
    implements ShProcess {
        private PutGrammarInitial() {
        }

        @Override
        public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
            LRObject lr = LRTranslatorJava.this.getlr(args);
            int s = lr.getStartNumber();
            out.printf("\t\t\t\tSTATE = %d << LRSTATESHIFT;\n", s);
            out.printf("\t\t\t\t__synarray[0] = %d << LRSTATESHIFT;\n", s);
            return 0;
        }
    }

    private class PutReduce
    extends Puts {
        private PutReduce() {
        }

        @Override
        boolean isput(LRObject lr, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            return a.isReduce();
        }

        @Override
        void put(PrintStream out, LRObject lr, String f, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            if (!a.isReduce()) {
                return;
            }
            ContextFreeRule r = a.getReduceRule();
            int l = r.getDerivedSymbolLength();
            Object o = lr.getActionMap().get(a.getReduceRule());
            if (o != null) {
                out.printf("\t\t\t\t\t$$ = null;\n", l);
                String s = LRActionConverter.translate(r, lr.getDefinition(), o.toString(), LRTranslatorJava.this);
                out.printf("\t\t\t\t\t%s\n", s);
            } else if (l > 0) {
                String s = LRActionConverter.translate(r, lr.getDefinition(), "$$ = $1;", LRTranslatorJava.this);
                out.printf("\t\t\t\t\t%s\n", s);
            } else {
                out.printf("\t\t\t\t\t$$ = null;\n", l);
            }
            out.printf("\t\t\t\t\t_pop(%d);\n", l);
            out.printf("\t\t\t\t\t__k = getGoto(_refsyn(), %d);\n", lr.getNonterminalNumber(r.getLeftSymbol()));
            out.printf("\t\t\t\t\t_push(__k, $$);\n", new Object[0]);
            out.printf("\t\t\t\t\treturn __k;\n", new Object[0]);
        }

        @Override
        void end(PrintStream out, LRObject lr, int st, SubautomatonTerminal g) {
            out.printf("\t\t\t\t\treturn -1;\n", new Object[0]);
        }
    }

    private class PutShift
    extends Puts {
        private PutShift() {
        }

        @Override
        boolean isput(LRObject lr, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            return a.isShift();
        }

        @Override
        void put(PrintStream out, LRObject lr, String f, int st, GrammarSymbol g) {
            LRAction a = lr.getTable().action(st, (Terminal)g);
            if (a.isShift()) {
                out.printf("\t\t\t\t\treturn %d;\n", a.getNextStateID());
            }
        }

        @Override
        void end(PrintStream out, LRObject lr, int st, SubautomatonTerminal g) {
            if (g == null) {
                out.printf("\t\t\t\t\treturn -1;\n", new Object[0]);
            } else {
                LRAction a = lr.getTable().action(st, g);
                if (a.isShift()) {
                    out.printf("\t\t\t\t__stkpush(%d, ENGINE_%s);\n", a.getNextStateID(), g.getSubautomaton());
                    out.printf("\t\t\t\t\treturn %d;\n", -(a.getNextStateID() + 2));
                } else {
                    out.printf("\t\t\t\t\treturn -1;\n", new Object[0]);
                }
            }
        }
    }

    private abstract class Puts
    implements ShProcess {
        private Puts() {
        }

        abstract boolean isput(LRObject var1, int var2, GrammarSymbol var3);

        abstract void put(PrintStream var1, LRObject var2, String var3, int var4, GrammarSymbol var5);

        abstract void end(PrintStream var1, LRObject var2, int var3, SubautomatonTerminal var4);

        @Override
        public int main(ShEnvironment env, ShFileSystem fs, InputStream stdin, PrintStream stdout, PrintStream stderr, String ... args) throws IOException {
            LRObject lr = LRTranslatorJava.this.getlr(args);
            int k = 0;
            while (k < lr.getTable().getSizeOfStates()) {
                stdout.printf("\t\t\tcase %d:\n", k);
                Set<Map.Entry<GrammarSymbol, LRAction>> s = lr.getTable().actions(k).entrySet();
                String f = "";
                SubautomatonTerminal g = null;
                GrammarSymbol l = null;
                for (Map.Entry<GrammarSymbol, LRAction> e : s) {
                    if (!this.isput(lr, k, e.getKey())) continue;
                    if (e.getKey() == ContextFreeGrammar.ENDMARKER) {
                        l = e.getKey();
                        continue;
                    }
                    SubautomatonTerminal h = LRTranslatorJava.this._put(lr, this, k, e.getKey(), f, stdout);
                    f = h != null ? f : "} else ";
                    SubautomatonTerminal subautomatonTerminal = g = h != null ? h : g;
                }
                if (l != null) {
                    stdout.printf("\t\t\t\t%s{\n", f);
                    this.put(stdout, lr, f, k, l);
                    stdout.printf("\t\t\t\t}\n", new Object[0]);
                } else {
                    if (!f.equals("")) {
                        stdout.printf("\t\t\t\t}\n", new Object[0]);
                    }
                    this.end(stdout, lr, k, g);
                }
                ++k;
            }
            return 0;
        }
    }
}

