/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.interpret;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.morilib.nina.NinaConsole;
import net.morilib.nina.cmd.NinaInfo;
import net.morilib.nina.cmd.NinatOptions;
import net.morilib.nina.translate.NinaTranslatorJavaScript;

public class NinaScript {
    private static ResourceBundle msgs = NinatOptions.getMessages();
    private final NinaInfo info = new NinaInfo(){

        @Override
        public void print(String p, Object ... a) {
            NinaScript.this.out.format(msgs.getString(p), a);
            NinaScript.this.out.println();
        }

        @Override
        public void perror(String p, Object ... a) {
            NinaScript.this.out.print(msgs.getString("errorheader"));
            NinaScript.this.out.format(msgs.getString(p), a);
            NinaScript.this.out.println();
        }

        @Override
        public void pwarn(String p, Object ... a) {
            NinaScript.this.out.print(msgs.getString("warnheader"));
            NinaScript.this.out.format(msgs.getString(p), a);
            NinaScript.this.out.println();
        }

        @Override
        public void pmessage(String p) {
            NinaScript.this.out.print(msgs.getString("errorheader"));
            NinaScript.this.out.println(p);
        }

        @Override
        public String getOutputFilename() {
            return "script";
        }

        @Override
        public String getFilename() {
            return "script";
        }

        @Override
        public String getClassName() {
            return "script";
        }

        @Override
        public String getBufSize() {
            return "1024";
        }

        @Override
        public File getTitleFile(String s) {
            return null;
        }

        @Override
        public String getOutputDir() {
            return "";
        }

        @Override
        public NinaConsole getConsole() {
            return this;
        }
    };
    private PrintWriter out = new PrintWriter(new StringWriter());
    private CompiledScript js;
    private Bindings bind = new SimpleBindings();

    private NinaScript() {
    }

    public static NinaScript newInstance(Reader rd) throws IOException, ScriptException {
        NinaScript sc = new NinaScript();
        NinaTranslatorJavaScript nt = new NinaTranslatorJavaScript();
        ByteArrayOutputStream ot = new ByteArrayOutputStream();
        PrintStream pt = new PrintStream(ot, true);
        nt.translate("script", rd, sc.info, Collections.emptyList(), new HashMap<String, String>(), pt);
        ScriptEngineManager mn = new ScriptEngineManager();
        ScriptEngine en = mn.getEngineByName("javascript");
        sc.js = ((Compilable)((Object)en)).compile(ot.toString());
        return sc;
    }

    public static NinaScript newInstance(String s) throws ScriptException {
        try {
            return NinaScript.newInstance(new StringReader(s));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object eval(Reader rd) throws ScriptException, IOException {
        return NinaScript.newInstance(rd).eval();
    }

    public static Object eval(String s) throws ScriptException {
        return NinaScript.newInstance(s).eval();
    }

    public void bind(String name, Object o) {
        this.bind.put(name, o);
    }

    public Object eval() throws ScriptException {
        return this.js.eval(this.bind);
    }
}

