/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.List;
import net.morilib.lisp.nano.CodeExecutor;
import net.morilib.lisp.nano.CompiledCode;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.IntStack;
import net.morilib.lisp.nano.LispCompiler;
import net.morilib.lisp.nano.LispException;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispVector;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.Symbol;
import net.morilib.lisp.nano.Syntax;
import net.morilib.lisp.nano.SyntaxUtils;

public class SynQuasiquote
extends Syntax {
    private static Datum getCaar(Cons c) {
        if (c.getCar() instanceof Cons) {
            return ((Cons)c.getCar()).getCar();
        }
        return null;
    }

    boolean equalsQuasiquote(Datum d) {
        return SyntaxUtils.equalsReserved(Symbol.QUASIQUOTE, d);
    }

    boolean equalsUnquote(Datum d) {
        return SyntaxUtils.equalsReserved(Symbol.UNQUOTE, d);
    }

    boolean equalsUnquoteSplicing(Datum d) {
        return SyntaxUtils.equalsReserved(Symbol.UNQUOTE_SPLICING, d);
    }

    LispException error(LispMessage mesg) {
        return mesg.getError("err.quasiquote.malform");
    }

    @Override
    public String toString() {
        return "Syntax:quasiquote";
    }

    private void quote1(int level, Cons c, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        if (!(c.getCdr() instanceof Cons)) {
            throw this.error(mesg);
        }
        Cons c2 = (Cons)c.getCdr();
        build.addBeginList();
        build.addPush(c.getCar());
        build.addAppendList();
        this.expand(level, c2.getCar(), env, comp, build, callsym, mesg, symlist, exec, memento);
        build.addAppendList();
        build.addEndList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void expand(int level, Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        if (body instanceof Cons) {
            Datum caar;
            Cons c = (Cons)body;
            if (this.equalsQuasiquote(c.getCar())) {
                this.quote1(level + 1, c, env, comp, build, callsym, mesg, symlist, exec, memento);
                return;
            }
            if (this.equalsUnquote(c.getCar())) {
                Cons c2;
                Cons c3 = c2 = (Cons)c.getCdr();
                int zi = 0;
                if (level > zi) {
                    this.quote1(level - 1, c, env, comp, build, callsym, mesg, symlist, exec, memento);
                    return;
                } else {
                    if (!(c.getCdr() instanceof Cons)) throw this.error(mesg);
                    comp.compile(c3.getCar(), env, build, callsym, false, symlist, exec, memento);
                }
                return;
            }
            if (this.equalsUnquoteSplicing(c.getCar())) {
                if (level > 0) {
                    this.quote1(level - 1, c, env, comp, build, callsym, mesg, symlist, exec, memento);
                    return;
                } else {
                    if (!(c.getCdr() instanceof Cons)) throw this.error(mesg);
                    Cons c2 = (Cons)c.getCdr();
                    comp.compile(c2.getCar(), env, build, callsym, false, symlist, exec, memento);
                }
                return;
            }
            build.addBeginList();
            while (true) {
                caar = SynQuasiquote.getCaar(c);
                this.expand(level, c.getCar(), env, comp, build, callsym, mesg, symlist, exec, memento);
                if (!(c.getCdr() instanceof Cons)) break;
                Cons c2 = (Cons)c.getCdr();
                Datum d2 = c2.getCar();
                if (this.equalsUnquote(d2)) {
                    if (this.equalsUnquoteSplicing(caar)) {
                        build.addAppendListSplicing();
                    } else {
                        build.addAppendList();
                    }
                    this.expand(level, c.getCdr(), env, comp, build, callsym, mesg, symlist, exec, memento);
                    build.addEndListDot();
                    return;
                }
                if (this.equalsUnquoteSplicing(d2)) {
                    throw this.error(mesg);
                }
                if (level == 0 && this.equalsUnquoteSplicing(caar)) {
                    build.addAppendListSplicing();
                    c = (Cons)c.getCdr();
                    continue;
                }
                build.addAppendList();
                c = (Cons)c.getCdr();
            }
            if (c.getCdr() == Nil.NIL) {
                if (level == 0 && this.equalsUnquoteSplicing(caar)) {
                    build.addEndListDot();
                    return;
                } else {
                    build.addAppendList();
                    build.addEndList();
                }
                return;
            } else {
                if (level == 0 && this.equalsUnquoteSplicing(caar)) {
                    build.addAppendListSplicing();
                } else {
                    build.addAppendList();
                }
                this.expand(level, c.getCdr(), env, comp, build, callsym, mesg, symlist, exec, memento);
                build.addEndListDot();
            }
            return;
        }
        if (body instanceof LispVector) {
            LispVector v = (LispVector)body;
            build.addBeginList();
            int i = 0;
            while (i < v.size()) {
                this.expand(level, v.get(i), env, comp, build, callsym, mesg, symlist, exec, memento);
                if (v.get(i) instanceof Cons) {
                    Cons cz = (Cons)v.get(i);
                    if (this.equalsUnquoteSplicing(cz.getCar())) {
                        build.addAppendListSplicing();
                    } else {
                        build.addAppendList();
                    }
                } else {
                    build.addAppendList();
                }
                ++i;
            }
            build.addEndListVector();
            return;
        } else {
            build.addPush(body);
        }
    }

    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        if (!(body instanceof Cons)) {
            throw this.error(mesg);
        }
        this.expand(0, ((Cons)body).getCar(), env, comp, build, callsym, mesg, symlist, exec, memento);
    }
}

