/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.statement;

import net.morilib.awk.nano.AwkBreakException;
import net.morilib.awk.nano.AwkContinueException;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.statement.AwkExpressionMachine;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkDoWhile
extends AwkExpression {
    private AwkExpression cond;
    private AwkExpression stmt;

    public AwkDoWhile(AwkExpression cond, AwkExpression stmt) {
        this.cond = cond;
        this.stmt = stmt;
    }

    @Override
    public AwkValue eval(AwkNamespace ns, AwkFiles o) {
        AwkValue v = AwkUndefined.UNDEF;
        try {
            do {
                try {
                    v = this.stmt.eval(ns, o);
                }
                catch (AwkContinueException awkContinueException) {
                    // empty catch block
                }
            } while (this.cond.eval(ns, o).toBoolean(ns));
        }
        catch (AwkBreakException awkBreakException) {
            // empty catch block
        }
        return v;
    }

    @Override
    public void compileInternally(AwkExpressionMachine.Builder b, Object brk, Object cnt) {
        Object r = new Object();
        Object l = new Object();
        Object c = new Object();
        b.addLabel(l);
        this.stmt.compileInternally(b, r, c);
        b.addLabel(c);
        b.add(this.cond);
        b.addJmpNZ(l);
        b.addLabel(r);
    }
}

