/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.morilib.awk.nano.AwkExitException;
import net.morilib.awk.nano.AwkNextException;
import net.morilib.awk.nano.builtin.AwkBuiltInLoader;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.io.RecordReader;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.namespace.AwkRootNamespace;
import net.morilib.awk.nano.parser.AwkLexer;
import net.morilib.awk.nano.parser.AwkParser;
import net.morilib.awk.nano.statement.AwkProgram;
import net.morilib.awk.nano.value.AwkArray;
import net.morilib.awk.nano.value.AwkInteger;
import net.morilib.awk.nano.value.AwkString;
import net.morilib.awk.nano.value.AwkValue;

public final class Awk {
    private static final Awk _INS = new Awk();
    public static final String VERSION = "0.2.3";

    private Awk() {
    }

    public static Awk getInstance() {
        return _INS;
    }

    public static AwkNamespace newNamespace(String filename, String ... args) {
        AwkRootNamespace r = new AwkRootNamespace();
        AwkBuiltInLoader.load(r);
        r.assign("FILENAME", AwkString.valueOf(filename));
        r.assign("ARGC", AwkInteger.valueOf(args.length));
        r.assign("ARGV", new AwkArray(0, args));
        AwkArray a = new AwkArray();
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            ((AwkValue)a).putArray(e.getKey(), AwkString.valueOf(e.getValue()));
        }
        r.assign("ENVIRON", a);
        a = new AwkArray();
        for (Object o : System.getProperties().keySet()) {
            String s = o.toString();
            ((AwkValue)a).putArray(s, AwkString.valueOf(System.getProperty(s)));
        }
        r.assign("PROPERTIES", a);
        return r;
    }

    public AwkProgram compile(AwkNamespace namespace, Reader source) throws IOException {
        AwkLexer l = new AwkLexer(source);
        AwkProgram p = AwkParser.parse(namespace, l);
        return p;
    }

    public AwkValue execute(AwkNamespace namespace, AwkFiles f, AwkProgram program, String ... args) throws IOException {
        String rs = namespace != null ? namespace.getRS() : "\n";
        RecordReader rd = f.getStdin();
        try {
            if (!program.isExecuteOnce()) {
                String s;
                while ((s = rd.readRecord(rs)) != null) {
                    try {
                        program.execute(namespace, f, s);
                    }
                    catch (AwkNextException awkNextException) {
                        f.getStdout().flush();
                        f.getStderr().flush();
                        continue;
                    }
                    catch (AwkExitException e) {
                        try {
                            program.executeEnd(namespace, f);
                            AwkValue awkValue = e.getValue();
                            if (f != null) {
                                f.closeAll();
                            }
                            return awkValue;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            f.getStdout().flush();
                            f.getStderr().flush();
                        }
                    }
                    f.getStdout().flush();
                    f.getStderr().flush();
                }
            }
            AwkInteger awkInteger = AwkInteger.ZERO;
            return awkInteger;
        }
        finally {
            if (f != null) {
                f.closeAll();
            }
        }
    }
}

