/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.lr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.lr.Associativity;
import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.GrammarSymbol;
import net.morilib.automata.lr.LALR1Items;
import net.morilib.automata.lr.LR1Table;
import net.morilib.automata.lr.LRAction;
import net.morilib.automata.lr.LRConflict;
import net.morilib.automata.lr.Nonterminal;
import net.morilib.automata.lr.ObjectArray;
import net.morilib.automata.lr.Terminal;
import net.morilib.deculture.misc.PrecedenceTerminal;

public class LALR1Table
implements LR1Table {
    private LALR1Items goTo;
    List<Map<GrammarSymbol, LRAction>> actionTable;
    List<Map<Nonterminal, Integer>> goToTable;
    List<LRConflict> conflicts;
    private Map<Terminal, Integer> prior;
    private Map<Terminal, Associativity> assoc;

    public LALR1Table(LALR1Items goTo, Map<Terminal, Integer> priority, Map<Terminal, Associativity> assoc) {
        this.goTo = goTo;
        this.prior = priority;
        this.assoc = assoc;
        this.computeTable();
    }

    private <T, S> List<Map<T, S>> allocateMap(int size) {
        ObjectArray<Map<T, S>> res = new ObjectArray<Map<T, S>>(size);
        int i = 0;
        while (i < size) {
            res.set(i, new HashMap());
            ++i;
        }
        return res;
    }

    private void _addShiftReduce(Object k, ContextFreeRule r) {
        LRConflict cnf = LRConflict.newShiftReduce(k, r);
        this.conflicts.add(cnf);
    }

    private void _addReduceReduce(ContextFreeRule k, ContextFreeRule r) {
        LRConflict cnf = LRConflict.newReduceReduce(k, r);
        this.conflicts.add(cnf);
    }

    private Integer getprior(Terminal t) {
        Integer x = t instanceof PrecedenceTerminal ? this.prior.get(((PrecedenceTerminal)t).getPrecedence()) : this.prior.get(t);
        return x;
    }

    private Integer getprior(ContextFreeRule r) {
        GrammarSymbol z;
        Integer x = r.getDerivedSymbolLength() == 3 ? ((z = r.getDerivedSymbol(1)) instanceof Terminal ? this.getprior((Terminal)z) : null) : (r.getDerivedSymbolLength() != 2 ? null : ((z = r.getDerivedSymbol(0)) instanceof Terminal ? this.getprior((Terminal)z) : ((z = r.getDerivedSymbol(1)) instanceof Terminal ? this.getprior((Terminal)z) : null)));
        return x;
    }

    void computeTable() {
        ContextFreeGrammar grammar = this.goTo.getGrammar();
        this.conflicts = new ArrayList<LRConflict>();
        this.actionTable = this.allocateMap(this.goTo.getSizeOfStates());
        this.goToTable = this.allocateMap(this.goTo.getSizeOfStates());
        int i = 0;
        while (i < this.goTo.getSizeOfStates()) {
            Set<LALR1Items.Item> items = this.goTo.getItems(i);
            Map<GrammarSymbol, LRAction> ctable = this.actionTable.get(i);
            for (LALR1Items.Item item : items) {
                LRAction act;
                if (item.isReduceState()) {
                    ContextFreeRule rule = item.getRule();
                    if (rule.equals(grammar.getAugmentRule())) {
                        ctable.put(ContextFreeGrammar.ENDMARKER, LRAction.newAccept());
                        continue;
                    }
                    Set<Terminal> follow = item.getLookaheadSet();
                    for (Terminal k : follow) {
                        act = ctable.get(k);
                        if (act == null) {
                            ctable.put(k, LRAction.newReduce(k, rule));
                            continue;
                        }
                        if (!act.isShift()) {
                            this._addReduceReduce(rule, act.getReduceRule());
                            continue;
                        }
                        Integer a = this.getprior(k);
                        if (a == null) {
                            this._addShiftReduce(k, rule);
                            continue;
                        }
                        Integer b = this.getprior(rule);
                        if (b == null) {
                            this._addShiftReduce(k, rule);
                            continue;
                        }
                        if (a > b) continue;
                        if (a < b) {
                            ctable.put(k, LRAction.newReduce(k, rule));
                            continue;
                        }
                        if (this.assoc.get(k) == Associativity.LEFT) {
                            ctable.put(k, LRAction.newReduce(k, rule));
                            continue;
                        }
                        if (this.assoc.get(k) == Associativity.RIGHT) continue;
                        this._addShiftReduce(k, rule);
                    }
                    continue;
                }
                GrammarSymbol symbol = item.getDirectedSymbol();
                int nextid = this.goTo.goToID(i, symbol);
                if (symbol instanceof Terminal) {
                    act = ctable.get(symbol);
                    Terminal t = (Terminal)symbol;
                    if (act == null) {
                        ctable.put(t, LRAction.newShift(t, nextid));
                        continue;
                    }
                    if (act.isShift()) continue;
                    Integer a = this.getprior(t);
                    if (a == null) {
                        this._addShiftReduce(t, act.getReduceRule());
                        continue;
                    }
                    Integer b = this.getprior(act.getReduceRule());
                    if (b == null) {
                        this._addShiftReduce(t, act.getReduceRule());
                        continue;
                    }
                    if (a > b) {
                        ctable.put(t, LRAction.newShift(t, nextid));
                        continue;
                    }
                    if (a < b || this.assoc.get(act.getSymbol()) == Associativity.LEFT) continue;
                    if (this.assoc.get(act.getSymbol()) == Associativity.RIGHT) {
                        ctable.put(t, LRAction.newShift(t, nextid));
                        continue;
                    }
                    this._addShiftReduce(t, act.getReduceRule());
                    continue;
                }
                if (!(symbol instanceof Nonterminal)) continue;
                this.goToTable.get(i).put((Nonterminal)symbol, nextid);
            }
            ++i;
        }
    }

    public static LALR1Table create(ContextFreeGrammar g, Map<Terminal, Integer> priority, Map<Terminal, Associativity> assoc) {
        LALR1Items m = LALR1Items.newLALR(g);
        LALR1Table t = new LALR1Table(m, priority, assoc);
        return t;
    }

    @Override
    public int getSizeOfStates() {
        return this.goTo.getSizeOfStates();
    }

    @Override
    public LRAction action(int stateID, Terminal terminal) {
        return this.actionTable.get(stateID).get(terminal);
    }

    @Override
    public Map<GrammarSymbol, LRAction> actions(int stateID) {
        return Collections.unmodifiableMap(this.actionTable.get(stateID));
    }

    @Override
    public int goTo(int stateID, Nonterminal nonterminal) {
        return this.goToTable.get(stateID).get(nonterminal);
    }

    @Override
    public Map<Nonterminal, Integer> goTos(int stateID) {
        return Collections.unmodifiableMap(this.goToTable.get(stateID));
    }

    @Override
    public int getInitialStateID() {
        return this.goTo.getInitialStateID();
    }

    @Override
    public Collection<LRConflict> getConflicts() {
        return Collections.unmodifiableCollection(this.conflicts);
    }
}

