(define (display1 disp-obj b x)
  (define (display-list d x)
    (if (null? x)
        (display-object b ")")
        (if (pair? x)
            (begin
              (display-object b d)
              (display1 disp-obj b (car x))
              (display-list " " (cdr x)))
            (begin
              (display-object b " . ")
              (disp-obj b x)))))
  (define (display-vec d x k l)
    (if (eqv? k l)
        (display-object b ")")
        (begin
          (display-object b d)
          (display1 disp-obj b (vector-ref x k))
          (display-vec " " x (+ k 1) l))))
  (if (pair? x)
      (display-list "(" x)
      (if (vector? x)
          (display-vec "#(" x 0 (vector-length x))
          (disp-obj b x))))

(define (display-all b x) (display1 display-object b x))
(define (write-all b x)   (display1 write-object b x))
; END
