/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.nano.ClosureClass;
import net.morilib.lisp.nano.CodeExecutor;
import net.morilib.lisp.nano.CompiledCode;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.IntStack;
import net.morilib.lisp.nano.LispCompiler;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.SymbolName;
import net.morilib.lisp.nano.Syntax;
import net.morilib.lisp.nano.SyntaxUtils;
import net.morilib.lisp.nano.Undef;

public class SynLetrec
extends Syntax {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        Environment nenv;
        Datum bcdr;
        CompiledCode.Builder nbuild;
        if (body instanceof Cons) {
            nbuild = new CompiledCode.Builder();
            Datum bcar = ((Cons)body).getCar();
            bcdr = ((Cons)body).getCdr();
            nenv = new Environment(env);
            if (bcar instanceof Cons) {
                Datum d = bcar;
                while (d != Nil.NIL) {
                    if (d instanceof Cons) {
                        Datum d3c;
                        Cons d3;
                        Datum d2 = ((Cons)d).getCar();
                        if (d2 instanceof Cons) {
                            d3 = (Cons)d2;
                            d3c = d3.getCar();
                            if (!(d3c instanceof SymbolName)) {
                                throw mesg.getError("err.letrec.malform");
                            }
                        } else {
                            throw mesg.getError("err.letrec.malform");
                        }
                        SyntaxUtils.compileBind(d3c, d3.getCdr(), env, comp, nbuild, new Cons(), false, mesg, "err.letrec.malform", new ArrayList<Cons>(), exec, memento);
                        nbuild.addPop();
                        nenv.bindDatumWithoutScope(d3c, Undef.UNDEF);
                        d = ((Cons)d).getCdr();
                        continue;
                    }
                    throw mesg.getError("err.letrec.malform");
                }
            } else if (bcar != Nil.NIL) {
                throw mesg.getError("err.letrec.malform");
            }
        } else {
            throw mesg.getError("err.letrec.malform");
        }
        symlist.add(callsym);
        SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, new Cons(), istail, mesg, symlist, exec, memento);
        symlist.remove(0);
        nbuild.addReturnOp();
        ClosureClass cl = new ClosureClass(Nil.NIL, nbuild.getCodeRef());
        build.addPush(cl);
        build.addBeginList();
        build.addEndList();
        build.addCall();
    }
}

