/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.java6;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.morilib.awk.nano.AwkException;
import net.morilib.awk.nano.expr.AwkExpression;
import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.java6.AwkCompiledScript;
import net.morilib.awk.nano.java6.AwkScriptContext;
import net.morilib.awk.nano.java6.AwkScriptEngineFactory;
import net.morilib.awk.nano.namespace.AwkClosureNamespace;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.parser.AwkLexer;
import net.morilib.awk.nano.parser.AwkParser;
import net.morilib.awk.nano.value.AwkClass;
import net.morilib.awk.nano.value.AwkFunction;
import net.morilib.awk.nano.value.AwkValue;

public class AwkScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private AwkScriptContext context;
    private AwkNamespace global;
    private AwkNamespace engine;
    private AwkScriptEngineFactory factory;

    AwkScriptEngine(AwkNamespace g, AwkScriptEngineFactory f) {
        this.global = g;
        this.engine = new AwkClosureNamespace(g);
        this.context = new AwkScriptContext(g, this.engine);
        this.factory = f;
    }

    @Override
    protected ScriptContext getScriptContext(Bindings nn) {
        AwkScriptContext c = new AwkScriptContext(this.global, new AwkClosureNamespace(this.engine));
        c.setReader(new InputStreamReader(System.in));
        c.setWriter(new OutputStreamWriter(System.out));
        c.setErrorWriter(new OutputStreamWriter(System.err));
        c.setBindings(nn, 100);
        return c;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        AwkFiles f = new AwkFiles(context.getReader(), context.getWriter(), context.getErrorWriter());
        try {
            AwkLexer l = new AwkLexer(reader);
            AwkExpression p = AwkParser.parseStatement(this.engine, l);
            p = p.compileInternally();
            AwkValue r = p.eval(this.engine, f);
            return r.toObject();
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (AwkException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        try {
            AwkLexer l = new AwkLexer(script);
            AwkExpression p = AwkParser.parseStatement(this.engine, l);
            p = p.compileInternally();
            return new AwkCompiledScript(p, this);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (AwkException e) {
            throw new ScriptException(e);
        }
    }

    private List<AwkValue> toList(Object ... args) {
        ArrayList<AwkValue> l = new ArrayList<AwkValue>();
        int k = 0;
        while (k < l.size()) {
            l.add(AwkScriptContext.toAwkValue(args[k]));
            ++k;
        }
        return l;
    }

    @Override
    public Object invokeMethod(Object dieser, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (!(dieser instanceof AwkClass)) {
            throw new NoSuchMethodException();
        }
        AwkClass c = (AwkClass)dieser;
        AwkNamespace s = c.getNamespace();
        AwkFunction f = s.findFunction(name);
        if (f == null) {
            throw new NoSuchMethodException();
        }
        AwkFiles o = new AwkFiles(this.context.getReader(), this.context.getWriter(), this.context.getErrorWriter());
        return f.apply(s, o, this.toList(args));
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        AwkFunction f = this.engine.findFunction(name);
        if (f == null) {
            throw new NoSuchMethodException();
        }
        AwkFiles o = new AwkFiles(this.context.getReader(), this.context.getWriter(), this.context.getErrorWriter());
        return f.apply(this.engine, o, this.toList(args));
    }

    @Override
    public <T> T getInterface(Class<T> klasse) {
        throw new IllegalArgumentException();
    }

    @Override
    public <T> T getInterface(Object dieser, Class<T> klasse) {
        throw new IllegalArgumentException();
    }
}

