/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import net.morilib.automata.nfa.NFAAccept;
import net.morilib.automata.nfa.NFAAlternative;
import net.morilib.automata.nfa.NFAConcatenation;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAOptional;
import net.morilib.automata.nfa.NFARepetition;
import net.morilib.automata.nfa.RegexParseException;
import net.morilib.automata.nfa.SingleSetNFA;
import net.morilib.range.CharSets;
import net.morilib.range.Interval;
import net.morilib.range.Range;

public class RegexpParser<T, A, B> {
    private int state;
    private int unread = -1;
    private Stack<NFAObject<T, A, B>> stk = new Stack();
    private Stack<Boolean> ors = new Stack();
    private StringBuffer chs = new StringBuffer();
    private NFAObject<T, A, B> nxt = null;
    private boolean orf = false;

    private NFAObject<T, A, B> mkor(NFAObject<T, A, B> b, NFAObject<T, A, B> a) {
        return NFAAlternative.newInstance(a, b);
    }

    private NFAObject<T, A, B> mkcat(NFAObject<T, A, B> a, NFAObject<T, A, B> b) {
        if (a == null) {
            return b;
        }
        return NFAConcatenation.newInstance(a, b);
    }

    private NFAObject<T, A, B> mkcls(NFAObject<T, A, B> a, int c) {
        switch (c) {
            case 42: {
                return NFARepetition.newInstance(a, true);
            }
            case 43: {
                return NFARepetition.newInstance(a, false);
            }
            case 63: {
                return NFAOptional.newInstance(a);
            }
        }
        throw new RuntimeException();
    }

    private void doorf() {
        if (this.orf) {
            this.stk.push(this.mkor(this.stk.pop(), this.stk.pop()));
        }
    }

    private void donxt() {
        if (this.nxt != null) {
            this.stk.push(this.mkcat(this.stk.pop(), this.nxt));
            this.nxt = null;
        }
    }

    private void addor(int c) {
        this.donxt();
        if (c == 40) {
            this.stk.push(null);
            this.ors.push(this.orf);
        } else if (c == 124) {
            this.doorf();
            this.stk.push(null);
        }
        this.orf = c == 124;
    }

    private void addre(int c) {
        this.donxt();
        if (c == 41) {
            this.doorf();
            this.orf = this.ors.pop();
            this.nxt = this.stk.pop();
        } else if (c == 93) {
            Range r = CharSets.parse(this.chs.substring(1));
            this.chs = new StringBuffer();
            this.nxt = SingleSetNFA.newInstance(r);
        } else {
            Interval r = Interval.newPoint(c);
            this.nxt = SingleSetNFA.newInstance(r);
        }
    }

    private void addcl(int c) {
        if (this.nxt != null) {
            this.stk.push(this.mkcat(this.stk.pop(), this.mkcls(this.nxt, c)));
            this.nxt = null;
        } else {
            this.stk.push(this.mkcls(this.stk.pop(), c));
        }
    }

    private void addbuf(int c) {
        this.chs.appendCodePoint(c);
    }

    public static <T, A, B> NFAObject<T, A, B> parse(String rd) throws RegexParseException {
        try {
            RegexpParser<T, A, B> x = new RegexpParser<T, A, B>();
            x.stk.push(null);
            super._parse(new StringReader(rd));
            super.donxt();
            super.doorf();
            if (x.stk.size() != 1) {
                throw new RegexParseException();
            }
            return NFAAccept.newInstance(x.stk.pop(), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int _read(Reader rd) throws IOException {
        if (this.unread < 0) {
            return rd.read();
        }
        int c = this.unread;
        this.unread = -1;
        return c;
    }

    private boolean _step(int c) {
        switch (this.state) {
            case 0: {
                if (c >= 0 && c <= 39) {
                    this.state = 1;
                    return true;
                }
                if (c >= 40 && c <= 40) {
                    this.state = 0;
                    return true;
                }
                if (c >= 41 && c <= 90) {
                    this.state = 1;
                    return true;
                }
                if (c >= 91 && c <= 91) {
                    this.state = 2;
                    return true;
                }
                if (c >= 92 && c <= Integer.MAX_VALUE) {
                    this.state = 1;
                    return true;
                }
                return false;
            }
            case 2: {
                if (c >= 0 && c <= 91) {
                    this.state = 3;
                    return true;
                }
                if (c >= 92 && c <= 92) {
                    this.state = 4;
                    return true;
                }
                if (c >= 93 && c <= 93) {
                    this.state = 1;
                    return true;
                }
                if (c >= 94 && c <= Integer.MAX_VALUE) {
                    this.state = 3;
                    return true;
                }
                return false;
            }
            case 4: {
                if (c >= 0 && c <= Integer.MAX_VALUE) {
                    this.state = 2;
                    return true;
                }
                return false;
            }
            case 3: {
                if (c >= 0 && c <= 44) {
                    this.state = 3;
                    return true;
                }
                if (c >= 45 && c <= 45) {
                    this.state = 5;
                    return true;
                }
                if (c >= 46 && c <= 92) {
                    this.state = 3;
                    return true;
                }
                if (c >= 93 && c <= 93) {
                    this.state = 1;
                    return true;
                }
                if (c >= 94 && c <= Integer.MAX_VALUE) {
                    this.state = 3;
                    return true;
                }
                return false;
            }
            case 5: {
                if (c >= 0 && c <= Integer.MAX_VALUE) {
                    this.state = 2;
                    return true;
                }
                return false;
            }
            case 1: {
                if (c >= 0 && c <= 39) {
                    this.state = 1;
                    return true;
                }
                if (c >= 40 && c <= 40) {
                    this.state = 0;
                    return true;
                }
                if (c >= 41 && c <= 41) {
                    this.state = 1;
                    return true;
                }
                if (c >= 42 && c <= 42) {
                    this.state = 6;
                    return true;
                }
                if (c >= 43 && c <= 43) {
                    this.state = 6;
                    return true;
                }
                if (c >= 44 && c <= 62) {
                    this.state = 1;
                    return true;
                }
                if (c >= 63 && c <= 63) {
                    this.state = 6;
                    return true;
                }
                if (c >= 64 && c <= 90) {
                    this.state = 1;
                    return true;
                }
                if (c >= 91 && c <= 91) {
                    this.state = 2;
                    return true;
                }
                if (c >= 92 && c <= 123) {
                    this.state = 1;
                    return true;
                }
                if (c >= 124 && c <= 124) {
                    this.state = 0;
                    return true;
                }
                if (c >= 125 && c <= Integer.MAX_VALUE) {
                    this.state = 1;
                    return true;
                }
                return false;
            }
            case 6: {
                if (c >= 0 && c <= 39) {
                    this.state = 1;
                    return true;
                }
                if (c >= 40 && c <= 40) {
                    this.state = 0;
                    return true;
                }
                if (c >= 41 && c <= 41) {
                    this.state = 1;
                    return true;
                }
                if (c >= 44 && c <= 62) {
                    this.state = 1;
                    return true;
                }
                if (c >= 64 && c <= 90) {
                    this.state = 1;
                    return true;
                }
                if (c >= 91 && c <= 91) {
                    this.state = 2;
                    return true;
                }
                if (c >= 92 && c <= 123) {
                    this.state = 1;
                    return true;
                }
                if (c >= 124 && c <= 124) {
                    this.state = 0;
                    return true;
                }
                if (c >= 125 && c <= Integer.MAX_VALUE) {
                    this.state = 1;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean _accepted() {
        return this.state == 1 || this.state == 6;
    }

    private void _execaction(int $c) {
        switch (this.state) {
            case 5: {
                this.addbuf($c);
                break;
            }
            case 2: {
                this.addbuf($c);
                break;
            }
            case 0: {
                this.addor($c);
                break;
            }
            case 1: {
                this.addre($c);
                break;
            }
            case 3: {
                this.addbuf($c);
                break;
            }
            case 4: {
                this.addbuf($c);
                break;
            }
            case 6: {
                this.addcl($c);
            }
        }
    }

    private boolean _parse(Reader rd) throws IOException, RegexParseException {
        int c;
        int p = -2;
        while ((c = this._read(rd)) >= 0) {
            this._execaction(p);
            if (!this._step(c)) {
                throw new RegexParseException();
            }
            p = c;
        }
        this._execaction(p);
        return this._accepted();
    }
}

