/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.EOFObject;
import net.morilib.lisp.nano.LispCharacter;
import net.morilib.lisp.nano.LispIOException;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.NanoParser;
import net.morilib.lisp.nano.util.PeekableReader;

public class InputPort
extends Datum {
    private PeekableReader reader;
    private boolean standard;
    private boolean closed = false;
    private LispMessage msg;

    private InputPort(Reader rd, boolean std, LispMessage msg) {
        this.reader = new PeekableReader(rd);
        this.standard = std;
        this.msg = msg;
    }

    public InputPort(Reader rd, LispMessage msg) {
        this(rd, false, msg);
    }

    public InputPort(File fname, LispMessage msg) {
        try {
            InputStreamReader rd = new InputStreamReader(new FileInputStream(fname));
            this.reader = new PeekableReader(rd);
            this.standard = false;
            this.msg = msg;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public InputPort(String fname, String enconding, LispMessage msg) throws UnsupportedEncodingException {
        try {
            InputStreamReader rd = new InputStreamReader((InputStream)new FileInputStream(fname), enconding);
            this.reader = new PeekableReader(rd);
            this.standard = false;
            this.msg = msg;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public static InputPort getStandard(LispMessage msg) {
        return new InputPort(PeekableReader.in, true, msg);
    }

    public Datum readChar() {
        try {
            if (this.closed) {
                throw this.msg.getError("err.port.closed");
            }
            if (this.reader.peek() < 0) {
                return EOFObject.EOF;
            }
            int c = this.reader.read();
            if (c < 0) {
                return EOFObject.EOF;
            }
            return new LispCharacter((char)c);
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public Datum peekChar() {
        try {
            if (this.closed) {
                throw this.msg.getError("err.port.closed");
            }
            int c = this.reader.peek();
            if (c < 0) {
                return EOFObject.EOF;
            }
            return new LispCharacter((char)c);
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public Datum readS() {
        try {
            if (this.closed) {
                throw this.msg.getError("err.port.closed");
            }
            if (this.reader.peek() < 0) {
                return EOFObject.EOF;
            }
            return NanoParser.read(this.reader);
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public void close() {
        try {
            if (!this.closed && !this.standard) {
                this.reader.close();
                this.closed = true;
            }
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public boolean isStandard() {
        return this.standard;
    }

    @Override
    public boolean isTypePort() {
        return true;
    }

    /*
     * Loose catch block
     */
    public boolean ready() {
        block6: {
            if (this.closed) {
                throw this.msg.getError("err.port.closed");
            }
            if (this.reader.peek() >= 0) break block6;
            return false;
            {
                catch (IOException e) {
                    throw new LispIOException(e);
                }
            }
        }
        try {
            return this.reader.ready();
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    @Override
    public String toDisplay() {
        return "#<iport>";
    }
}

