/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.nano.value;

import java.math.BigInteger;
import java.util.regex.Pattern;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkUndefined;
import net.morilib.awk.nano.value.AwkValue;

public class AwkInteger
extends AwkValue {
    public static final AwkInteger ONE = AwkInteger.valueOf(1L);
    public static final AwkInteger ZERO = AwkInteger.valueOf(0L);
    private BigInteger value;

    private AwkInteger(BigInteger v) {
        this.value = v;
    }

    public static AwkInteger valueOf(long v) {
        return new AwkInteger(BigInteger.valueOf(v));
    }

    public static AwkInteger valueOf(BigInteger v) {
        return new AwkInteger(v);
    }

    public static AwkValue booleanOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public double toFloat() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger toInteger() {
        return this.value;
    }

    public AwkValue toNumber() {
        return this;
    }

    @Override
    public boolean toBoolean(AwkNamespace ns) {
        return this.value.signum() != 0;
    }

    public Number toReal() {
        return this.value;
    }

    public Pattern toRegex() {
        return Pattern.compile(this.value.toString());
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public boolean isFloatValue() {
        return true;
    }

    @Override
    public boolean isIntegerValue() {
        return true;
    }

    @Override
    public boolean isRealValue() {
        return true;
    }

    @Override
    public boolean isNegativeValue() {
        return this.value.signum() < 0;
    }

    @Override
    public boolean isPositiveValue() {
        return this.value.signum() > 0;
    }

    @Override
    public boolean isZeroValue() {
        return this.value.signum() == 0;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isRegex() {
        return false;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.value.signum() == 0;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AwkInteger) {
            return this.value.equals(((AwkInteger)o).value);
        }
        return false;
    }

    @Override
    public String toString(AwkNamespace ns) {
        return this.value.toString();
    }

    @Override
    public int compareTo(AwkValue o, AwkNamespace ns) {
        if (o instanceof AwkUndefined) {
            return 1;
        }
        if (o.isFloat()) {
            return this.toFloat() < o.toFloat() ? -1 : (this.toFloat() > o.toFloat() ? 1 : 0);
        }
        if (o.isInteger()) {
            return this.value.compareTo(o.toInteger());
        }
        if (ns.isIgnoreCase()) {
            return this.toString(ns).compareToIgnoreCase(o.toString(ns));
        }
        return this.toString(ns).compareTo(o.toString(ns));
    }
}

