/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.morilib.nina.Quadro;

public class QuadroImpl
extends Quadro {
    static final int EQ_TO_LEFT = -1;
    static final int BLANKX = -2;
    static final int BLANKY = -3;
    static final int E2 = -100;
    static final int W2 = -101;
    static final int N2 = -102;
    static final int S2 = -103;
    static final int E3 = -200;
    static final int W3 = -201;
    static final int N3 = -202;
    static final int S3 = -203;
    static final int DONE = -300;
    static final int ENTRY = -301;
    static final int WARP2 = -400;
    static final int WARP3 = -402;
    private int[][] quadro;
    private Object[][] scratch;
    private int curx = 0;
    private int cury = 0;
    private Object edge;
    String rootResource;
    String rootPackage;

    private QuadroImpl(List<int[]> q) {
        this.quadro = new int[q.size()][];
        this.scratch = new Object[q.size()][];
        int i = 0;
        while (i < q.size()) {
            this.quadro[i] = q.get(i);
            this.scratch[i] = new Object[q.get(i).length];
            ++i;
        }
    }

    public QuadroImpl(char[][] q) {
        this.quadro = new int[q.length][];
        this.scratch = new Object[q.length][];
        int i = 0;
        while (i < q.length) {
            this.quadro[i] = new int[q[i].length];
            this.scratch[i] = new Object[q[i].length];
            int j = 0;
            while (j < q[i].length) {
                this.quadro[i][j] = q[i][j];
                ++j;
            }
            ++i;
        }
    }

    public QuadroImpl(String[] q) {
        this.quadro = new int[q.length][];
        this.scratch = new Object[q.length][];
        int i = 0;
        while (i < q.length) {
            this.quadro[i] = new int[q[i].length()];
            this.scratch[i] = new Object[q[i].length()];
            int j = 0;
            while (j < q[i].length()) {
                this.quadro[i][j] = q[i].charAt(j);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public String getRootResource() {
        return this.rootResource;
    }

    @Override
    public String getRootPackage() {
        return this.rootPackage;
    }

    @Override
    public void setRootResource(String x) {
        this.rootResource = x;
    }

    @Override
    public void setRootPackage(String x) {
        this.rootPackage = x;
    }

    public static Quadro read(Reader rd) throws IOException {
        String s;
        BufferedReader br = new BufferedReader(rd);
        ArrayList<int[]> l = new ArrayList<int[]>();
        while ((s = br.readLine()) != null) {
            int[] a = new int[QuadroImpl.len(s)];
            int i = 0;
            while (i < s.length()) {
                int m = QuadroImpl.len(s.charAt(i));
                a[i] = s.charAt(i);
                int j = i + 1;
                while (j < i + m) {
                    a[j] = -1;
                    ++j;
                }
                i += m;
            }
            l.add(a);
        }
        return new QuadroImpl(l);
    }

    public static Quadro read(String s) {
        try {
            StringReader r = new StringReader(s);
            return QuadroImpl.read(r);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Quadro readResource(String name) throws IOException {
        InputStream in = null;
        try {
            in = Quadro.class.getResourceAsStream(name);
            InputStreamReader rd = new InputStreamReader(in);
            Quadro quadro = QuadroImpl.read(rd);
            return quadro;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Override
    public Object getEdge() {
        return this.edge;
    }

    @Override
    public void setEdge(Object edge) {
        this.edge = edge;
    }

    @Override
    public boolean isInBounds() {
        return this.cury >= 0 && this.cury < this.quadro.length && this.curx >= 0 && this.curx < this.quadro[this.cury].length;
    }

    @Override
    public int get() {
        if (this.cury < 0 || this.cury >= this.quadro.length) {
            return -3;
        }
        if (this.curx < 0 || this.curx >= this.quadro[this.cury].length) {
            return -2;
        }
        return this.quadro[this.cury][this.curx];
    }

    @Override
    public Object getScratch() {
        if (this.cury < 0 || this.cury >= this.quadro.length) {
            return null;
        }
        if (this.curx < 0 || this.curx >= this.quadro[this.cury].length) {
            return null;
        }
        return this.scratch[this.cury][this.curx];
    }

    @Override
    public boolean isBlankX() {
        return this.get() == -2;
    }

    @Override
    public boolean isBlankY() {
        return this.get() == -3;
    }

    @Override
    public boolean isLetter() {
        int c = this.get();
        return c >= 0 && Character.isLetter(c);
    }

    @Override
    public boolean isArrow() {
        return "^><v".indexOf(this.get()) >= 0;
    }

    @Override
    public boolean isEntry() {
        return this.get() == -301;
    }

    @Override
    public boolean isDone() {
        return this.get() == -300;
    }

    @Override
    public boolean isFrame() {
        return "*@=&".indexOf(this.get()) >= 0;
    }

    @Override
    public boolean isArrow2() {
        return this.get() <= -100 && this.get() >= -103;
    }

    @Override
    public boolean isArrow3() {
        return this.get() <= -200 && this.get() >= -203;
    }

    @Override
    public boolean isWhitespace() {
        return Character.isWhitespace(this.get());
    }

    @Override
    public void set(int a) {
        if (this.isInBounds()) {
            this.quadro[this.cury][this.curx] = a;
        }
    }

    @Override
    public void setScratch(Object a) {
        if (this.isInBounds()) {
            this.scratch[this.cury][this.curx] = a;
        }
    }

    @Override
    public QuadroImpl move(Quadro.Direction d) {
        switch (d) {
            case WEST: {
                this.curx = this.curx < 0 ? this.curx : this.curx - 1;
                return this;
            }
            case EAST: {
                this.curx = this.cury < 0 || this.cury >= this.quadro.length || this.curx > this.quadro[this.cury].length ? this.curx : this.curx + 1;
                return this;
            }
            case NORTH: {
                this.cury = this.cury < 0 ? this.cury : this.cury - 1;
                return this;
            }
            case SOUTH: {
                this.cury = this.cury > this.quadro.length ? this.cury : this.cury + 1;
                return this;
            }
            case CR: {
                this.curx = 0;
                this.cury = this.cury > this.quadro.length ? this.cury : this.cury + 1;
                return this;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public QuadroImpl move(int x, int y) {
        if (this.cury + y < 0) {
            this.cury = -1;
        } else if (this.cury + y > this.quadro.length) {
            this.cury = this.quadro.length;
        }
        if (this.curx + x < 0) {
            this.curx = -1;
        } else if (this.curx + x > this.quadro[this.cury].length) {
            this.curx = this.quadro[this.cury].length;
        }
        return this;
    }

    @Override
    public QuadroImpl west() {
        return this.move(Quadro.Direction.WEST);
    }

    @Override
    public QuadroImpl east() {
        return this.move(Quadro.Direction.EAST);
    }

    @Override
    public QuadroImpl north() {
        return this.move(Quadro.Direction.NORTH);
    }

    @Override
    public QuadroImpl south() {
        return this.move(Quadro.Direction.SOUTH);
    }

    @Override
    public QuadroImpl cr() {
        return this.move(Quadro.Direction.CR);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.quadro.length) {
            int j = 0;
            while (j < this.quadro[i].length) {
                if (this.cury == i && this.curx == j) {
                    b.append('@');
                } else {
                    switch (this.quadro[i][j]) {
                        case -1: {
                            break;
                        }
                        case -2: {
                            b.append('$');
                            break;
                        }
                        case -3: {
                            b.append('#');
                            break;
                        }
                        case -102: {
                            b.append('^');
                            break;
                        }
                        case -100: {
                            b.append('>');
                            break;
                        }
                        case -103: {
                            b.append('v');
                            break;
                        }
                        case -101: {
                            b.append('<');
                            break;
                        }
                        case -202: {
                            b.append('A');
                            break;
                        }
                        case -200: {
                            b.append(')');
                            break;
                        }
                        case -203: {
                            b.append('w');
                            break;
                        }
                        case -201: {
                            b.append('(');
                            break;
                        }
                        case -300: {
                            b.append('0');
                            break;
                        }
                        default: {
                            if (this.quadro[i][j] >= 0) {
                                b.append((char)this.quadro[i][j]);
                                break;
                            }
                            b.append('.');
                        }
                    }
                }
                ++j;
            }
            b.append('\n');
            ++i;
        }
        return b.toString();
    }
}

