/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.util.HashSet;
import java.util.Set;
import net.morilib.nina.TinyMap;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.util.TreeSectionMap;
import net.morilib.util.Tuple2;

public class NinaMap<T, V>
implements TinyMap<T, V> {
    private TreeSectionMap<Interval, Object, V> map = null;
    private V eps = null;

    NinaMap() {
    }

    void put(T key, V value) {
        if (key == null) {
            this.eps = value;
        } else if (this.map == null) {
            this.map = new TreeSectionMap(Interval.newPoint(key), value);
        } else {
            this.map.insert(Interval.newPoint(key), value);
        }
    }

    void put(Range key, V value) {
        if (key == null || key.isEmpty()) {
            this.eps = value;
        } else {
            for (Interval a : key.intervals()) {
                if (this.map == null) {
                    this.map = new TreeSectionMap(a, value);
                    continue;
                }
                this.map.insert(a, value);
            }
        }
    }

    @Override
    public V get(T key) {
        if (key != null) {
            return this.map != null ? (V)this.map.map(key) : null;
        }
        return this.eps;
    }

    @Override
    public Range getKeyRange() {
        RangeAdder a = new RangeAdder();
        if (this.map != null) {
            for (Interval e : this.map.keys()) {
                a.addInterval(e);
            }
        }
        return a.toRange();
    }

    @Override
    public Set<T> getDiscreteKeys() {
        HashSet<Object> r = new HashSet<Object>();
        if (this.map != null) {
            for (Interval e : this.map.keys()) {
                Object b;
                Object a = e.getInfimumBound();
                if (a.equals(b = e.getSupremumBound())) {
                    r.add(a);
                    continue;
                }
                if (a instanceof Character) {
                    int ac;
                    int i = ac = ((Character)a).charValue();
                    while (e.contains(i)) {
                        r.add(i);
                        ++i;
                    }
                    continue;
                }
                throw new ClassCastException();
            }
        }
        return r;
    }

    @Override
    public Set<V> valueSet() {
        HashSet<V> r = new HashSet<V>();
        if (this.map != null) {
            for (Tuple2<Interval, V> e : this.map.entries()) {
                r.add(e.getB());
            }
        }
        return r;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        String d = "";
        if (this.map != null) {
            for (Tuple2<Interval, V> e : this.map.entries()) {
                b.append(d).append("<<").append(e.getA());
                b.append(" , ").append(e.getB()).append(">>");
                d = "\n";
            }
        }
        return b.toString();
    }
}

