/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.dfa;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.DFA;
import net.morilib.automata.DFAState;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFAs;
import net.morilib.automata.nfa.NFAs;
import net.morilib.util.ArrayListStack;

public class ConvertedDFA<T, O, B>
implements DFA<T, O, B> {
    private Map<Object, Map<T, State>> graph = new IdentityHashMap<Object, Map<T, State>>();
    private Map<Object, EnumMap<TextBound, State>> boundgraph = new IdentityHashMap<Object, EnumMap<TextBound, State>>();
    private Map<Object, State> states = new HashMap<Object, State>();
    private Map<Object, Set<O>> accept = new IdentityHashMap<Object, Set<O>>();
    private Map<Object, Set<B>> tags = new IdentityHashMap<Object, Set<B>>();
    private State initial;

    private void addTrans(Object st, T i, Object nst) {
        State n = this.getState(nst);
        Map<T, State> edges = this.graph.get(st);
        if (edges == null) {
            edges = new HashMap<T, State>();
            this.graph.put(st, edges);
        }
        edges.put(i, n);
    }

    private void addTransBound(Object st, TextBound b, Object nst) {
        State n = this.getState(nst);
        EnumMap<TextBound, State> edges = this.boundgraph.get(st);
        if (edges == null) {
            edges = new EnumMap(TextBound.class);
            this.boundgraph.put(st, edges);
        }
        edges.put(b, n);
    }

    private State getState(Object o) {
        State s = this.states.get(o);
        if (s == null) {
            s = new State(o);
            this.states.put(o, s);
        }
        return s;
    }

    private void setInitialState(Object o) {
        this.initial = this.getState(o);
    }

    @Override
    public DFAState<T, O, B> getInitialState() {
        return this.initial;
    }

    public static <T, A, B> DFA<T, A, B> convertDFA(NFA<T, A, B> nfa) {
        HashMap<Set<NFAState>, Set<NFAState>> dstates = new HashMap<Set<NFAState>, Set<NFAState>>();
        ArrayListStack stk = new ArrayListStack();
        ConvertedDFA res = new ConvertedDFA();
        Set<NFAState> init = NFAs.getEpsilonReachable(nfa, nfa.getInitialStates());
        super.setInitialState(init);
        stk.push(init);
        while (!stk.isEmpty()) {
            Set t = (Set)stk.pop();
            dstates.put(t, t);
            res.tags.put(t, NFAs.getMatchTag(nfa, t));
            res.accept.put(t, NFAs.getAccept(nfa, t));
            for (T r : nfa.nextDiscreteAlphabets(t)) {
                Set<NFAState> u = NFAs.getEpsilonReachable(nfa, NFAs.getStates(nfa, (Set<NFAState>)t, r));
                Set<NFAState> z = (Set<NFAState>)dstates.get(u);
                if (z == null) {
                    dstates.put(u, u);
                    stk.push(u);
                    z = u;
                }
                super.addTrans(t, r, z);
            }
            for (TextBound b : TextBound.ALL) {
                EnumSet<TextBound> bs = EnumSet.of(b);
                Set<NFAState> u = NFAs.getEpsilonReachable(nfa, NFAs.getStatesBound(nfa, t, bs));
                if (u.isEmpty()) continue;
                Set<NFAState> z = (Set<NFAState>)dstates.get(u);
                if (z == null) {
                    dstates.put(u, u);
                    stk.push(u);
                    z = u;
                }
                super.addTransBound(t, b, z);
            }
        }
        return res;
    }

    private class State
    implements DFAState<T, O, B> {
        private Object st;

        private State(Object st) {
            this.st = st;
        }

        @Override
        public DFAState<T, O, B> go(T alphabet) {
            Map ts = (Map)ConvertedDFA.this.graph.get(this.st);
            if (ts == null) {
                return DFAs.deadState();
            }
            State s2 = (State)ts.get(alphabet);
            if (s2 == null) {
                return DFAs.deadState();
            }
            return s2;
        }

        @Override
        public DFAState<T, O, B> goBound(TextBound bound) {
            EnumMap ts = (EnumMap)ConvertedDFA.this.boundgraph.get(this.st);
            if (ts == null) {
                return DFAs.deadState();
            }
            State s2 = (State)ts.get((Object)bound);
            if (s2 == null) {
                return DFAs.deadState();
            }
            return s2;
        }

        @Override
        public Set<O> getAccepted() {
            Set res = (Set)ConvertedDFA.this.accept.get(this.st);
            return res == null ? Collections.emptySet() : res;
        }

        @Override
        public boolean isInitialState() {
            return ConvertedDFA.this.initial == this.st;
        }

        @Override
        public boolean isDead() {
            return false;
        }

        @Override
        public DFAState<T, O, B> goInt(int x) {
            return this.go(x);
        }

        @Override
        public DFAState<T, O, B> goChar(char x) {
            return this.go(Integer.valueOf(x));
        }

        @Override
        public boolean isAccepted() {
            Set res = (Set)ConvertedDFA.this.accept.get(this.st);
            return res != null && !res.isEmpty();
        }

        @Override
        public Set<T> getAlphabets() {
            Map ts = (Map)ConvertedDFA.this.graph.get(this.st);
            if (ts == null) {
                return Collections.emptySet();
            }
            return ts.keySet();
        }
    }
}

