/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.Serializable;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StringConverter;

public class StringEditConverter
implements StringConverter,
Serializable {
    private static final long serialVersionUID = -3531421350654717601L;
    private boolean isTrim;
    private boolean isToLowerCase;
    private boolean isToUpperCase;
    private boolean isToCapitalize;
    private int startIndex = -1;
    private int endIndex = -1;
    private boolean isIgnoreArrayIndexOutOfBounds;

    public void setTrim(boolean trim) {
        this.isTrim = trim;
    }

    public boolean isTrim() {
        return this.isTrim;
    }

    public void setToLowerCase(boolean lower) {
        this.isToLowerCase = lower;
        if (this.isToLowerCase && this.isToUpperCase) {
            this.isToUpperCase = false;
        }
    }

    public boolean isToLowerCase() {
        return this.isToLowerCase;
    }

    public void setToUpperCase(boolean upper) {
        this.isToUpperCase = upper;
        if (this.isToLowerCase && this.isToUpperCase) {
            this.isToLowerCase = false;
        }
    }

    public boolean isToUpperCase() {
        return this.isToUpperCase;
    }

    public void setToCapitalize(boolean capitalize) {
        this.isToCapitalize = capitalize;
    }

    public boolean isToCapitalize() {
        return this.isToCapitalize;
    }

    public void setStartIndex(int index) {
        this.startIndex = index;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setEndIndex(int index) {
        this.endIndex = index;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setIgnoreArrayIndexOutOfBounds(boolean isIgnore) {
        this.isIgnoreArrayIndexOutOfBounds = isIgnore;
    }

    public boolean isIgnoreArrayIndexOutOfBounds() {
        return this.isIgnoreArrayIndexOutOfBounds;
    }

    public Object convert(Object obj) throws ConvertException {
        return this.convert(obj == null ? null : obj.toString());
    }

    public String convert(String str) throws ConvertException {
        if (str == null || str.length() == 0) {
            return str;
        }
        String result = str;
        if (this.isTrim) {
            result = result.trim();
        }
        int sIndex = this.startIndex;
        int eIndex = this.endIndex;
        if (this.isIgnoreArrayIndexOutOfBounds) {
            if (sIndex > 0 && sIndex >= result.length()) {
                sIndex = result.length();
            }
            if (eIndex > 1 && eIndex > result.length()) {
                eIndex = result.length();
            }
        }
        if (sIndex == 0) {
            sIndex = -1;
        }
        if (eIndex == result.length()) {
            eIndex = -1;
        }
        if (sIndex >= 0 && eIndex >= 0) {
            try {
                result = result.substring(sIndex, eIndex);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConvertException(e);
            }
        }
        if (sIndex >= 0) {
            try {
                result = result.substring(sIndex);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConvertException(e);
            }
        }
        if (eIndex >= 0) {
            try {
                result = result.substring(0, eIndex);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConvertException(e);
            }
        }
        if (this.isToLowerCase) {
            result = result.toLowerCase();
        } else if (this.isToUpperCase) {
            result = result.toUpperCase();
        }
        if (this.isToCapitalize) {
            result = Character.toUpperCase(result.charAt(0)) + result.substring(1);
        }
        return result;
    }
}

