/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.FormatConverter;

public class PropertyEditorConverter
implements FormatConverter {
    private static final long serialVersionUID = 1236107411843329600L;
    protected int convertType;
    protected Class type;
    protected Map editorMap;
    protected Map propertyMap;

    public PropertyEditorConverter() {
        this(1, String.class.getName());
    }

    public PropertyEditorConverter(int type, String className) {
        this.convertType = type;
        this.setFormat(className);
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setFormat(String className) {
        try {
            this.type = Utility.convertStringToClass(className, false);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String getFormat() {
        return this.type == null ? String.class.getName() : this.type.getName();
    }

    public void setEditorProperty(String name, Object value) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        this.propertyMap.put(PropertyFactory.createProperty(name), value);
    }

    public void registerEditor(Class clazz, Class editorClass) {
        if (this.editorMap == null) {
            this.editorMap = Collections.synchronizedMap(new HashMap());
        }
        this.editorMap.put(clazz, editorClass);
    }

    protected PropertyEditor findEditor(Class clazz) {
        Class editorClass;
        PropertyEditor editor = null;
        Class clazz2 = editorClass = this.editorMap == null ? null : (Class)this.editorMap.get(clazz);
        if (editorClass != null) {
            try {
                editor = (PropertyEditor)editorClass.newInstance();
            }
            catch (ClassCastException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        if (editor == null) {
            editor = NimbusPropertyEditorManager.findEditor(clazz);
        }
        if (editor != null && this.propertyMap != null) {
            Iterator entries = this.propertyMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                try {
                    ((Property)entry.getKey()).setProperty(editor, entry.getValue());
                }
                catch (NoSuchPropertyException e) {
                }
                catch (InvocationTargetException e) {}
            }
        }
        return editor;
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        Class<?> inType = obj.getClass();
        PropertyEditor editor = null;
        switch (this.convertType) {
            case 2: {
                String str = null;
                str = obj instanceof String ? (String)obj : obj.toString();
                editor = this.findEditor(this.type);
                if (editor == null) {
                    throw new ConvertException("PropertyEditor not found. type=" + this.type.getName());
                }
                try {
                    editor.setAsText(str);
                    return editor.getValue();
                }
                catch (Exception e) {
                    throw new ConvertException(e);
                }
            }
            case 1: {
                if (obj instanceof String) {
                    return obj;
                }
                editor = this.findEditor(inType);
                if (editor == null) {
                    throw new ConvertException("PropertyEditor not found. type=" + inType.getName());
                }
                try {
                    editor.setValue(obj);
                    return editor.getAsText();
                }
                catch (Exception e) {
                    throw new ConvertException(e);
                }
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }
}

