/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StreamStringConverter;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMHTMLConverter
implements StreamStringConverter,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6085930913740530834L;
    public static final int DOM_TO_HTML = 1;
    public static final int HTML_TO_DOM = 2;
    public static final Map IANA2JAVA_ENCODING_MAP = new HashMap();
    protected int convertType;
    protected String characterEncodingToStream;
    protected String characterEncodingToObject;
    protected String xslFilePath;
    protected boolean isSynchronizedDomParse;
    protected Properties transformerOutputProperties;

    public DOMHTMLConverter() {
        this(1);
    }

    public DOMHTMLConverter(int type) {
        this.convertType = type;
    }

    public void setConvertType(int type) {
        this.convertType = type;
    }

    public int getConvertType() {
        return this.convertType;
    }

    public void setCharacterEncodingToStream(String encoding) {
        this.characterEncodingToStream = encoding;
    }

    public String getCharacterEncodingToStream() {
        return this.characterEncodingToStream;
    }

    public void setCharacterEncodingToObject(String encoding) {
        this.characterEncodingToObject = encoding;
    }

    public String getCharacterEncodingToObject() {
        return this.characterEncodingToObject;
    }

    public StreamStringConverter cloneCharacterEncodingToStream(String encoding) {
        if (encoding == null && this.characterEncodingToStream == null || encoding != null && encoding.equals(this.characterEncodingToStream)) {
            return this;
        }
        try {
            StreamStringConverter clone = (StreamStringConverter)super.clone();
            clone.setCharacterEncodingToStream(encoding);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public StreamStringConverter cloneCharacterEncodingToObject(String encoding) {
        if (encoding == null && this.characterEncodingToObject == null || encoding != null && encoding.equals(this.characterEncodingToObject)) {
            return this;
        }
        try {
            StreamStringConverter clone = (StreamStringConverter)super.clone();
            clone.setCharacterEncodingToObject(encoding);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setXSLFilePath(String path) {
        this.xslFilePath = path;
    }

    public String getXSLFilePath() {
        return this.xslFilePath;
    }

    public void setSynchronizedDomParse(boolean isSync) {
        this.isSynchronizedDomParse = isSync;
    }

    public boolean isSynchronizedDomParse() {
        return this.isSynchronizedDomParse;
    }

    public void setTransformerOutputProperty(String name, String value) {
        if (this.transformerOutputProperties == null) {
            this.transformerOutputProperties = new Properties();
        }
        this.transformerOutputProperties.setProperty(name, value);
    }

    public String getTransformerOutputProperty(String name) {
        if (this.transformerOutputProperties == null) {
            return null;
        }
        return this.transformerOutputProperties.getProperty(name);
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        switch (this.convertType) {
            case 1: {
                return this.convertToStream(obj);
            }
            case 2: {
                if (obj instanceof File) {
                    return this.toDOM((File)obj);
                }
                if (obj instanceof InputStream) {
                    return this.toDOM((InputStream)obj);
                }
                throw new ConvertException("Invalid input type : " + obj.getClass());
            }
        }
        throw new ConvertException("Invalid convert type : " + this.convertType);
    }

    public InputStream convertToStream(Object obj) throws ConvertException {
        if (obj instanceof Document) {
            return this.toHTML((Document)obj);
        }
        throw new ConvertException("Invalid input type : " + obj.getClass());
    }

    public Object convertToObject(InputStream is) throws ConvertException {
        return this.toDOM(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document toDOM(InputStream is) throws ConvertException {
        DOMParser parser = new DOMParser();
        try {
            InputSource inputSource = new InputSource(is);
            if (this.characterEncodingToObject != null) {
                String encoding = (String)IANA2JAVA_ENCODING_MAP.get(this.characterEncodingToObject);
                if (encoding == null) {
                    encoding = this.characterEncodingToObject;
                }
                inputSource.setEncoding(encoding);
            }
            if (this.isSynchronizedDomParse) {
                Class<?> lock;
                Class<?> clazz = lock = parser.getClass();
                synchronized (clazz) {
                    parser.parse(inputSource);
                }
            } else {
                parser.parse(inputSource);
            }
            return parser.getDocument();
        }
        catch (SAXException e) {
            throw new ConvertException(e);
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected Document toDOM(File file) throws ConvertException {
        try {
            return this.toDOM(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new ConvertException(e);
        }
    }

    protected InputStream toHTML(Document document) throws ConvertException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            transformer = this.xslFilePath == null ? tFactory.newTransformer() : tFactory.newTransformer(new StreamSource(this.xslFilePath));
            if (this.characterEncodingToStream != null) {
                String encoding = (String)IANA2JAVA_ENCODING_MAP.get(this.characterEncodingToStream);
                if (encoding == null) {
                    encoding = this.characterEncodingToStream;
                }
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.setOutputProperty("method", "html");
            if (this.transformerOutputProperties != null) {
                Iterator<Map.Entry<Object, Object>> entries = this.transformerOutputProperties.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<Object, Object> entry = entries.next();
                    transformer.setOutputProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(document), new StreamResult(baos));
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ConvertException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new ConvertException(e);
        }
        catch (TransformerException e) {
            throw new ConvertException(e);
        }
    }

    static {
        IANA2JAVA_ENCODING_MAP.put("ISO8859_1", "ISO-8859-1");
        IANA2JAVA_ENCODING_MAP.put("ISO8859_2", "ISO-8859-2");
        IANA2JAVA_ENCODING_MAP.put("ISO8859_3", "ISO-8859-3");
        IANA2JAVA_ENCODING_MAP.put("ISO8859_4", "ISO-8859-4");
        IANA2JAVA_ENCODING_MAP.put("ISO8859_5", "ISO-8859-5");
        IANA2JAVA_ENCODING_MAP.put("ISO8859_6", "ISO-8859-6");
        IANA2JAVA_ENCODING_MAP.put("ISO8859_7", "ISO-8859-7");
        IANA2JAVA_ENCODING_MAP.put("ISO8859_8", "ISO-8859-8");
        IANA2JAVA_ENCODING_MAP.put("ISO8859_9", "ISO-8859-9");
        IANA2JAVA_ENCODING_MAP.put("ISO8859_15", "ISO-8859-15");
        IANA2JAVA_ENCODING_MAP.put("Big5", "BIG5");
        IANA2JAVA_ENCODING_MAP.put("CP037", "EBCDIC-CP-US");
        IANA2JAVA_ENCODING_MAP.put("CP273", "IBM273");
        IANA2JAVA_ENCODING_MAP.put("CP277", "EBCDIC-CP-DK");
        IANA2JAVA_ENCODING_MAP.put("CP278", "EBCDIC-CP-FI");
        IANA2JAVA_ENCODING_MAP.put("CP280", "EBCDIC-CP-IT");
        IANA2JAVA_ENCODING_MAP.put("CP284", "EBCDIC-CP-ES");
        IANA2JAVA_ENCODING_MAP.put("CP285", "EBCDIC-CP-GB");
        IANA2JAVA_ENCODING_MAP.put("CP290", "EBCDIC-JP-KANA");
        IANA2JAVA_ENCODING_MAP.put("CP297", "EBCDIC-CP-FR");
        IANA2JAVA_ENCODING_MAP.put("CP420", "EBCDIC-CP-AR1");
        IANA2JAVA_ENCODING_MAP.put("CP424", "EBCDIC-CP-HE");
        IANA2JAVA_ENCODING_MAP.put("CP437", "IBM437");
        IANA2JAVA_ENCODING_MAP.put("CP500", "EBCDIC-CP-CH");
        IANA2JAVA_ENCODING_MAP.put("CP775", "IBM775");
        IANA2JAVA_ENCODING_MAP.put("CP850", "IBM850");
        IANA2JAVA_ENCODING_MAP.put("CP852", "IBM852");
        IANA2JAVA_ENCODING_MAP.put("CP855", "IBM855");
        IANA2JAVA_ENCODING_MAP.put("CP857", "IBM857");
        IANA2JAVA_ENCODING_MAP.put("CP858", "IBM00858");
        IANA2JAVA_ENCODING_MAP.put("CP860", "IBM860");
        IANA2JAVA_ENCODING_MAP.put("CP861", "IBM861");
        IANA2JAVA_ENCODING_MAP.put("CP862", "IBM862");
        IANA2JAVA_ENCODING_MAP.put("CP863", "IBM863");
        IANA2JAVA_ENCODING_MAP.put("CP864", "IBM864");
        IANA2JAVA_ENCODING_MAP.put("CP865", "IBM865");
        IANA2JAVA_ENCODING_MAP.put("CP866", "IBM866");
        IANA2JAVA_ENCODING_MAP.put("CP868", "IBM868");
        IANA2JAVA_ENCODING_MAP.put("CP869", "IBM869");
        IANA2JAVA_ENCODING_MAP.put("CP870", "EBCDIC-CP-ROECE");
        IANA2JAVA_ENCODING_MAP.put("CP871", "EBCDIC-CP-IS");
        IANA2JAVA_ENCODING_MAP.put("CP918", "EBCDIC-CP-AR2");
        IANA2JAVA_ENCODING_MAP.put("CP924", "IBM00924");
        IANA2JAVA_ENCODING_MAP.put("CP1026", "IBM1026");
        IANA2JAVA_ENCODING_MAP.put("Cp01140", "IBM01140");
        IANA2JAVA_ENCODING_MAP.put("Cp01141", "IBM01141");
        IANA2JAVA_ENCODING_MAP.put("Cp01142", "IBM01142");
        IANA2JAVA_ENCODING_MAP.put("Cp01143", "IBM01143");
        IANA2JAVA_ENCODING_MAP.put("Cp01144", "IBM01144");
        IANA2JAVA_ENCODING_MAP.put("Cp01145", "IBM01145");
        IANA2JAVA_ENCODING_MAP.put("Cp01146", "IBM01146");
        IANA2JAVA_ENCODING_MAP.put("Cp01147", "IBM01147");
        IANA2JAVA_ENCODING_MAP.put("Cp01148", "IBM01148");
        IANA2JAVA_ENCODING_MAP.put("Cp01149", "IBM01149");
        IANA2JAVA_ENCODING_MAP.put("EUCJIS", "EUC-JP");
        IANA2JAVA_ENCODING_MAP.put("GB2312", "GB2312");
        IANA2JAVA_ENCODING_MAP.put("ISO2022KR", "ISO-2022-KR");
        IANA2JAVA_ENCODING_MAP.put("ISO2022CN", "ISO-2022-CN");
        IANA2JAVA_ENCODING_MAP.put("JIS", "ISO-2022-JP");
        IANA2JAVA_ENCODING_MAP.put("KOI8_R", "KOI8-R");
        IANA2JAVA_ENCODING_MAP.put("KSC5601", "EUC-KR");
        IANA2JAVA_ENCODING_MAP.put("GB18030", "GB18030");
        IANA2JAVA_ENCODING_MAP.put("GBK", "GBK");
        IANA2JAVA_ENCODING_MAP.put("SJIS", "SHIFT_JIS");
        IANA2JAVA_ENCODING_MAP.put("MS932", "WINDOWS-31J");
        IANA2JAVA_ENCODING_MAP.put("UTF8", "UTF-8");
        IANA2JAVA_ENCODING_MAP.put("Unicode", "UTF-16");
        IANA2JAVA_ENCODING_MAP.put("UnicodeBig", "UTF-16BE");
        IANA2JAVA_ENCODING_MAP.put("UnicodeLittle", "UTF-16LE");
        IANA2JAVA_ENCODING_MAP.put("JIS0201", "X0201");
        IANA2JAVA_ENCODING_MAP.put("JIS0208", "X0208");
        IANA2JAVA_ENCODING_MAP.put("JIS0212", "ISO-IR-159");
        IANA2JAVA_ENCODING_MAP.put("CP1047", "IBM1047");
    }
}

