/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.util.converter.BindingStreamConverter;
import jp.ossc.nimbus.util.converter.CharacterConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.Converter;
import jp.ossc.nimbus.util.converter.ReversibleConverter;
import jp.ossc.nimbus.util.converter.StreamConverter;
import jp.ossc.nimbus.util.converter.StreamStringConverter;
import jp.ossc.nimbus.util.converter.StringConverter;

public class CustomConverter
implements Converter,
StringConverter,
CharacterConverter,
StreamStringConverter,
BindingStreamConverter,
Serializable,
Cloneable {
    private static final long serialVersionUID = 727589924434574684L;
    protected List converters;

    public CustomConverter() {
    }

    public CustomConverter(Converter[] convs) {
        if (convs != null && convs.length != 0) {
            this.converters = new ArrayList();
            for (int i = 0; i < convs.length; ++i) {
                this.converters.add(convs[i]);
            }
        }
    }

    public void setConvertType(int type) {
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.converters.get(i) instanceof ReversibleConverter)) continue;
                ((ReversibleConverter)this.converters.get(i)).setConvertType(type);
            }
        }
    }

    public void setCharacterEncodingToStream(String encoding) {
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.converters.get(i) instanceof StreamStringConverter)) continue;
                ((StreamStringConverter)this.converters.get(i)).setCharacterEncodingToStream(encoding);
            }
        }
    }

    public String getCharacterEncodingToStream() {
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.converters.get(i) instanceof StreamStringConverter)) continue;
                return ((StreamStringConverter)this.converters.get(i)).getCharacterEncodingToStream();
            }
        }
        return null;
    }

    public void setCharacterEncodingToObject(String encoding) {
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.converters.get(i) instanceof StreamStringConverter)) continue;
                ((StreamStringConverter)this.converters.get(i)).setCharacterEncodingToObject(encoding);
            }
        }
    }

    public String getCharacterEncodingToObject() {
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.converters.get(i) instanceof StreamStringConverter)) continue;
                return ((StreamStringConverter)this.converters.get(i)).getCharacterEncodingToObject();
            }
        }
        return null;
    }

    public StreamStringConverter cloneCharacterEncodingToStream(String encoding) {
        try {
            CustomConverter clone = (CustomConverter)this.clone();
            if (this.converters != null) {
                clone.converters = new ArrayList();
                int max = this.converters.size();
                for (int i = 0; i < max; ++i) {
                    if (this.converters.get(i) instanceof StreamStringConverter) {
                        clone.converters.add(((StreamStringConverter)this.converters.get(i)).cloneCharacterEncodingToStream(encoding));
                        continue;
                    }
                    clone.converters.add(this.converters.get(i));
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public StreamStringConverter cloneCharacterEncodingToObject(String encoding) {
        try {
            CustomConverter clone = (CustomConverter)this.clone();
            if (this.converters != null) {
                clone.converters = new ArrayList();
                int max = this.converters.size();
                for (int i = 0; i < max; ++i) {
                    if (this.converters.get(i) instanceof StreamStringConverter) {
                        clone.converters.add(((StreamStringConverter)this.converters.get(i)).cloneCharacterEncodingToObject(encoding));
                        continue;
                    }
                    clone.converters.add(this.converters.get(i));
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Converter add(Converter converter) {
        if (this.converters == null) {
            this.converters = new ArrayList();
        }
        this.converters.add(converter);
        return this;
    }

    public void remove(Converter converter) {
        if (this.converters == null) {
            return;
        }
        this.converters.remove(converter);
    }

    public void clear() {
        if (this.converters == null) {
            return;
        }
        this.converters.clear();
    }

    public Object convert(Object obj) throws ConvertException {
        Object tmp = obj;
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                tmp = ((Converter)this.converters.get(i)).convert(tmp);
            }
        }
        return tmp;
    }

    public String convert(String str) throws ConvertException {
        Object tmp = str;
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                tmp = ((Converter)this.converters.get(i)).convert(tmp);
            }
        }
        return tmp;
    }

    public char convert(char c) throws ConvertException {
        char tmp = c;
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                if (!(this.converters.get(i) instanceof CharacterConverter)) continue;
                tmp = ((CharacterConverter)this.converters.get(i)).convert(tmp);
            }
        }
        return tmp;
    }

    public Character convert(Character c) throws ConvertException {
        Object tmp = c;
        if (this.converters != null) {
            int max = this.converters.size();
            for (int i = 0; i < max; ++i) {
                tmp = ((Converter)this.converters.get(i)).convert(tmp);
            }
        }
        return tmp;
    }

    public InputStream convertToStream(Object obj) throws ConvertException {
        Object tmp = obj;
        if (this.converters != null && this.converters.size() > 0) {
            if (this.converters.size() > 1) {
                int max = this.converters.size() - 1;
                for (int i = 0; i < max; ++i) {
                    tmp = ((Converter)this.converters.get(i)).convert(tmp);
                }
            }
            tmp = ((StreamConverter)this.converters.get(this.converters.size() - 1)).convertToStream(tmp);
        }
        return (InputStream)tmp;
    }

    public Object convertToObject(InputStream is) throws ConvertException {
        Object tmp = is;
        if (this.converters != null && this.converters.size() > 0) {
            tmp = ((StreamConverter)this.converters.get(0)).convertToObject(is);
            if (this.converters.size() > 1) {
                int max = this.converters.size();
                for (int i = 1; i < max; ++i) {
                    tmp = ((Converter)this.converters.get(i)).convert(tmp);
                }
            }
        }
        return tmp;
    }

    public Object convertToObject(InputStream is, Object returnType) throws ConvertException {
        Object tmp = is;
        if (this.converters != null && this.converters.size() > 0) {
            tmp = this.converters.get(0) instanceof BindingStreamConverter ? ((BindingStreamConverter)this.converters.get(0)).convertToObject(is, returnType) : ((StreamConverter)this.converters.get(0)).convertToObject(is);
            if (this.converters.size() > 1) {
                int max = this.converters.size();
                for (int i = 1; i < max; ++i) {
                    tmp = this.converters.get(i) instanceof BindingStreamConverter && tmp instanceof InputStream ? ((BindingStreamConverter)this.converters.get(i)).convertToObject((InputStream)tmp, returnType) : ((Converter)this.converters.get(i)).convert(tmp);
                }
            }
        }
        return tmp;
    }
}

