/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.converter;

import java.io.Serializable;
import jp.ossc.nimbus.util.converter.CharacterConverter;
import jp.ossc.nimbus.util.converter.ConvertException;
import jp.ossc.nimbus.util.converter.StringConverter;

public class CustomCharacterMapConverter
implements CharacterConverter,
StringConverter,
Serializable {
    private static final long serialVersionUID = -1803120054841953689L;
    protected boolean[] charMapArray = null;
    protected char toChar = (char)63;
    protected Character toCharacter = new Character(this.toChar);
    protected boolean isTarget = true;

    public CustomCharacterMapConverter() {
    }

    public CustomCharacterMapConverter(char[] chars, char toChar, boolean isTarget) {
        this.setCharMap(chars);
        this.setToChar(toChar);
        this.isTarget = isTarget;
    }

    public void setCharMap(char[] chars) {
        int i;
        if (this.charMapArray == null) {
            if (chars != null) {
                this.charMapArray = new boolean[65536];
            }
        } else {
            for (i = 0; i < this.charMapArray.length; ++i) {
                this.charMapArray[i] = false;
            }
        }
        if (chars != null) {
            for (i = 0; i < chars.length; ++i) {
                this.charMapArray[chars[i]] = true;
            }
        }
    }

    public void addCharMap(char[] chars) {
        if (chars == null || chars.length == 0) {
            return;
        }
        if (this.charMapArray == null) {
            this.charMapArray = new boolean[65536];
        }
        for (int i = 0; i < chars.length; ++i) {
            this.charMapArray[chars[i]] = true;
        }
    }

    public void addChar(char c) {
        if (this.charMapArray == null) {
            this.charMapArray = new boolean[65536];
        }
        this.charMapArray[c] = true;
    }

    public void setCharRange(char from, char to) {
        int i;
        if (from > to) {
            throw new IllegalArgumentException("from > to.");
        }
        if (this.charMapArray == null) {
            this.charMapArray = new boolean[65536];
        } else {
            for (i = 0; i < this.charMapArray.length; ++i) {
                this.charMapArray[i] = false;
            }
        }
        for (i = from; i <= to; ++i) {
            this.charMapArray[i] = true;
        }
    }

    public void addCharRange(char from, char to) {
        if (from > to) {
            throw new IllegalArgumentException("from > to.");
        }
        if (this.charMapArray == null) {
            this.charMapArray = new boolean[65536];
        }
        for (int i = from; i <= to; ++i) {
            this.charMapArray[i] = true;
        }
    }

    public void setToChar(char c) {
        this.toChar = c;
        this.toCharacter = new Character(this.toChar);
    }

    public char getToChar() {
        return this.toChar;
    }

    public void setTarget(boolean isTarget) {
        this.isTarget = isTarget;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public Object convert(Object obj) throws ConvertException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Character) {
            return this.convert((Character)obj);
        }
        if (obj instanceof String) {
            return this.convert((String)obj);
        }
        return obj;
    }

    public char convert(char c) throws ConvertException {
        if (this.charMapArray == null) {
            return c;
        }
        return this.charMapArray[c] ? (this.isTarget ? this.toChar : c) : (this.isTarget ? c : this.toChar);
    }

    public Character convert(Character c) throws ConvertException {
        char to;
        char from = c.charValue();
        return from == (to = this.convert(from)) ? c : this.toCharacter;
    }

    public String convert(String str) throws ConvertException {
        char[] chars = str.toCharArray();
        char[] result = new char[chars.length];
        boolean isConvert = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = this.convert(chars[i]);
            if (c != chars[i] && !isConvert) {
                result = new char[chars.length];
                System.arraycopy(chars, 0, result, 0, i);
                isConvert = true;
            }
            if (!isConvert) continue;
            result[i] = c;
        }
        return isConvert ? new String(result) : str;
    }
}

